/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.AsciiCP;
import jas.CP;
import jas.ClassEnv;
import jas.CodeAttr;
import jas.VerifyFrame;
import jas.jasError;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class StackMap {
    private static final int JDK_SMF_MIN = 50;
    static CP attr = null;
    static boolean java6 = false;
    protected Vector frames;

    protected StackMap(CP attr) {
        StackMap.attr = attr;
        this.frames = new Vector();
    }

    public StackMap(ClassEnv e) {
        if (attr == null) {
            if (e.version_hi >= 50) {
                java6 = true;
            }
            attr = new AsciiCP(java6 ? "StackMapTable" : "StackMap");
        }
        this.frames = new Vector();
    }

    public void addFrame(VerifyFrame f) {
        this.frames.add(f);
    }

    public Vector getLastFrame(int count) throws jasError {
        if (this.frames.isEmpty()) {
            return null;
        }
        return ((VerifyFrame)this.frames.lastElement()).getFrame(count);
    }

    public int size(ClassEnv e, CodeAttr ce) {
        try {
            if (java6) {
                this.shellSort(ce);
            }
            return this.write(e, ce, null);
        }
        catch (IOException ex) {
            System.err.println("UNEXPECTED IO EXCEPTION");
            ex.printStackTrace();
        }
        catch (jasError ex) {
            System.err.println("UNEXPECTED JAS ERROR");
            ex.printStackTrace();
        }
        return 0;
    }

    void resolve(ClassEnv e) {
        e.addCPItem(attr);
        Enumeration en = this.frames.elements();
        while (en.hasMoreElements()) {
            ((VerifyFrame)en.nextElement()).resolve(e);
        }
    }

    int write(ClassEnv e, CodeAttr ce, DataOutputStream out) throws IOException, jasError {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream bufout = new DataOutputStream(buf);
        bufout.writeShort(this.frames.size());
        VerifyFrame prev = null;
        Enumeration en = this.frames.elements();
        while (en.hasMoreElements()) {
            VerifyFrame cur = (VerifyFrame)en.nextElement();
            if (!java6) {
                prev = cur;
            }
            cur.write(e, ce, bufout, prev);
            prev = cur;
        }
        int len = buf.toByteArray().length;
        if (out != null) {
            out.writeShort(e.getCPIndex(attr));
            out.writeInt(len);
            buf.writeTo(out);
        }
        return 6 + len;
    }

    private void shellSort(CodeAttr ce) throws jasError {
        int n = this.frames.size();
        if (--n <= 0) {
            return;
        }
        int g = 3;
        if (g > n) {
            g = 1;
        }
        do {
            int i = g;
            do {
                int jn;
                VerifyFrame t1;
                VerifyFrame tmp = (VerifyFrame)this.frames.elementAt(i);
                int ts = tmp.getOffset(ce);
                int j = i;
                while (j >= g && (t1 = (VerifyFrame)this.frames.elementAt(jn = j - g)).getOffset(ce) > ts) {
                    this.frames.setElementAt(t1, j);
                    j = jn;
                }
                this.frames.setElementAt(tmp, j);
            } while (++i <= n);
        } while ((g /= 2) > 0);
    }
}

