#!/bin/sh
#
# Copyright (C) 2008 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

#
# Rebuild for all known targets.  Necessary until the stuff in "out" gets
# generated as part of the build.
#
set -e

for arch in portstd portdbg allstubs armv5te armv5te-vfp armv7-a armv7-a-neon x86 x86-atom; do TARGET_ARCH_EXT=$arch make -f Makefile-mterp; done

# These aren't actually used, so just go ahead and remove them.  The correct
# approach is to prevent them from being generated in the first place, but
# this will do for now.
echo Removing unneeded assembly source for portable interpreter
rm -f out/InterpAsm-portstd.S out/InterpAsm-portdbg.S
