   /* Copyright (C) 2008 The Android Open Source Project
    *
    * Licensed under the Apache License, Version 2.0 (the "License");
    * you may not use this file except in compliance with the License.
    * You may obtain a copy of the License at
    *
    * http://www.apache.org/licenses/LICENSE-2.0
    *
    * Unless required by applicable law or agreed to in writing, software
    * distributed under the License is distributed on an "AS IS" BASIS,
    * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    * See the License for the specific language governing permissions and
    * limitations under the License.
    */

   /*
    * File: OP_REM_DOUBLE.S
    *
    * Code: Computes the remainder of a division. Performs no substitutions.
    *
    * For: rem-double
    *
    * Description: Calls fmod to compute the remainder of the result of dividing a
    *              source register by a second, and stores the result in a
    *              destination register.
    *
    * Format: AA|op CC|BB (23x)
    *
    * Syntax: op vAA, vBB, vCC
    */

    FETCH_BB    1, %ecx                 # %ecx<- BB
    FETCH_CC    1, %edx                 # %edx<- CC
    movl        (rFP, %ecx, 4), %eax    # %eax<- vBBlo
    movl        %eax, -16(%esp)         # push parameter double lo
    movl        4(rFP, %ecx, 4), %eax   # %eax<- vBBhi
    movl        %eax, -12(%esp)         # push parameter double hi
    movl        (rFP, %edx, 4), %eax    # %eax<- vCClo
    movl        %eax, -8(%esp)          # push parameter double lo
    movl        4(rFP, %edx, 4), %eax   # %eax<- vCChi
    movl        %eax, -4(%esp)          # push parameter double hi
    lea         -16(%esp), %esp
    jmp         .L${opcode}_break
%break

.L${opcode}_break:
    call        fmod                    # call: (long double x, long double y)
                                        # return: double
    lea         16(%esp), %esp
    fstpl       (rFP, rINST, 4)         # vAA<- remainder; return of fmod
    FINISH      2                       # jump to next instruction
