/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
* @author Alexander V. Astapchuk
* @version $Revision$
*/

package org.apache.harmony.security.tests.java.security;

import dalvik.annotation.TestTargetClass;
import dalvik.annotation.TestTargets;
import dalvik.annotation.TestLevel;
import dalvik.annotation.TestTargetNew;

import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.Permission;
import java.security.UnresolvedPermission;

import junit.framework.TestCase;

/**
 * Unit test for AccessControlException.
 */
@TestTargetClass(AccessControlException.class)
public class AccessControlExceptionTest extends TestCase {

    /**
     * Entry point for standalone run.
     * @param args command line arguments
     */
    public static void main(String[] args) {
        junit.textui.TestRunner.run(AccessControlExceptionTest.class);
    }

    /**
     * Tests AccessControlException(String)
     */
    @TestTargetNew(
        level = TestLevel.PARTIAL_COMPLETE,
        notes = "",
        method = "AccessControlException",
        args = {java.lang.String.class}
    )
    public void testAccessControlExceptionString() {
        new AccessControlException(null);
        new AccessControlException("Failure");
    }

    /**
     * Tests AccessControlException(String, Permission)
     */
    @TestTargetNew(
        level = TestLevel.PARTIAL_COMPLETE,
        notes = "",
        method = "AccessControlException",
        args = {java.lang.String.class, java.security.Permission.class}
    )
    public void testAccessControlExceptionStringPermission() {
        Permission perm = new AllPermission();
        AccessControlException controlException = new AccessControlException("001", perm);
        assertEquals("exception message", "001", controlException.getMessage());
        assertEquals("permission", perm, controlException.getPermission());
    }

    /**
     * 
     * Tests AccessControlException.getPermission()
     */
    @TestTargetNew(
        level = TestLevel.COMPLETE,
        notes = "",
        method = "getPermission",
        args = {}
    )
    public void testGetPermission() {
        Permission perm = new UnresolvedPermission("unresolvedType",
                "unresolvedName", "unresolvedActions", null);
        AccessControlException ex = new AccessControlException("001", perm);
        assertSame(ex.getPermission(), perm);
    }
}
