/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
* @author Vladimir N. Molotkov
* @version $Revision$
*/

package org.apache.harmony.security.tests.support;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;

/**
 * Generates key pairs based on their encodings for some algorithms.
 * Encodings generated using
 * BEA JRockit j2sdk1.4.2_04 (http://www.bea.com)
 */
public class TestKeyPair {
    private static final HashMap<String, byte []> privateKeyEncoding = new HashMap<String, byte[]>();
    private static final HashMap<String, byte []> publicKeyEncoding = new HashMap<String, byte[]>();
    private final String algorithmName;
    private final KeyFactory kf;
    static {
        privateKeyEncoding.put("RSA", new byte[] {
                (byte)0x30, (byte)0x82, (byte)0x02, (byte)0x77, 
                (byte)0x02, (byte)0x01, (byte)0x00, (byte)0x30, 
                (byte)0x0d, (byte)0x06, (byte)0x09, (byte)0x2a, 
                (byte)0x86, (byte)0x48, (byte)0x86, (byte)0xf7, 
                (byte)0x0d, (byte)0x01, (byte)0x01, (byte)0x01, 
                (byte)0x05, (byte)0x00, (byte)0x04, (byte)0x82, 
                (byte)0x02, (byte)0x61, (byte)0x30, (byte)0x82, 
                (byte)0x02, (byte)0x5d, (byte)0x02, (byte)0x01, 
                (byte)0x00, (byte)0x02, (byte)0x81, (byte)0x81, 
                (byte)0x00, (byte)0xb2, (byte)0x4a, (byte)0x9b, 
                (byte)0x5b, (byte)0xba, (byte)0x01, (byte)0xc0, 
                (byte)0xcd, (byte)0x65, (byte)0x09, (byte)0x63, 
                (byte)0x70, (byte)0x0b, (byte)0x5a, (byte)0x1b, 
                (byte)0x92, (byte)0x08, (byte)0xf8, (byte)0x55, 
                (byte)0x5e, (byte)0x7c, (byte)0x1b, (byte)0x50, 
                (byte)0x17, (byte)0xec, (byte)0x44, (byte)0x4c, 
                (byte)0x58, (byte)0x42, (byte)0x2b, (byte)0x41, 
                (byte)0x09, (byte)0x59, (byte)0xf2, (byte)0xe1, 
                (byte)0x5d, (byte)0x43, (byte)0x71, (byte)0x4d, 
                (byte)0x92, (byte)0x03, (byte)0x1d, (byte)0xb6, 
                (byte)0x6c, (byte)0x7f, (byte)0x5d, (byte)0x48, 
                (byte)0xcd, (byte)0x17, (byte)0xec, (byte)0xd7, 
                (byte)0x4c, (byte)0x39, (byte)0xb1, (byte)0x7b, 
                (byte)0xe2, (byte)0xbf, (byte)0x96, (byte)0x77, 
                (byte)0xbe, (byte)0xd0, (byte)0xa0, (byte)0xf0, 
                (byte)0x2d, (byte)0x6b, (byte)0x24, (byte)0xaa, 
                (byte)0x14, (byte)0xba, (byte)0x82, (byte)0x79, 
                (byte)0x10, (byte)0x9b, (byte)0x16, (byte)0x68, 
                (byte)0x47, (byte)0x81, (byte)0x54, (byte)0xa2, 
                (byte)0xfa, (byte)0x91, (byte)0x9e, (byte)0x0a, 
                (byte)0x2a, (byte)0x53, (byte)0xa6, (byte)0xe7, 
                (byte)0x9e, (byte)0x7d, (byte)0x29, (byte)0x33, 
                (byte)0xd8, (byte)0x05, (byte)0xfc, (byte)0x02, 
                (byte)0x3f, (byte)0xbd, (byte)0xc7, (byte)0x6e, 
                (byte)0xed, (byte)0xaa, (byte)0x30, (byte)0x6c, 
                (byte)0x5f, (byte)0x52, (byte)0xed, (byte)0x35, 
                (byte)0x65, (byte)0x4b, (byte)0x0e, (byte)0xc8, 
                (byte)0xa7, (byte)0x12, (byte)0x10, (byte)0x56, 
                (byte)0x37, (byte)0xaf, (byte)0x11, (byte)0xfa, 
                (byte)0x21, (byte)0x0e, (byte)0x99, (byte)0xff, 
                (byte)0xfa, (byte)0x8c, (byte)0x65, (byte)0x8e, 
                (byte)0x6d, (byte)0x02, (byte)0x03, (byte)0x01, 
                (byte)0x00, (byte)0x01, (byte)0x02, (byte)0x81, 
                (byte)0x80, (byte)0x78, (byte)0x41, (byte)0x72, 
                (byte)0x40, (byte)0x90, (byte)0x59, (byte)0x96, 
                (byte)0x5d, (byte)0xf3, (byte)0x84, (byte)0x3d, 
                (byte)0x99, (byte)0xd9, (byte)0x4e, (byte)0x51, 
                (byte)0xc2, (byte)0x52, (byte)0x62, (byte)0x8d, 
                (byte)0xd2, (byte)0x49, (byte)0x0b, (byte)0x73, 
                (byte)0x1e, (byte)0x6f, (byte)0xb2, (byte)0x31, 
                (byte)0x7c, (byte)0x66, (byte)0x45, (byte)0x1e, 
                (byte)0x7c, (byte)0xdc, (byte)0x3a, (byte)0xc2, 
                (byte)0x5f, (byte)0x51, (byte)0x9a, (byte)0x1e, 
                (byte)0xa4, (byte)0x19, (byte)0x8d, (byte)0xf4, 
                (byte)0xf9, (byte)0x81, (byte)0x7e, (byte)0xbe, 
                (byte)0x17, (byte)0xf7, (byte)0xc7, (byte)0x3c, 
                (byte)0x00, (byte)0xa1, (byte)0xf9, (byte)0x60, 
                (byte)0x82, (byte)0x34, (byte)0x8f, (byte)0x9c, 
                (byte)0xfd, (byte)0x0b, (byte)0x63, (byte)0x42, 
                (byte)0x1b, (byte)0x7f, (byte)0x45, (byte)0xf1, 
                (byte)0x31, (byte)0xc3, (byte)0x63, (byte)0x47, 
                (byte)0x5c, (byte)0xc1, (byte)0xb2, (byte)0x5f, 
                (byte)0x57, (byte)0xee, (byte)0x02, (byte)0x9f, 
                (byte)0x5e, (byte)0x08, (byte)0x48, (byte)0xba, 
                (byte)0x74, (byte)0xba, (byte)0x81, (byte)0xb7, 
                (byte)0x30, (byte)0xac, (byte)0x4c, (byte)0x01, 
                (byte)0x35, (byte)0xce, (byte)0x46, (byte)0x47, 
                (byte)0x8c, (byte)0xe4, (byte)0x62, (byte)0x36, 
                (byte)0x1a, (byte)0x65, (byte)0x0e, (byte)0x33, 
                (byte)0x56, (byte)0xf9, (byte)0xb7, (byte)0xa0, 
                (byte)0xc4, (byte)0xb6, (byte)0x82, (byte)0x55, 
                (byte)0x7d, (byte)0x36, (byte)0x55, (byte)0xc0, 
                (byte)0x52, (byte)0x5e, (byte)0x35, (byte)0x54, 
                (byte)0xbd, (byte)0x97, (byte)0x01, (byte)0x00, 
                (byte)0xbf, (byte)0x10, (byte)0xdc, (byte)0x1b, 
                (byte)0x51, (byte)0x02, (byte)0x41, (byte)0x00, 
                (byte)0xe7, (byte)0x68, (byte)0x03, (byte)0x3e, 
                (byte)0x21, (byte)0x64, (byte)0x68, (byte)0x24, 
                (byte)0x7b, (byte)0xd0, (byte)0x31, (byte)0xa0, 
                (byte)0xa2, (byte)0xd9, (byte)0x87, (byte)0x6d, 
                (byte)0x79, (byte)0x81, (byte)0x8f, (byte)0x8f, 
                (byte)0x2d, (byte)0x7a, (byte)0x95, (byte)0x2e, 
                (byte)0x55, (byte)0x9f, (byte)0xd7, (byte)0x86, 
                (byte)0x29, (byte)0x93, (byte)0xbd, (byte)0x04, 
                (byte)0x7e, (byte)0x4f, (byte)0xdb, (byte)0x56, 
                (byte)0xf1, (byte)0x75, (byte)0xd0, (byte)0x4b, 
                (byte)0x00, (byte)0x3a, (byte)0xe0, (byte)0x26, 
                (byte)0xf6, (byte)0xab, (byte)0x9e, (byte)0x0b, 
                (byte)0x2a, (byte)0xf4, (byte)0xa8, (byte)0xd7, 
                (byte)0xff, (byte)0xbe, (byte)0x01, (byte)0xeb, 
                (byte)0x9b, (byte)0x81, (byte)0xc7, (byte)0x5f, 
                (byte)0x02, (byte)0x73, (byte)0xe1, (byte)0x2b, 
                (byte)0x02, (byte)0x41, (byte)0x00, (byte)0xc5, 
                (byte)0x3d, (byte)0x78, (byte)0xab, (byte)0xe6, 
                (byte)0xab, (byte)0x3e, (byte)0x29, (byte)0xfd, 
                (byte)0x98, (byte)0xd0, (byte)0xa4, (byte)0x3e, 
                (byte)0x58, (byte)0xee, (byte)0x48, (byte)0x45, 
                (byte)0xa3, (byte)0x66, (byte)0xac, (byte)0xe9, 
                (byte)0x4d, (byte)0xbd, (byte)0x60, (byte)0xea, 
                (byte)0x24, (byte)0xff, (byte)0xed, (byte)0x0c, 
                (byte)0x67, (byte)0xc5, (byte)0xfd, (byte)0x36, 
                (byte)0x28, (byte)0xea, (byte)0x74, (byte)0x88, 
                (byte)0xd1, (byte)0xd1, (byte)0xad, (byte)0x58, 
                (byte)0xd7, (byte)0xf0, (byte)0x67, (byte)0x20, 
                (byte)0xc1, (byte)0xe3, (byte)0xb3, (byte)0xdb, 
                (byte)0x52, (byte)0xad, (byte)0xf3, (byte)0xc4, 
                (byte)0x21, (byte)0xd8, (byte)0x8c, (byte)0x4c, 
                (byte)0x41, (byte)0x27, (byte)0xdb, (byte)0xd0, 
                (byte)0x35, (byte)0x92, (byte)0xc7, (byte)0x02, 
                (byte)0x41, (byte)0x00, (byte)0xe0, (byte)0x99, 
                (byte)0x42, (byte)0xb4, (byte)0x76, (byte)0x02, 
                (byte)0x97, (byte)0x55, (byte)0xf9, (byte)0xda, 
                (byte)0x3b, (byte)0xa0, (byte)0xd7, (byte)0x0e, 
                (byte)0xdc, (byte)0xf4, (byte)0x33, (byte)0x7f, 
                (byte)0xbd, (byte)0xcf, (byte)0xd0, (byte)0xeb, 
                (byte)0x6e, (byte)0x89, (byte)0xf7, (byte)0x4f, 
                (byte)0x5a, (byte)0x07, (byte)0x7c, (byte)0xa9, 
                (byte)0x49, (byte)0x47, (byte)0x68, (byte)0x35, 
                (byte)0xa8, (byte)0x05, (byte)0x3d, (byte)0xfd, 
                (byte)0x04, (byte)0x7b, (byte)0x17, (byte)0x31, 
                (byte)0x0d, (byte)0xc8, (byte)0xa3, (byte)0x98, 
                (byte)0x34, (byte)0xa0, (byte)0x50, (byte)0x44, 
                (byte)0x00, (byte)0xf1, (byte)0x0c, (byte)0xe6, 
                (byte)0xe5, (byte)0xc4, (byte)0x41, (byte)0x3d, 
                (byte)0xf8, (byte)0x3d, (byte)0x4e, (byte)0x0b, 
                (byte)0x1c, (byte)0xdb, (byte)0x02, (byte)0x41, 
                (byte)0x00, (byte)0x82, (byte)0x9b, (byte)0x8a, 
                (byte)0xfd, (byte)0xa1, (byte)0x98, (byte)0x41, 
                (byte)0x68, (byte)0xc2, (byte)0xd1, (byte)0xdf, 
                (byte)0x4e, (byte)0xf3, (byte)0x2e, (byte)0x26, 
                (byte)0x53, (byte)0x5b, (byte)0x31, (byte)0xb1, 
                (byte)0x7a, (byte)0xcc, (byte)0x5e, (byte)0xbb, 
                (byte)0x09, (byte)0xa2, (byte)0xe2, (byte)0x6f, 
                (byte)0x4a, (byte)0x04, (byte)0x0d, (byte)0xef, 
                (byte)0x90, (byte)0x15, (byte)0xbe, (byte)0x10, 
                (byte)0x4a, (byte)0xac, (byte)0x92, (byte)0xeb, 
                (byte)0xda, (byte)0x72, (byte)0xdb, (byte)0x43, 
                (byte)0x08, (byte)0xb7, (byte)0x2b, (byte)0x4c, 
                (byte)0xe1, (byte)0xbb, (byte)0x58, (byte)0xcb, 
                (byte)0x71, (byte)0x80, (byte)0xad, (byte)0xbc, 
                (byte)0xdc, (byte)0x62, (byte)0x5e, (byte)0x3e, 
                (byte)0xcb, (byte)0x92, (byte)0xda, (byte)0xf6, 
                (byte)0xdf, (byte)0x02, (byte)0x40, (byte)0x4d, 
                (byte)0x81, (byte)0x90, (byte)0xc5, (byte)0x77, 
                (byte)0x30, (byte)0xb7, (byte)0x29, (byte)0x00, 
                (byte)0xa8, (byte)0xf1, (byte)0xb4, (byte)0xae, 
                (byte)0x52, (byte)0x63, (byte)0x00, (byte)0xb2, 
                (byte)0x2d, (byte)0x3e, (byte)0x7d, (byte)0xd6, 
                (byte)0x4d, (byte)0xf9, (byte)0x8a, (byte)0xc1, 
                (byte)0xb1, (byte)0x98, (byte)0x89, (byte)0x52, 
                (byte)0x40, (byte)0x14, (byte)0x1b, (byte)0x0e, 
                (byte)0x61, (byte)0x8f, (byte)0xf4, (byte)0xbe, 
                (byte)0x59, (byte)0x79, (byte)0x79, (byte)0x95, 
                (byte)0x19, (byte)0x5c, (byte)0x51, (byte)0x08, 
                (byte)0x66, (byte)0xc1, (byte)0x42, (byte)0x30, 
                (byte)0xb3, (byte)0x7a, (byte)0x86, (byte)0x9f, 
                (byte)0x3e, (byte)0xf5, (byte)0x19, (byte)0xa3, 
                (byte)0xae, (byte)0x64, (byte)0x69, (byte)0x14, 
                (byte)0x07, (byte)0x50, (byte)0x97
        });        
        publicKeyEncoding.put("RSA", new byte[] {
                (byte)0x30, (byte)0x81, (byte)0x9f, (byte)0x30, 
                (byte)0x0d, (byte)0x06, (byte)0x09, (byte)0x2a, 
                (byte)0x86, (byte)0x48, (byte)0x86, (byte)0xf7, 
                (byte)0x0d, (byte)0x01, (byte)0x01, (byte)0x01, 
                (byte)0x05, (byte)0x00, (byte)0x03, (byte)0x81, 
                (byte)0x8d, (byte)0x00, (byte)0x30, (byte)0x81, 
                (byte)0x89, (byte)0x02, (byte)0x81, (byte)0x81, 
                (byte)0x00, (byte)0xb2, (byte)0x4a, (byte)0x9b, 
                (byte)0x5b, (byte)0xba, (byte)0x01, (byte)0xc0, 
                (byte)0xcd, (byte)0x65, (byte)0x09, (byte)0x63, 
                (byte)0x70, (byte)0x0b, (byte)0x5a, (byte)0x1b, 
                (byte)0x92, (byte)0x08, (byte)0xf8, (byte)0x55, 
                (byte)0x5e, (byte)0x7c, (byte)0x1b, (byte)0x50, 
                (byte)0x17, (byte)0xec, (byte)0x44, (byte)0x4c, 
                (byte)0x58, (byte)0x42, (byte)0x2b, (byte)0x41, 
                (byte)0x09, (byte)0x59, (byte)0xf2, (byte)0xe1, 
                (byte)0x5d, (byte)0x43, (byte)0x71, (byte)0x4d, 
                (byte)0x92, (byte)0x03, (byte)0x1d, (byte)0xb6, 
                (byte)0x6c, (byte)0x7f, (byte)0x5d, (byte)0x48, 
                (byte)0xcd, (byte)0x17, (byte)0xec, (byte)0xd7, 
                (byte)0x4c, (byte)0x39, (byte)0xb1, (byte)0x7b, 
                (byte)0xe2, (byte)0xbf, (byte)0x96, (byte)0x77, 
                (byte)0xbe, (byte)0xd0, (byte)0xa0, (byte)0xf0, 
                (byte)0x2d, (byte)0x6b, (byte)0x24, (byte)0xaa, 
                (byte)0x14, (byte)0xba, (byte)0x82, (byte)0x79, 
                (byte)0x10, (byte)0x9b, (byte)0x16, (byte)0x68, 
                (byte)0x47, (byte)0x81, (byte)0x54, (byte)0xa2, 
                (byte)0xfa, (byte)0x91, (byte)0x9e, (byte)0x0a, 
                (byte)0x2a, (byte)0x53, (byte)0xa6, (byte)0xe7, 
                (byte)0x9e, (byte)0x7d, (byte)0x29, (byte)0x33, 
                (byte)0xd8, (byte)0x05, (byte)0xfc, (byte)0x02, 
                (byte)0x3f, (byte)0xbd, (byte)0xc7, (byte)0x6e, 
                (byte)0xed, (byte)0xaa, (byte)0x30, (byte)0x6c, 
                (byte)0x5f, (byte)0x52, (byte)0xed, (byte)0x35, 
                (byte)0x65, (byte)0x4b, (byte)0x0e, (byte)0xc8, 
                (byte)0xa7, (byte)0x12, (byte)0x10, (byte)0x56, 
                (byte)0x37, (byte)0xaf, (byte)0x11, (byte)0xfa, 
                (byte)0x21, (byte)0x0e, (byte)0x99, (byte)0xff, 
                (byte)0xfa, (byte)0x8c, (byte)0x65, (byte)0x8e, 
                (byte)0x6d, (byte)0x02, (byte)0x03, (byte)0x01, 
                (byte)0x00, (byte)0x01
        });        
        privateKeyEncoding.put("DSA", new byte[] {
                (byte)0x30, (byte)0x82, (byte)0x01, (byte)0x4a, 
                (byte)0x02, (byte)0x01, (byte)0x00, (byte)0x30, 
                (byte)0x82, (byte)0x01, (byte)0x2b, (byte)0x06, 
                (byte)0x07, (byte)0x2a, (byte)0x86, (byte)0x48, 
                (byte)0xce, (byte)0x38, (byte)0x04, (byte)0x01, 
                (byte)0x30, (byte)0x82, (byte)0x01, (byte)0x1e, 
                (byte)0x02, (byte)0x81, (byte)0x81, (byte)0x00, 
                (byte)0xca, (byte)0x84, (byte)0x1d, (byte)0xa3, 
                (byte)0xab, (byte)0xb9, (byte)0x98, (byte)0xf4, 
                (byte)0x61, (byte)0x8b, (byte)0x66, (byte)0xdb, 
                (byte)0x4e, (byte)0x3a, (byte)0xb2, (byte)0x11, 
                (byte)0x4e, (byte)0xa9, (byte)0xda, (byte)0x35, 
                (byte)0x91, (byte)0xc9, (byte)0x4e, (byte)0xc3, 
                (byte)0x16, (byte)0xa7, (byte)0xed, (byte)0xb8, 
                (byte)0x8f, (byte)0xd7, (byte)0xea, (byte)0xea, 
                (byte)0xdb, (byte)0x77, (byte)0xe1, (byte)0x77, 
                (byte)0x7a, (byte)0xc9, (byte)0xf3, (byte)0x37, 
                (byte)0x33, (byte)0x01, (byte)0x72, (byte)0xbc, 
                (byte)0xd0, (byte)0x89, (byte)0x9b, (byte)0x18, 
                (byte)0xfd, (byte)0x84, (byte)0xd6, (byte)0xe9, 
                (byte)0xbf, (byte)0x13, (byte)0x35, (byte)0x5e, 
                (byte)0x40, (byte)0xf6, (byte)0x9d, (byte)0xd9, 
                (byte)0x1a, (byte)0xba, (byte)0xa9, (byte)0xc3, 
                (byte)0x8c, (byte)0xe3, (byte)0x95, (byte)0xc8, 
                (byte)0xdf, (byte)0x2e, (byte)0x41, (byte)0xa1, 
                (byte)0xbf, (byte)0xde, (byte)0x5d, (byte)0xad, 
                (byte)0x21, (byte)0xcc, (byte)0x0d, (byte)0x42, 
                (byte)0x56, (byte)0xa0, (byte)0x32, (byte)0xc0, 
                (byte)0x90, (byte)0x73, (byte)0x3e, (byte)0xa4, 
                (byte)0x0e, (byte)0x58, (byte)0xe4, (byte)0x64, 
                (byte)0x00, (byte)0xa3, (byte)0x27, (byte)0x49, 
                (byte)0x56, (byte)0xb2, (byte)0x43, (byte)0xbc, 
                (byte)0x72, (byte)0xa8, (byte)0xd2, (byte)0x26, 
                (byte)0x89, (byte)0x35, (byte)0x37, (byte)0x29, 
                (byte)0x8d, (byte)0x21, (byte)0xb5, (byte)0x8e, 
                (byte)0x59, (byte)0xfa, (byte)0x9e, (byte)0xdf, 
                (byte)0x37, (byte)0x0d, (byte)0x9e, (byte)0xab, 
                (byte)0xfd, (byte)0xbf, (byte)0x1a, (byte)0x9e, 
                (byte)0xf3, (byte)0xe8, (byte)0x3a, (byte)0xfb, 
                (byte)0x02, (byte)0x15, (byte)0x00, (byte)0xa2, 
                (byte)0x4e, (byte)0x5d, (byte)0xe3, (byte)0x10, 
                (byte)0x5d, (byte)0xa9, (byte)0x3a, (byte)0x6a, 
                (byte)0x4d, (byte)0x07, (byte)0x3b, (byte)0xab, 
                (byte)0xca, (byte)0x7d, (byte)0x09, (byte)0xd6, 
                (byte)0x06, (byte)0x79, (byte)0x49, (byte)0x02, 
                (byte)0x81, (byte)0x80, (byte)0x5a, (byte)0x91, 
                (byte)0x83, (byte)0x1c, (byte)0x04, (byte)0x33, 
                (byte)0xca, (byte)0x25, (byte)0xb0, (byte)0x68, 
                (byte)0xb3, (byte)0xb3, (byte)0xab, (byte)0x55, 
                (byte)0x29, (byte)0x33, (byte)0x4d, (byte)0xa9, 
                (byte)0x33, (byte)0x39, (byte)0xef, (byte)0x71, 
                (byte)0xca, (byte)0x95, (byte)0xf3, (byte)0xd8, 
                (byte)0x27, (byte)0x56, (byte)0x5f, (byte)0x42, 
                (byte)0xda, (byte)0x36, (byte)0x83, (byte)0xc5, 
                (byte)0xf1, (byte)0x53, (byte)0x62, (byte)0xa5, 
                (byte)0xdc, (byte)0xe6, (byte)0x4e, (byte)0x69, 
                (byte)0x45, (byte)0x71, (byte)0x1a, (byte)0x4a, 
                (byte)0xc3, (byte)0xf4, (byte)0x7f, (byte)0x0a, 
                (byte)0xd1, (byte)0x78, (byte)0xed, (byte)0xbe, 
                (byte)0x6e, (byte)0xa6, (byte)0x36, (byte)0x34, 
                (byte)0x4e, (byte)0xc3, (byte)0x1b, (byte)0x17, 
                (byte)0xaa, (byte)0xa4, (byte)0x76, (byte)0x44, 
                (byte)0x46, (byte)0xaf, (byte)0x26, (byte)0x16, 
                (byte)0x14, (byte)0xfb, (byte)0x9f, (byte)0x5d, 
                (byte)0x08, (byte)0xaf, (byte)0x92, (byte)0xdb, 
                (byte)0xba, (byte)0xd0, (byte)0xcb, (byte)0x8b, 
                (byte)0x1e, (byte)0xc3, (byte)0x8b, (byte)0x36, 
                (byte)0x3b, (byte)0x4c, (byte)0x02, (byte)0xc3, 
                (byte)0x66, (byte)0x28, (byte)0x69, (byte)0xd0, 
                (byte)0x74, (byte)0x4f, (byte)0x1c, (byte)0x4f, 
                (byte)0x97, (byte)0x75, (byte)0x7f, (byte)0x9e, 
                (byte)0x89, (byte)0x80, (byte)0xcf, (byte)0xb2, 
                (byte)0x17, (byte)0xd6, (byte)0x66, (byte)0x91, 
                (byte)0x12, (byte)0x3a, (byte)0xb0, (byte)0x3c, 
                (byte)0x3c, (byte)0xc2, (byte)0x31, (byte)0xd1, 
                (byte)0x31, (byte)0x2a, (byte)0x35, (byte)0xbe, 
                (byte)0x9d, (byte)0x54, (byte)0x71, (byte)0x03, 
                (byte)0xcb, (byte)0xcc, (byte)0x04, (byte)0x16, 
                (byte)0x02, (byte)0x14, (byte)0x52, (byte)0xfb, 
                (byte)0xf9, (byte)0x12, (byte)0x40, (byte)0x05, 
                (byte)0x59, (byte)0x8f, (byte)0xde, (byte)0x9d, 
                (byte)0xac, (byte)0xa1, (byte)0xe2, (byte)0xed, 
                (byte)0x56, (byte)0x62, (byte)0x5f, (byte)0x56, 
                (byte)0x67, (byte)0x74
        });
        publicKeyEncoding.put("DSA", new byte[] {
                (byte)0x30, (byte)0x82, (byte)0x01, (byte)0xb7, 
                (byte)0x30, (byte)0x82, (byte)0x01, (byte)0x2b, 
                (byte)0x06, (byte)0x07, (byte)0x2a, (byte)0x86, 
                (byte)0x48, (byte)0xce, (byte)0x38, (byte)0x04, 
                (byte)0x01, (byte)0x30, (byte)0x82, (byte)0x01, 
                (byte)0x1e, (byte)0x02, (byte)0x81, (byte)0x81, 
                (byte)0x00, (byte)0xca, (byte)0x84, (byte)0x1d, 
                (byte)0xa3, (byte)0xab, (byte)0xb9, (byte)0x98, 
                (byte)0xf4, (byte)0x61, (byte)0x8b, (byte)0x66, 
                (byte)0xdb, (byte)0x4e, (byte)0x3a, (byte)0xb2, 
                (byte)0x11, (byte)0x4e, (byte)0xa9, (byte)0xda, 
                (byte)0x35, (byte)0x91, (byte)0xc9, (byte)0x4e, 
                (byte)0xc3, (byte)0x16, (byte)0xa7, (byte)0xed, 
                (byte)0xb8, (byte)0x8f, (byte)0xd7, (byte)0xea, 
                (byte)0xea, (byte)0xdb, (byte)0x77, (byte)0xe1, 
                (byte)0x77, (byte)0x7a, (byte)0xc9, (byte)0xf3, 
                (byte)0x37, (byte)0x33, (byte)0x01, (byte)0x72, 
                (byte)0xbc, (byte)0xd0, (byte)0x89, (byte)0x9b, 
                (byte)0x18, (byte)0xfd, (byte)0x84, (byte)0xd6, 
                (byte)0xe9, (byte)0xbf, (byte)0x13, (byte)0x35, 
                (byte)0x5e, (byte)0x40, (byte)0xf6, (byte)0x9d, 
                (byte)0xd9, (byte)0x1a, (byte)0xba, (byte)0xa9, 
                (byte)0xc3, (byte)0x8c, (byte)0xe3, (byte)0x95, 
                (byte)0xc8, (byte)0xdf, (byte)0x2e, (byte)0x41, 
                (byte)0xa1, (byte)0xbf, (byte)0xde, (byte)0x5d, 
                (byte)0xad, (byte)0x21, (byte)0xcc, (byte)0x0d, 
                (byte)0x42, (byte)0x56, (byte)0xa0, (byte)0x32, 
                (byte)0xc0, (byte)0x90, (byte)0x73, (byte)0x3e, 
                (byte)0xa4, (byte)0x0e, (byte)0x58, (byte)0xe4, 
                (byte)0x64, (byte)0x00, (byte)0xa3, (byte)0x27, 
                (byte)0x49, (byte)0x56, (byte)0xb2, (byte)0x43, 
                (byte)0xbc, (byte)0x72, (byte)0xa8, (byte)0xd2, 
                (byte)0x26, (byte)0x89, (byte)0x35, (byte)0x37, 
                (byte)0x29, (byte)0x8d, (byte)0x21, (byte)0xb5, 
                (byte)0x8e, (byte)0x59, (byte)0xfa, (byte)0x9e, 
                (byte)0xdf, (byte)0x37, (byte)0x0d, (byte)0x9e, 
                (byte)0xab, (byte)0xfd, (byte)0xbf, (byte)0x1a, 
                (byte)0x9e, (byte)0xf3, (byte)0xe8, (byte)0x3a, 
                (byte)0xfb, (byte)0x02, (byte)0x15, (byte)0x00, 
                (byte)0xa2, (byte)0x4e, (byte)0x5d, (byte)0xe3, 
                (byte)0x10, (byte)0x5d, (byte)0xa9, (byte)0x3a, 
                (byte)0x6a, (byte)0x4d, (byte)0x07, (byte)0x3b, 
                (byte)0xab, (byte)0xca, (byte)0x7d, (byte)0x09, 
                (byte)0xd6, (byte)0x06, (byte)0x79, (byte)0x49, 
                (byte)0x02, (byte)0x81, (byte)0x80, (byte)0x5a, 
                (byte)0x91, (byte)0x83, (byte)0x1c, (byte)0x04, 
                (byte)0x33, (byte)0xca, (byte)0x25, (byte)0xb0, 
                (byte)0x68, (byte)0xb3, (byte)0xb3, (byte)0xab, 
                (byte)0x55, (byte)0x29, (byte)0x33, (byte)0x4d, 
                (byte)0xa9, (byte)0x33, (byte)0x39, (byte)0xef, 
                (byte)0x71, (byte)0xca, (byte)0x95, (byte)0xf3, 
                (byte)0xd8, (byte)0x27, (byte)0x56, (byte)0x5f, 
                (byte)0x42, (byte)0xda, (byte)0x36, (byte)0x83, 
                (byte)0xc5, (byte)0xf1, (byte)0x53, (byte)0x62, 
                (byte)0xa5, (byte)0xdc, (byte)0xe6, (byte)0x4e, 
                (byte)0x69, (byte)0x45, (byte)0x71, (byte)0x1a, 
                (byte)0x4a, (byte)0xc3, (byte)0xf4, (byte)0x7f, 
                (byte)0x0a, (byte)0xd1, (byte)0x78, (byte)0xed, 
                (byte)0xbe, (byte)0x6e, (byte)0xa6, (byte)0x36, 
                (byte)0x34, (byte)0x4e, (byte)0xc3, (byte)0x1b, 
                (byte)0x17, (byte)0xaa, (byte)0xa4, (byte)0x76, 
                (byte)0x44, (byte)0x46, (byte)0xaf, (byte)0x26, 
                (byte)0x16, (byte)0x14, (byte)0xfb, (byte)0x9f, 
                (byte)0x5d, (byte)0x08, (byte)0xaf, (byte)0x92, 
                (byte)0xdb, (byte)0xba, (byte)0xd0, (byte)0xcb, 
                (byte)0x8b, (byte)0x1e, (byte)0xc3, (byte)0x8b, 
                (byte)0x36, (byte)0x3b, (byte)0x4c, (byte)0x02, 
                (byte)0xc3, (byte)0x66, (byte)0x28, (byte)0x69, 
                (byte)0xd0, (byte)0x74, (byte)0x4f, (byte)0x1c, 
                (byte)0x4f, (byte)0x97, (byte)0x75, (byte)0x7f, 
                (byte)0x9e, (byte)0x89, (byte)0x80, (byte)0xcf, 
                (byte)0xb2, (byte)0x17, (byte)0xd6, (byte)0x66, 
                (byte)0x91, (byte)0x12, (byte)0x3a, (byte)0xb0, 
                (byte)0x3c, (byte)0x3c, (byte)0xc2, (byte)0x31, 
                (byte)0xd1, (byte)0x31, (byte)0x2a, (byte)0x35, 
                (byte)0xbe, (byte)0x9d, (byte)0x54, (byte)0x71, 
                (byte)0x03, (byte)0xcb, (byte)0xcc, (byte)0x03, 
                (byte)0x81, (byte)0x85, (byte)0x00, (byte)0x02, 
                (byte)0x81, (byte)0x81, (byte)0x00, (byte)0x95, 
                (byte)0xcc, (byte)0x11, (byte)0xd4, (byte)0x53, 
                (byte)0x3d, (byte)0x9c, (byte)0x5c, (byte)0x73, 
                (byte)0xf4, (byte)0x70, (byte)0xf0, (byte)0xe1, 
                (byte)0xac, (byte)0xe3, (byte)0x2c, (byte)0x32, 
                (byte)0x16, (byte)0x1d, (byte)0x34, (byte)0x1a, 
                (byte)0x38, (byte)0x63, (byte)0x69, (byte)0x1a, 
                (byte)0x72, (byte)0x39, (byte)0x4e, (byte)0x41, 
                (byte)0x50, (byte)0xfa, (byte)0xdc, (byte)0x78, 
                (byte)0xa4, (byte)0xb8, (byte)0x17, (byte)0x5a, 
                (byte)0xe4, (byte)0xf9, (byte)0xa2, (byte)0x52, 
                (byte)0x41, (byte)0x85, (byte)0xab, (byte)0x3f, 
                (byte)0xf4, (byte)0x73, (byte)0x2e, (byte)0xae, 
                (byte)0xa9, (byte)0x21, (byte)0x8b, (byte)0x5e, 
                (byte)0x95, (byte)0x15, (byte)0xa2, (byte)0x86, 
                (byte)0x63, (byte)0x0d, (byte)0xba, (byte)0x01, 
                (byte)0xcb, (byte)0xe3, (byte)0x68, (byte)0xc6, 
                (byte)0xaf, (byte)0x56, (byte)0x51, (byte)0x7b, 
                (byte)0xa8, (byte)0x85, (byte)0x3f, (byte)0x01, 
                (byte)0x80, (byte)0x8b, (byte)0x1f, (byte)0xb4, 
                (byte)0x4c, (byte)0x93, (byte)0x6b, (byte)0x42, 
                (byte)0xa6, (byte)0xbd, (byte)0x67, (byte)0x2a, 
                (byte)0x95, (byte)0x05, (byte)0xff, (byte)0x03, 
                (byte)0x2e, (byte)0x6f, (byte)0xd4, (byte)0xd3, 
                (byte)0xf0, (byte)0x17, (byte)0xde, (byte)0xcb, 
                (byte)0x7d, (byte)0xd9, (byte)0x42, (byte)0x4d, 
                (byte)0x97, (byte)0x2c, (byte)0x53, (byte)0xe6, 
                (byte)0x39, (byte)0x61, (byte)0xd2, (byte)0x69, 
                (byte)0xd1, (byte)0x1c, (byte)0x9a, (byte)0x8b, 
                (byte)0x5b, (byte)0x9c, (byte)0xfa, (byte)0xfa, 
                (byte)0x50, (byte)0x50, (byte)0xbb, (byte)0xe4, 
                (byte)0x2e, (byte)0x83, (byte)0x06, (byte)0x08, 
                (byte)0x96, (byte)0x2a, (byte)0x68
        });
        privateKeyEncoding.put("DH", new byte[] {
                (byte) 0x30, (byte) 0xffffff81, (byte) 0xffffffe1, (byte) 0x2,
                (byte) 0x1, (byte) 0x0, (byte) 0x30, (byte) 0xffffff81,
                (byte) 0xffffff97, (byte) 0x6, (byte) 0x9, (byte) 0x2a,
                (byte) 0xffffff86, (byte) 0x48, (byte) 0xffffff86,
                (byte) 0xfffffff7, (byte) 0xd, (byte) 0x1, (byte) 0x3,
                (byte) 0x1, (byte) 0x30, (byte) 0xffffff81, (byte) 0xffffff89,
                (byte) 0x2, (byte) 0x41, (byte) 0x0, (byte) 0xfffffff0,
                (byte) 0xffffffaa, (byte) 0x22, (byte) 0x5a, (byte) 0x29,
                (byte) 0xffffffb2, (byte) 0x3f, (byte) 0xffffffc9, (byte) 0xb,
                (byte) 0xffffff87, (byte) 0x5d, (byte) 0xffffff91, (byte) 0x51,
                (byte) 0x1, (byte) 0xffffffa4, (byte) 0xffffffb9, (byte) 0x4e,
                (byte) 0x1e, (byte) 0xffffff85, (byte) 0xfffffffc,
                (byte) 0xffffffa6, (byte) 0x5a, (byte) 0xffffff96,
                (byte) 0xffffffb1, (byte) 0xffffffcb, (byte) 0xffffff81,
                (byte) 0xffffffa3, (byte) 0x6e, (byte) 0xffffff90,
                (byte) 0xffffffbd, (byte) 0xffffffa2, (byte) 0xe,
                (byte) 0xffffffb4, (byte) 0xffffffba, (byte) 0x2c, (byte) 0x45,
                (byte) 0x9, (byte) 0x1c, (byte) 0xffffff98, (byte) 0x39,
                (byte) 0x26, (byte) 0x24, (byte) 0x40, (byte) 0xffffff80,
                (byte) 0xffffffce, (byte) 0x15, (byte) 0xffffff8b,
                (byte) 0xffffffe1, (byte) 0x67, (byte) 0x48, (byte) 0xfffffff3,
                (byte) 0x70, (byte) 0xffffff98, (byte) 0xffffffca,
                (byte) 0xffffffa7, (byte) 0x71, (byte) 0x33, (byte) 0xffffffb6,
                (byte) 0x4, (byte) 0x13, (byte) 0xffffffe5, (byte) 0x61,
                (byte) 0x3c, (byte) 0x1f, (byte) 0x2, (byte) 0x40, (byte) 0x1e,
                (byte) 0xffffffd8, (byte) 0x6f, (byte) 0xffffffce, (byte) 0x23,
                (byte) 0x71, (byte) 0x6a, (byte) 0x2a, (byte) 0xffffffa3,
                (byte) 0x4d, (byte) 0x62, (byte) 0xffffffe9, (byte) 0x5f,
                (byte) 0x17, (byte) 0xffffffa8, (byte) 0xffffffe8,
                (byte) 0xffffffaa, (byte) 0xffffff8a, (byte) 0xffffff95,
                (byte) 0x26, (byte) 0x7c, (byte) 0x38, (byte) 0xffffffa9,
                (byte) 0x2b, (byte) 0x48, (byte) 0x5a, (byte) 0x16,
                (byte) 0x19, (byte) 0xfffffffa, (byte) 0xffffff83,
                (byte) 0xffffffb8, (byte) 0x76, (byte) 0xffffffaf,
                (byte) 0xffffffb8, (byte) 0x62, (byte) 0x72, (byte) 0x45,
                (byte) 0xffffff9f, (byte) 0xffffff95, (byte) 0x1e, (byte) 0x62,
                (byte) 0x36, (byte) 0xffffff97, (byte) 0xffffffbf,
                (byte) 0xffffffab, (byte) 0x20, (byte) 0xffffffb0, (byte) 0x61,
                (byte) 0xffffffc5, (byte) 0x21, (byte) 0xffffff9e,
                (byte) 0xffffffe4, (byte) 0xffffffde, (byte) 0xffffff91,
                (byte) 0x1c, (byte) 0x6a, (byte) 0x7, (byte) 0x48, (byte) 0x77,
                (byte) 0x70, (byte) 0x1d, (byte) 0xffffffff, (byte) 0x58,
                (byte) 0x23, (byte) 0x2, (byte) 0x2, (byte) 0x1,
                (byte) 0xffffffff, (byte) 0x4, (byte) 0x42, (byte) 0x2,
                (byte) 0x40, (byte) 0x69, (byte) 0xffffff86, (byte) 0x48,
                (byte) 0x57, (byte) 0xffffffbf, (byte) 0xffffffde, (byte) 0x8,
                (byte) 0xffffffc6, (byte) 0x24, (byte) 0x6d, (byte) 0xf,
                (byte) 0x20, (byte) 0xffffff94, (byte) 0x4a, (byte) 0x22,
                (byte) 0x6e, (byte) 0x24, (byte) 0x60, (byte) 0xffffffd9,
                (byte) 0xffffffa9, (byte) 0xffffffbd, (byte) 0x1e, (byte) 0x64,
                (byte) 0xffffff89, (byte) 0xffffff83, (byte) 0x3c,
                (byte) 0xffffffe7, (byte) 0x70, (byte) 0x24, (byte) 0xffffffe1,
                (byte) 0xffffff8f, (byte) 0x3c, (byte) 0x4d, (byte) 0x39,
                (byte) 0x5f, (byte) 0xffffff9e, (byte) 0xffffff93, (byte) 0x13,
                (byte) 0xffffff86, (byte) 0xffffffe9, (byte) 0xffffff80,
                (byte) 0xf, (byte) 0xffffffc4, (byte) 0x41, (byte) 0xffffff8b,
                (byte) 0xfffffff4, (byte) 0xffffff8b, (byte) 0x65,
                (byte) 0xffffffa4, (byte) 0x1b, (byte) 0xd, (byte) 0x4,
                (byte) 0x48, (byte) 0x40, (byte) 0xffffffd6, (byte) 0xffffffa2,
                (byte) 0x0, (byte) 0xffffff85, (byte) 0xffffffe9,
                (byte) 0xffffffc4, (byte) 0x77, (byte) 0xffffffb2, (byte) 0x25,
                (byte) 0xffffffd8 
        });
        publicKeyEncoding.put("DH", new byte[] { 
                (byte) 0x30, (byte) 0xffffff81, (byte) 0xffffffe0, (byte) 0x30,
                (byte) 0xffffff81, (byte) 0xffffff97, (byte) 0x6, (byte) 0x9,
                (byte) 0x2a, (byte) 0xffffff86, (byte) 0x48, (byte) 0xffffff86,
                (byte) 0xfffffff7, (byte) 0xd, (byte) 0x1, (byte) 0x3,
                (byte) 0x1, (byte) 0x30, (byte) 0xffffff81, (byte) 0xffffff89,
                (byte) 0x2, (byte) 0x41, (byte) 0x0, (byte) 0xfffffff0,
                (byte) 0xffffffaa, (byte) 0x22, (byte) 0x5a, (byte) 0x29,
                (byte) 0xffffffb2, (byte) 0x3f, (byte) 0xffffffc9, (byte) 0xb,
                (byte) 0xffffff87, (byte) 0x5d, (byte) 0xffffff91, (byte) 0x51,
                (byte) 0x1, (byte) 0xffffffa4, (byte) 0xffffffb9, (byte) 0x4e,
                (byte) 0x1e, (byte) 0xffffff85, (byte) 0xfffffffc,
                (byte) 0xffffffa6, (byte) 0x5a, (byte) 0xffffff96,
                (byte) 0xffffffb1, (byte) 0xffffffcb, (byte) 0xffffff81,
                (byte) 0xffffffa3, (byte) 0x6e, (byte) 0xffffff90,
                (byte) 0xffffffbd, (byte) 0xffffffa2, (byte) 0xe,
                (byte) 0xffffffb4, (byte) 0xffffffba, (byte) 0x2c, (byte) 0x45,
                (byte) 0x9, (byte) 0x1c, (byte) 0xffffff98, (byte) 0x39,
                (byte) 0x26, (byte) 0x24, (byte) 0x40, (byte) 0xffffff80,
                (byte) 0xffffffce, (byte) 0x15, (byte) 0xffffff8b,
                (byte) 0xffffffe1, (byte) 0x67, (byte) 0x48, (byte) 0xfffffff3,
                (byte) 0x70, (byte) 0xffffff98, (byte) 0xffffffca,
                (byte) 0xffffffa7, (byte) 0x71, (byte) 0x33, (byte) 0xffffffb6,
                (byte) 0x4, (byte) 0x13, (byte) 0xffffffe5, (byte) 0x61,
                (byte) 0x3c, (byte) 0x1f, (byte) 0x2, (byte) 0x40, (byte) 0x1e,
                (byte) 0xffffffd8, (byte) 0x6f, (byte) 0xffffffce, (byte) 0x23,
                (byte) 0x71, (byte) 0x6a, (byte) 0x2a, (byte) 0xffffffa3,
                (byte) 0x4d, (byte) 0x62, (byte) 0xffffffe9, (byte) 0x5f,
                (byte) 0x17, (byte) 0xffffffa8, (byte) 0xffffffe8,
                (byte) 0xffffffaa, (byte) 0xffffff8a, (byte) 0xffffff95,
                (byte) 0x26, (byte) 0x7c, (byte) 0x38, (byte) 0xffffffa9,
                (byte) 0x2b, (byte) 0x48, (byte) 0x5a, (byte) 0x16,
                (byte) 0x19, (byte) 0xfffffffa, (byte) 0xffffff83,
                (byte) 0xffffffb8, (byte) 0x76, (byte) 0xffffffaf,
                (byte) 0xffffffb8, (byte) 0x62, (byte) 0x72, (byte) 0x45,
                (byte) 0xffffff9f, (byte) 0xffffff95, (byte) 0x1e, (byte) 0x62,
                (byte) 0x36, (byte) 0xffffff97, (byte) 0xffffffbf,
                (byte) 0xffffffab, (byte) 0x20, (byte) 0xffffffb0, (byte) 0x61,
                (byte) 0xffffffc5, (byte) 0x21, (byte) 0xffffff9e,
                (byte) 0xffffffe4, (byte) 0xffffffde, (byte) 0xffffff91,
                (byte) 0x1c, (byte) 0x6a, (byte) 0x7, (byte) 0x48, (byte) 0x77,
                (byte) 0x70, (byte) 0x1d, (byte) 0xffffffff, (byte) 0x58,
                (byte) 0x23, (byte) 0x2, (byte) 0x2, (byte) 0x1,
                (byte) 0xffffffff, (byte) 0x3, (byte) 0x44, (byte) 0x0,
                (byte) 0x2, (byte) 0x41, (byte) 0x0, (byte) 0xffffff9d,
                (byte) 0xffffffc4, (byte) 0xffffffcd, (byte) 0x10,
                (byte) 0xffffffdf, (byte) 0x66, (byte) 0xffffff92,
                (byte) 0xffffffe1, (byte) 0x33, (byte) 0xffffffb1,
                (byte) 0xffffffc9, (byte) 0xffffff9f, (byte) 0xffffffb7,
                (byte) 0xffffffdd, (byte) 0xffffff84, (byte) 0x4b,
                (byte) 0xffffffe5, (byte) 0xffffff86, (byte) 0xfffffff0,
                (byte) 0x53, (byte) 0x2a, (byte) 0xffffffd5, (byte) 0xffffffc6,
                (byte) 0x15, (byte) 0xffffff94, (byte) 0xffffffae, (byte) 0x13,
                (byte) 0x7b, (byte) 0xffffff9d, (byte) 0x37, (byte) 0xffffff8b,
                (byte) 0xffffffc6, (byte) 0xffffffc6, (byte) 0x78,
                (byte) 0xffffff9c, (byte) 0x60, (byte) 0xffffff8a, (byte) 0x6f,
                (byte) 0x35, (byte) 0x39, (byte) 0xffffffe0, (byte) 0x78,
                (byte) 0x33, (byte) 0x60, (byte) 0xffffff89, (byte) 0x30,
                (byte) 0x61, (byte) 0xffffff84, (byte) 0xffffff8a,
                (byte) 0xffffffbc, (byte) 0xffffff80, (byte) 0x6c, (byte) 0x1c,
                (byte) 0x55, (byte) 0xffffff96, (byte) 0x50, (byte) 0xffffffb1,
                (byte) 0xffffff96, (byte) 0x5, (byte) 0x21, (byte) 0x65,
                (byte) 0x55, (byte) 0xffffffbb, (byte) 0xffffffa4
        });
    }

    public TestKeyPair(String algorithmName) throws
            NoSuchAlgorithmException {
        this.algorithmName = algorithmName;
        if (!privateKeyEncoding.containsKey(this.algorithmName)) {
            throw new NoSuchAlgorithmException("Encoded form not available for " +
                    this.algorithmName);
        }
        kf = KeyFactory.getInstance(this.algorithmName);
    }

    public PublicKey getPublic() throws
            InvalidKeySpecException {
        return kf.generatePublic(
                new X509EncodedKeySpec(
                        (byte[])publicKeyEncoding.get(algorithmName)));
    }

    public PrivateKey getPrivate() throws
            InvalidKeySpecException {
        return kf.generatePrivate(
                new PKCS8EncodedKeySpec(
                        (byte[])privateKeyEncoding.get(algorithmName)));
    }

}
