/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import com.google.analytics.tracking.android.Log;
import com.google.analytics.tracking.android.RateLimiter;
import com.google.android.gms.common.util.VisibleForTesting;

class SendHitRateLimiter
implements RateLimiter {
    private final long mMillisecondsPerToken;
    private final int mMaxTokens;
    private double mTokens;
    private long mLastTrackTime;
    private final Object mTokenLock = new Object();

    public SendHitRateLimiter(int maxTokenCount, long millisecondsPerToken) {
        this.mMaxTokens = maxTokenCount;
        this.mTokens = this.mMaxTokens;
        this.mMillisecondsPerToken = millisecondsPerToken;
    }

    public SendHitRateLimiter() {
        this(60, 2000L);
    }

    @VisibleForTesting
    void setLastTrackTime(long lastTrackTime) {
        this.mLastTrackTime = lastTrackTime;
    }

    @VisibleForTesting
    void setTokensAvailable(long tokens) {
        this.mTokens = tokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tokenAvailable() {
        Object object = this.mTokenLock;
        synchronized (object) {
            long timeElapsed;
            double tokensDue;
            long timeNow = System.currentTimeMillis();
            if (this.mTokens < (double)this.mMaxTokens && (tokensDue = (double)(timeElapsed = timeNow - this.mLastTrackTime) / (double)this.mMillisecondsPerToken) > 0.0) {
                this.mTokens = Math.min((double)this.mMaxTokens, this.mTokens + tokensDue);
            }
            this.mLastTrackTime = timeNow;
            if (this.mTokens >= 1.0) {
                this.mTokens -= 1.0;
                return true;
            }
            Log.w("Excessive tracking detected.  Tracking call ignored.");
            return false;
        }
    }
}

