/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.tagmanager.Dispatcher;
import com.google.tagmanager.Hit;
import com.google.tagmanager.Log;
import com.google.tagmanager.NetworkReceiver;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;

class SimpleNetworkDispatcher
implements Dispatcher {
    private static final String USER_AGENT_TEMPLATE = "%s/%s (Linux; U; Android %s; %s; %s Build/%s)";
    private final String userAgent;
    private final HttpClient httpClient;
    private final Context ctx;
    private DispatchListener dispatchListener;

    @VisibleForTesting
    SimpleNetworkDispatcher(HttpClient httpClient, Context ctx, DispatchListener dispatchListener) {
        this.ctx = ctx.getApplicationContext();
        this.userAgent = this.createUserAgentString("GoogleTagManager", "3.02", Build.VERSION.RELEASE, SimpleNetworkDispatcher.getUserAgentLanguage(Locale.getDefault()), Build.MODEL, Build.ID);
        this.httpClient = httpClient;
        this.dispatchListener = dispatchListener;
    }

    @Override
    public boolean okToDispatch() {
        ConnectivityManager cm = (ConnectivityManager)this.ctx.getSystemService("connectivity");
        NetworkInfo network = cm.getActiveNetworkInfo();
        if (network == null || !network.isConnected()) {
            Log.v("...no network connectivity");
            return false;
        }
        return true;
    }

    @Override
    public void dispatchHits(List<Hit> hits) {
        int maxHits = Math.min(hits.size(), 40);
        boolean firstSend = true;
        for (int i = 0; i < maxHits; ++i) {
            Hit hit = hits.get(i);
            URL url = this.getUrl(hit);
            if (url == null) {
                Log.w("No destination: discarding hit.");
                this.dispatchListener.onHitPermanentDispatchFailure(hit);
                continue;
            }
            HttpEntityEnclosingRequest request = this.constructGtmRequest(url);
            if (request == null) {
                this.dispatchListener.onHitPermanentDispatchFailure(hit);
                continue;
            }
            HttpHost targetHost = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
            request.addHeader("Host", targetHost.toHostString());
            this.logDebugInformation(request);
            try {
                if (firstSend) {
                    NetworkReceiver.sendRadioPoweredBroadcast(this.ctx);
                    firstSend = false;
                }
                HttpResponse response = this.httpClient.execute(targetHost, (HttpRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    entity.consumeContent();
                }
                if (statusCode != 200) {
                    Log.w("Bad response: " + response.getStatusLine().getStatusCode());
                    this.dispatchListener.onHitTransientDispatchFailure(hit);
                    continue;
                }
                this.dispatchListener.onHitDispatched(hit);
                continue;
            }
            catch (ClientProtocolException e) {
                Log.w("ClientProtocolException sending hit; discarding hit...");
                this.dispatchListener.onHitPermanentDispatchFailure(hit);
                continue;
            }
            catch (IOException e) {
                Log.w("Exception sending hit: " + e.getClass().getSimpleName());
                Log.w(e.getMessage());
                this.dispatchListener.onHitTransientDispatchFailure(hit);
            }
        }
    }

    @Override
    public void close() {
        this.httpClient.getConnectionManager().shutdown();
    }

    private HttpEntityEnclosingRequest constructGtmRequest(URL url) {
        BasicHttpEntityEnclosingRequest request = null;
        try {
            request = new BasicHttpEntityEnclosingRequest("GET", url.toURI().toString());
            request.addHeader("User-Agent", this.userAgent);
        }
        catch (URISyntaxException e) {
            Log.w("Exception sending hit: " + e.getClass().getSimpleName());
            Log.w(e.getMessage());
        }
        return request;
    }

    private void logDebugInformation(HttpEntityEnclosingRequest request) {
        StringBuffer httpHeaders = new StringBuffer();
        for (Header header : request.getAllHeaders()) {
            httpHeaders.append(header.toString()).append("\n");
        }
        httpHeaders.append(request.getRequestLine().toString()).append("\n");
        if (request.getEntity() != null) {
            try {
                int avail;
                InputStream is = request.getEntity().getContent();
                if (is != null && (avail = is.available()) > 0) {
                    byte[] b = new byte[avail];
                    is.read(b);
                    httpHeaders.append("POST:\n");
                    httpHeaders.append(new String(b)).append("\n");
                }
            }
            catch (IOException e) {
                Log.v("Error Writing hit to log...");
            }
        }
        Log.v(httpHeaders.toString());
    }

    String createUserAgentString(String product, String version, String release, String language, String model, String id) {
        return String.format(USER_AGENT_TEMPLATE, product, version, release, language, model, id);
    }

    static String getUserAgentLanguage(Locale locale) {
        if (locale == null) {
            return null;
        }
        if (locale.getLanguage() == null || locale.getLanguage().length() == 0) {
            return null;
        }
        StringBuilder lang = new StringBuilder();
        lang.append(locale.getLanguage().toLowerCase());
        if (locale.getCountry() != null && locale.getCountry().length() != 0) {
            lang.append("-").append(locale.getCountry().toLowerCase());
        }
        return lang.toString();
    }

    @VisibleForTesting
    URL getUrl(Hit hit) {
        String hitUrl = hit.getHitUrl();
        try {
            return new URL(hitUrl);
        }
        catch (MalformedURLException e) {
            Log.e("Error trying to parse the GTM url.");
            return null;
        }
    }

    public static interface DispatchListener {
        public void onHitDispatched(Hit var1);

        public void onHitPermanentDispatchFailure(Hit var1);

        public void onHitTransientDispatchFailure(Hit var1);
    }
}

