/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager.protobuf.nano;

import com.google.tagmanager.protobuf.nano.CodedInputByteBufferNano;
import com.google.tagmanager.protobuf.nano.CodedOutputByteBufferNano;
import com.google.tagmanager.protobuf.nano.Extension;
import com.google.tagmanager.protobuf.nano.MessageNano;
import com.google.tagmanager.protobuf.nano.UnknownFieldData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class WireFormatNano {
    static final int WIRETYPE_VARINT = 0;
    static final int WIRETYPE_FIXED64 = 1;
    static final int WIRETYPE_LENGTH_DELIMITED = 2;
    static final int WIRETYPE_START_GROUP = 3;
    static final int WIRETYPE_END_GROUP = 4;
    static final int WIRETYPE_FIXED32 = 5;
    static final int TAG_TYPE_BITS = 3;
    static final int TAG_TYPE_MASK = 7;
    static final int MESSAGE_SET_ITEM = 1;
    static final int MESSAGE_SET_TYPE_ID = 2;
    static final int MESSAGE_SET_MESSAGE = 3;
    static final int MESSAGE_SET_ITEM_TAG = WireFormatNano.makeTag(1, 3);
    static final int MESSAGE_SET_ITEM_END_TAG = WireFormatNano.makeTag(1, 4);
    static final int MESSAGE_SET_TYPE_ID_TAG = WireFormatNano.makeTag(2, 0);
    static final int MESSAGE_SET_MESSAGE_TAG = WireFormatNano.makeTag(3, 2);
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final byte[][] EMPTY_BYTES_ARRAY = new byte[0][];
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final Integer[] EMPTY_INT_REF_ARRAY = new Integer[0];
    public static final Long[] EMPTY_LONG_REF_ARRAY = new Long[0];
    public static final Float[] EMPTY_FLOAT_REF_ARRAY = new Float[0];
    public static final Double[] EMPTY_DOUBLE_REF_ARRAY = new Double[0];
    public static final Boolean[] EMPTY_BOOLEAN_REF_ARRAY = new Boolean[0];

    private WireFormatNano() {
    }

    static int getTagWireType(int tag) {
        return tag & 7;
    }

    public static int getTagFieldNumber(int tag) {
        return tag >>> 3;
    }

    static int makeTag(int fieldNumber, int wireType) {
        return fieldNumber << 3 | wireType;
    }

    public static boolean parseUnknownField(CodedInputByteBufferNano input, int tag) throws IOException {
        return input.skipField(tag);
    }

    public static boolean storeUnknownField(List<UnknownFieldData> data, CodedInputByteBufferNano input, int tag) throws IOException {
        int startPos = input.getPosition();
        boolean skip = input.skipField(tag);
        int endPos = input.getPosition();
        byte[] bytes = input.getData(startPos, endPos - startPos);
        data.add(new UnknownFieldData(tag, bytes));
        return skip;
    }

    public static final int getRepeatedFieldArrayLength(CodedInputByteBufferNano input, int tag) throws IOException {
        int thisTag;
        int arrayLength = 1;
        int startPos = input.getPosition();
        input.skipField(tag);
        while (input.getBytesUntilLimit() > 0 && (thisTag = input.readTag()) == tag) {
            input.skipField(tag);
            ++arrayLength;
        }
        input.rewindToPosition(startPos);
        return arrayLength;
    }

    public static <T> T getExtension(Extension<T> extension, List<UnknownFieldData> unknownFields) {
        if (unknownFields == null) {
            return null;
        }
        ArrayList<UnknownFieldData> dataForField = new ArrayList<UnknownFieldData>();
        for (UnknownFieldData data : unknownFields) {
            if (WireFormatNano.getTagFieldNumber(data.tag) != extension.fieldNumber) continue;
            dataForField.add(data);
        }
        if (dataForField.isEmpty()) {
            return null;
        }
        if (extension.isRepeatedField) {
            ArrayList result = new ArrayList(dataForField.size());
            for (UnknownFieldData data : dataForField) {
                result.add(WireFormatNano.readData(extension.fieldType, data.bytes));
            }
            return extension.listType.cast(result);
        }
        UnknownFieldData lastData = (UnknownFieldData)dataForField.get(dataForField.size() - 1);
        return WireFormatNano.readData(extension.fieldType, lastData.bytes);
    }

    private static <T> T readData(Class<T> clazz, byte[] data) {
        if (data.length == 0) {
            return null;
        }
        CodedInputByteBufferNano buffer = CodedInputByteBufferNano.newInstance(data);
        try {
            if (clazz == String.class) {
                return clazz.cast(buffer.readString());
            }
            if (clazz == Integer.class) {
                return clazz.cast(buffer.readInt32());
            }
            if (clazz == Long.class) {
                return clazz.cast(buffer.readInt64());
            }
            if (clazz == Boolean.class) {
                return clazz.cast(buffer.readBool());
            }
            if (clazz == Float.class) {
                return clazz.cast(Float.valueOf(buffer.readFloat()));
            }
            if (clazz == Double.class) {
                return clazz.cast(buffer.readDouble());
            }
            if (clazz == byte[].class) {
                return clazz.cast(buffer.readBytes());
            }
            if (MessageNano.class.isAssignableFrom(clazz)) {
                try {
                    MessageNano message = (MessageNano)clazz.newInstance();
                    buffer.readMessage(message);
                    return clazz.cast(message);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Error creating instance of class " + clazz, e);
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("Error creating instance of class " + clazz, e);
                }
            }
            throw new IllegalArgumentException("Unhandled extension field type: " + clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading extension field", e);
        }
    }

    public static <T> void setExtension(Extension<T> extension, T value, List<UnknownFieldData> unknownFields) {
        Iterator<UnknownFieldData> i = unknownFields.iterator();
        while (i.hasNext()) {
            UnknownFieldData data = i.next();
            if (extension.fieldNumber != WireFormatNano.getTagFieldNumber(data.tag)) continue;
            i.remove();
        }
        if (value == null) {
            return;
        }
        if (value instanceof List) {
            for (Object item : (List)value) {
                unknownFields.add(WireFormatNano.write(extension.fieldNumber, item));
            }
        } else {
            unknownFields.add(WireFormatNano.write(extension.fieldNumber, value));
        }
    }

    private static UnknownFieldData write(int fieldNumber, Object object) {
        int tag;
        byte[] data;
        block10: {
            Class<?> clazz = object.getClass();
            try {
                if (clazz == String.class) {
                    String str = (String)object;
                    data = new byte[CodedOutputByteBufferNano.computeStringSizeNoTag(str)];
                    CodedOutputByteBufferNano.newInstance(data).writeStringNoTag(str);
                    tag = WireFormatNano.makeTag(fieldNumber, 2);
                    break block10;
                }
                if (clazz == Integer.class) {
                    Integer integer = (Integer)object;
                    data = new byte[CodedOutputByteBufferNano.computeInt32SizeNoTag(integer)];
                    CodedOutputByteBufferNano.newInstance(data).writeInt32NoTag(integer);
                    tag = WireFormatNano.makeTag(fieldNumber, 0);
                    break block10;
                }
                if (clazz == Long.class) {
                    Long longValue = (Long)object;
                    data = new byte[CodedOutputByteBufferNano.computeInt64SizeNoTag(longValue)];
                    CodedOutputByteBufferNano.newInstance(data).writeInt64NoTag(longValue);
                    tag = WireFormatNano.makeTag(fieldNumber, 0);
                    break block10;
                }
                if (clazz == Boolean.class) {
                    Boolean boolValue = (Boolean)object;
                    data = new byte[CodedOutputByteBufferNano.computeBoolSizeNoTag(boolValue)];
                    CodedOutputByteBufferNano.newInstance(data).writeBoolNoTag(boolValue);
                    tag = WireFormatNano.makeTag(fieldNumber, 0);
                    break block10;
                }
                if (clazz == Float.class) {
                    Float floatValue = (Float)object;
                    data = new byte[CodedOutputByteBufferNano.computeFloatSizeNoTag(floatValue.floatValue())];
                    CodedOutputByteBufferNano.newInstance(data).writeFloatNoTag(floatValue.floatValue());
                    tag = WireFormatNano.makeTag(fieldNumber, 5);
                    break block10;
                }
                if (clazz == Double.class) {
                    Double doubleValue = (Double)object;
                    data = new byte[CodedOutputByteBufferNano.computeDoubleSizeNoTag(doubleValue)];
                    CodedOutputByteBufferNano.newInstance(data).writeDoubleNoTag(doubleValue);
                    tag = WireFormatNano.makeTag(fieldNumber, 1);
                    break block10;
                }
                if (clazz == byte[].class) {
                    byte[] byteArrayValue = (byte[])object;
                    data = new byte[CodedOutputByteBufferNano.computeByteArraySizeNoTag(byteArrayValue)];
                    CodedOutputByteBufferNano.newInstance(data).writeByteArrayNoTag(byteArrayValue);
                    tag = WireFormatNano.makeTag(fieldNumber, 2);
                    break block10;
                }
                if (MessageNano.class.isAssignableFrom(clazz)) {
                    MessageNano messageValue = (MessageNano)object;
                    int messageSize = messageValue.getSerializedSize();
                    int delimiterSize = CodedOutputByteBufferNano.computeRawVarint32Size(messageSize);
                    data = new byte[messageSize + delimiterSize];
                    CodedOutputByteBufferNano buffer = CodedOutputByteBufferNano.newInstance(data);
                    buffer.writeRawVarint32(messageSize);
                    buffer.writeRawBytes(MessageNano.toByteArray(messageValue));
                    tag = WireFormatNano.makeTag(fieldNumber, 2);
                    break block10;
                }
                throw new IllegalArgumentException("Unhandled extension field type: " + clazz);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return new UnknownFieldData(tag, data);
    }

    public static int computeWireSize(List<UnknownFieldData> unknownFields) {
        if (unknownFields == null) {
            return 0;
        }
        int size = 0;
        for (UnknownFieldData unknownField : unknownFields) {
            size += CodedOutputByteBufferNano.computeRawVarint32Size(unknownField.tag);
            size += unknownField.bytes.length;
        }
        return size;
    }

    public static void writeUnknownFields(List<UnknownFieldData> unknownFields, CodedOutputByteBufferNano outBuffer) throws IOException {
        if (unknownFields == null) {
            return;
        }
        for (UnknownFieldData data : unknownFields) {
            outBuffer.writeTag(WireFormatNano.getTagFieldNumber(data.tag), WireFormatNano.getTagWireType(data.tag));
            outBuffer.writeRawBytes(data.bytes);
        }
    }
}

