; RUN: llc -mtriple=x86_64-apple-darwin %s -o %t -filetype=obj
; RUN: llvm-dwarfdump -debug-dump=info %t | FileCheck %s
;
; Test the DW_AT_accessibility DWARF attribute.
;
;
; Regenerate me:
; clang++ -g tools/clang/test/CodeGenCXX/debug-info-access.cpp -S -emit-llvm -o -
;
;   struct A {
;     void pub_default();
;     static int pub_default_static;
;   };
;
;   class B : public A {
;   public:
;     void pub();
;     static int public_static;
;   protected:
;     void prot();
;   private:
;     void priv_default();
;   };
;
;   union U {
;     void union_pub_default();
;   private:
;     int union_priv;
;   };
;
;   void free() {}
;
;   A a;
;   B b;
;   U u;

; CHECK: DW_TAG_member
; CHECK:     DW_AT_name {{.*}}"pub_default_static")
; CHECK-NOT: DW_AT_accessibility
; CHECK-NOT: DW_TAG
;
; CHECK: DW_TAG_subprogram
; CHECK:     DW_AT_name {{.*}}"pub_default")
; CHECK-NOT: DW_AT_accessibility
; CHECK: DW_TAG
;
; CHECK: DW_TAG_inheritance
; CHECK-NOT: DW_TAG
; CHECK:     DW_AT_accessibility {{.*}}(DW_ACCESS_public)
;
; CHECK: DW_TAG_member
; CHECK:     DW_AT_name {{.*}}"public_static")
; CHECK-NOT: DW_TAG
; CHECK:     DW_AT_accessibility {{.*}}(DW_ACCESS_public)
;
; CHECK: DW_TAG_subprogram
; CHECK:     DW_AT_name {{.*}}"pub")
; CHECK-NOT: DW_TAG
; CHECK:     DW_AT_accessibility {{.*}}(DW_ACCESS_public)
;
; CHECK: DW_TAG_subprogram
; CHECK:     DW_AT_name {{.*}}"prot")
; CHECK-NOT: DW_TAG
; CHECK:     DW_AT_accessibility {{.*}}(DW_ACCESS_protected)
;
; CHECK: DW_TAG_subprogram
; CHECK:     DW_AT_name {{.*}}"priv_default")
; CHECK-NOT: DW_AT_accessibility
; CHECK: DW_TAG
;
; CHECK: DW_TAG_member
; CHECK:     DW_AT_name {{.*}}"union_priv")
; CHECK-NOT: DW_TAG
; CHECK:     DW_AT_accessibility {{.*}}(DW_ACCESS_private)
;
; CHECK: DW_TAG_subprogram
; CHECK:     DW_AT_name {{.*}}"union_pub_default")
; CHECK-NOT: DW_AT_accessibility
; CHECK: DW_TAG
;
; CHECK: DW_TAG_subprogram
; CHECK:     DW_AT_name {{.*}}"free")
; CHECK-NOT: DW_AT_accessibility
; CHECK-NOT: DW_TAG
;
; ModuleID = '/llvm/tools/clang/test/CodeGenCXX/debug-info-access.cpp'
target datalayout = "e-m:o-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-apple-macosx10.10.0"

%struct.A = type { i8 }
%class.B = type { i8 }
%union.U = type { i32 }

@a = global %struct.A zeroinitializer, align 1
@b = global %class.B zeroinitializer, align 1
@u = global %union.U zeroinitializer, align 4

; Function Attrs: nounwind ssp uwtable
define void @_Z4freev() #0 {
  ret void, !dbg !41
}

attributes #0 = { nounwind ssp uwtable }

!llvm.dbg.cu = !{!0}
!llvm.module.flags = !{!38, !39}
!llvm.ident = !{!40}

!0 = !MDCompileUnit(language: DW_LANG_C_plus_plus, producer: "clang version 3.6.0 ", isOptimized: false, emissionKind: 1, file: !1, enums: !2, retainedTypes: !3, subprograms: !29, globals: !34, imports: !2)
!1 = !MDFile(filename: "/llvm/tools/clang/test/CodeGenCXX/debug-info-access.cpp", directory: "")
!2 = !{}
!3 = !{!4, !12, !22}
!4 = !MDCompositeType(tag: DW_TAG_structure_type, name: "A", line: 3, size: 8, align: 8, file: !1, elements: !5, identifier: "_ZTS1A")
!5 = !{!6, !8}
!6 = !MDDerivedType(tag: DW_TAG_member, name: "pub_default_static", line: 7, flags: DIFlagStaticMember, file: !1, scope: !"_ZTS1A", baseType: !7)
!7 = !MDBasicType(tag: DW_TAG_base_type, name: "int", size: 32, align: 32, encoding: DW_ATE_signed)
!8 = !MDSubprogram(name: "pub_default", linkageName: "_ZN1A11pub_defaultEv", line: 5, isLocal: false, isDefinition: false, virtualIndex: 6, flags: DIFlagPrototyped, isOptimized: false, scopeLine: 5, file: !1, scope: !"_ZTS1A", type: !9)
!9 = !MDSubroutineType(types: !10)
!10 = !{null, !11}
!11 = !MDDerivedType(tag: DW_TAG_pointer_type, size: 64, align: 64, flags: DIFlagArtificial | DIFlagObjectPointer, baseType: !"_ZTS1A")
!12 = !MDCompositeType(tag: DW_TAG_class_type, name: "B", line: 11, size: 8, align: 8, file: !1, elements: !13, identifier: "_ZTS1B")
!13 = !{!14, !15, !16, !20, !21}
!14 = !MDDerivedType(tag: DW_TAG_inheritance, flags: DIFlagPublic, scope: !"_ZTS1B", baseType: !"_ZTS1A")
!15 = !MDDerivedType(tag: DW_TAG_member, name: "public_static", line: 16, flags: DIFlagPublic | DIFlagStaticMember, file: !1, scope: !"_ZTS1B", baseType: !7)
!16 = !MDSubprogram(name: "pub", linkageName: "_ZN1B3pubEv", line: 14, isLocal: false, isDefinition: false, virtualIndex: 6, flags: DIFlagPublic | DIFlagPrototyped, isOptimized: false, scopeLine: 14, file: !1, scope: !"_ZTS1B", type: !17)
!17 = !MDSubroutineType(types: !18)
!18 = !{null, !19}
!19 = !MDDerivedType(tag: DW_TAG_pointer_type, size: 64, align: 64, flags: DIFlagArtificial | DIFlagObjectPointer, baseType: !"_ZTS1B")
!20 = !MDSubprogram(name: "prot", linkageName: "_ZN1B4protEv", line: 19, isLocal: false, isDefinition: false, virtualIndex: 6, flags: DIFlagProtected | DIFlagPrototyped, isOptimized: false, scopeLine: 19, file: !1, scope: !"_ZTS1B", type: !17)
!21 = !MDSubprogram(name: "priv_default", linkageName: "_ZN1B12priv_defaultEv", line: 22, isLocal: false, isDefinition: false, virtualIndex: 6, flags: DIFlagPrototyped, isOptimized: false, scopeLine: 22, file: !1, scope: !"_ZTS1B", type: !17)
!22 = !MDCompositeType(tag: DW_TAG_union_type, name: "U", line: 25, size: 32, align: 32, file: !1, elements: !23, identifier: "_ZTS1U")
!23 = !{!24, !25}
!24 = !MDDerivedType(tag: DW_TAG_member, name: "union_priv", line: 30, size: 32, align: 32, flags: DIFlagPrivate, file: !1, scope: !"_ZTS1U", baseType: !7)
!25 = !MDSubprogram(name: "union_pub_default", linkageName: "_ZN1U17union_pub_defaultEv", line: 27, isLocal: false, isDefinition: false, virtualIndex: 6, flags: DIFlagPrototyped, isOptimized: false, scopeLine: 27, file: !1, scope: !"_ZTS1U", type: !26)
!26 = !MDSubroutineType(types: !27)
!27 = !{null, !28}
!28 = !MDDerivedType(tag: DW_TAG_pointer_type, size: 64, align: 64, flags: DIFlagArtificial | DIFlagObjectPointer, baseType: !"_ZTS1U")
!29 = !{!30}
!30 = !MDSubprogram(name: "free", linkageName: "_Z4freev", line: 35, isLocal: false, isDefinition: true, virtualIndex: 6, flags: DIFlagPrototyped, isOptimized: false, scopeLine: 35, file: !1, scope: !31, type: !32, function: void ()* @_Z4freev, variables: !2)
!31 = !MDFile(filename: "/llvm/tools/clang/test/CodeGenCXX/debug-info-access.cpp", directory: "")
!32 = !MDSubroutineType(types: !33)
!33 = !{null}
!34 = !{!35, !36, !37}
!35 = !MDGlobalVariable(name: "a", line: 37, isLocal: false, isDefinition: true, scope: null, file: !31, type: !"_ZTS1A", variable: %struct.A* @a)
!36 = !MDGlobalVariable(name: "b", line: 38, isLocal: false, isDefinition: true, scope: null, file: !31, type: !"_ZTS1B", variable: %class.B* @b)
!37 = !MDGlobalVariable(name: "u", line: 39, isLocal: false, isDefinition: true, scope: null, file: !31, type: !"_ZTS1U", variable: %union.U* @u)
!38 = !{i32 2, !"Dwarf Version", i32 2}
!39 = !{i32 2, !"Debug Info Version", i32 3}
!40 = !{!"clang version 3.6.0 "}
!41 = !MDLocation(line: 35, column: 14, scope: !30)
