; RUN: opt %s -S -place-safepoints | FileCheck %s

declare i64 addrspace(1)* @"some_call"(i64 addrspace(1)*)
declare i32 @"personality_function"()

define i64 addrspace(1)* @test_basic(i64 addrspace(1)* %obj, i64 addrspace(1)* %obj1) gc "statepoint-example" {
; CHECK-LABEL: entry:
entry:
  ; CHECK: invoke
  ; CHECK: statepoint
  ; CHECK: some_call
  %ret_val = invoke i64 addrspace(1)* @"some_call"(i64 addrspace(1)* %obj)
               to label %normal_return unwind label %exceptional_return

; CHECK-LABEL: normal_return:
; CHECK: gc.result
; CHECK: ret i64

normal_return:
  ret i64 addrspace(1)* %ret_val

; CHECK-LABEL: exceptional_return:
; CHECK: landingpad
; CHECK: ret i64

exceptional_return:
  %landing_pad4 = landingpad {i8*, i32} personality i32 ()* @"personality_function"
          cleanup
  ret i64 addrspace(1)* %obj1
}

define i64 addrspace(1)* @test_two_invokes(i64 addrspace(1)* %obj, i64 addrspace(1)* %obj1) gc "statepoint-example" {
; CHECK-LABEL: entry:
entry:
  ; CHECK: invoke 
  ; CHECK: statepoint
  ; CHECK: some_call
  %ret_val1 = invoke i64 addrspace(1)* @"some_call"(i64 addrspace(1)* %obj)
               to label %second_invoke unwind label %exceptional_return

; CHECK-LABEL: second_invoke:
second_invoke:
  ; CHECK: invoke
  ; CHECK: statepoint
  ; CHECK: some_call
  %ret_val2 = invoke i64 addrspace(1)* @"some_call"(i64 addrspace(1)* %ret_val1)
                to label %normal_return unwind label %exceptional_return

; CHECK-LABEL: normal_return:
normal_return:
  ; CHECK: gc.result
  ; CHECK: ret i64
  ret i64 addrspace(1)* %ret_val2

; CHECK: exceptional_return:
; CHECK: ret i64

exceptional_return:
  %landing_pad4 = landingpad {i8*, i32} personality i32 ()* @"personality_function"
          cleanup
  ret i64 addrspace(1)* %obj1
}

define i64 addrspace(1)* @test_phi_node(i1 %cond, i64 addrspace(1)* %obj) gc "statepoint-example" {
; CHECK-LABEL: entry:
entry:
  br i1 %cond, label %left, label %right

left:
  %ret_val_left = invoke i64 addrspace(1)* @"some_call"(i64 addrspace(1)* %obj)
                    to label %merge unwind label %exceptional_return

right:
  %ret_val_right = invoke i64 addrspace(1)* @"some_call"(i64 addrspace(1)* %obj)
                     to label %merge unwind label %exceptional_return

; CHECK-LABEL: merge1:
; CHECK: gc.result
; CHECK: br label %merge

; CHECK-LABEL: merge3:
; CHECK: gc.result
; CHECK: br label %merge

; CHECK-LABEL: merge:
; CHECK: phi
; CHECK: ret i64 addrspace(1)* %ret_val
merge:
  %ret_val = phi i64 addrspace(1)* [%ret_val_left, %left], [%ret_val_right, %right]
  ret i64 addrspace(1)* %ret_val

; CHECK-LABEL: exceptional_return:
; CHECK: ret i64 addrspace(1)*

exceptional_return:
  %landing_pad4 = landingpad {i8*, i32} personality i32 ()* @"personality_function"
          cleanup
  ret i64 addrspace(1)* %obj
}

declare void @do_safepoint()
define void @gc.safepoint_poll() {
; CHECK-LABEL: gc.safepoint_poll
; CHECK-LABEL: entry
; CHECK-NEXT: do_safepoint
; CHECK-NEXT: ret void 
entry:
  call void @do_safepoint()
  ret void
}
