# Mesa 3-D graphics library
#
# Copyright (C) 2010-2011 Chia-I Wu <olvaffe@gmail.com>
# Copyright (C) 2010-2011 LunarG Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

# included by core mesa Android.mk for source generation

ifeq ($(LOCAL_MODULE_CLASS),)
LOCAL_MODULE_CLASS := STATIC_LIBRARIES
endif

intermediates := $(call local-generated-sources-dir)

# This is the list of auto-generated files: sources and headers
sources := \
	main/enums.c \
	main/api_exec.c \
	main/dispatch.h \
	main/format_fallback.c \
	main/format_pack.c \
	main/format_unpack.c \
	main/format_info.h \
	main/remap_helper.h \
	main/get_hash.h \
	main/marshal_generated.c \
	main/marshal_generated.h

LOCAL_SRC_FILES := $(filter-out $(sources), $(LOCAL_SRC_FILES))

LOCAL_C_INCLUDES += $(intermediates)/main

ifeq ($(strip $(MESA_ENABLE_ASM)),true)
LOCAL_GENERATED_SOURCES_x86 += $(addprefix $(intermediates)/, x86/matypes.h)
LOCAL_GENERATED_SOURCES_x86_64 += $(addprefix $(intermediates)/, x86_64/matypes.h)

LOCAL_C_INCLUDES_x86 += $(intermediates)/x86
LOCAL_C_INCLUDES_x86_64 += $(intermediates)/x86_64
endif

sources := $(addprefix $(intermediates)/, $(sources))

LOCAL_GENERATED_SOURCES += $(sources)

glapi := $(MESA_TOP)/src/mapi/glapi/gen

dispatch_deps := \
	$(wildcard $(glapi)/*.py) \
	$(wildcard $(glapi)/*.xml)

define es-gen
	@mkdir -p $(dir $@)
	@echo "Gen ES: $(PRIVATE_MODULE) <= $(notdir $(@))"
	$(hide) $(PRIVATE_SCRIPT) $(1) $(PRIVATE_XML) > $@
endef

matypes_deps32 := \
	$(BUILD_OUT_EXECUTABLES)/mesa_gen_matypes32$(BUILD_EXECUTABLE_SUFFIX) \
	$(LOCAL_PATH)/main/mtypes.h \
	$(LOCAL_PATH)/tnl/t_context.h

matypes_deps64 := \
	$(BUILD_OUT_EXECUTABLES)/mesa_gen_matypes64$(BUILD_EXECUTABLE_SUFFIX) \
	$(LOCAL_PATH)/main/mtypes.h \
	$(LOCAL_PATH)/tnl/t_context.h

$(intermediates)/x86/matypes.h: $(matypes_deps32)
	@mkdir -p $(dir $@)
	@echo "MATYPES: $(PRIVATE_MODULE) <= $(notdir $@)"
	$(hide) $< > $@

$(intermediates)/x86_64/matypes.h: $(matypes_deps64)
	@mkdir -p $(dir $@)
	@echo "MATYPES: $(PRIVATE_MODULE) <= $(notdir $@)"
	$(hide) $< > $@

$(intermediates)/main/dispatch.h: PRIVATE_SCRIPT := $(MESA_PYTHON2) $(glapi)/gl_table.py
$(intermediates)/main/dispatch.h: PRIVATE_XML := -f $(glapi)/gl_and_es_API.xml

$(intermediates)/main/dispatch.h: $(dispatch_deps)
	$(call es-gen, $* -m remap_table)

$(intermediates)/main/remap_helper.h: PRIVATE_SCRIPT := $(MESA_PYTHON2) $(glapi)/remap_helper.py
$(intermediates)/main/remap_helper.h: PRIVATE_XML := -f $(glapi)/gl_and_es_API.xml

$(intermediates)/main/remap_helper.h: $(dispatch_deps)
	$(call es-gen, $*)

$(intermediates)/main/enums.c: PRIVATE_SCRIPT :=$(MESA_PYTHON2) $(glapi)/gl_enums.py
$(intermediates)/main/enums.c: PRIVATE_XML := -f $(glapi)/../registry/gl.xml

$(intermediates)/main/enums.c: $(dispatch_deps)
	$(call es-gen)

$(intermediates)/main/api_exec.c: PRIVATE_SCRIPT := $(MESA_PYTHON2) $(glapi)/gl_genexec.py
$(intermediates)/main/api_exec.c: PRIVATE_XML := -f $(glapi)/gl_and_es_API.xml

$(intermediates)/main/api_exec.c: $(dispatch_deps)
	$(call es-gen)

$(intermediates)/main/marshal_generated.c: PRIVATE_SCRIPT := $(MESA_PYTHON2) $(glapi)/gl_marshal.py
$(intermediates)/main/marshal_generated.c: PRIVATE_XML := -f $(glapi)/gl_and_es_API.xml

$(intermediates)/main/marshal_generated.c: $(dispatch_deps)
	$(call es-gen)

$(intermediates)/main/marshal_generated.h: PRIVATE_SCRIPT := $(MESA_PYTHON2) $(glapi)/gl_marshal_h.py
$(intermediates)/main/marshal_generated.h: PRIVATE_XML := -f $(glapi)/gl_and_es_API.xml

$(intermediates)/main/marshal_generated.h: $(dispatch_deps)
	$(call es-gen)

GET_HASH_GEN := $(LOCAL_PATH)/main/get_hash_generator.py

$(intermediates)/main/get_hash.h: PRIVATE_SCRIPT := $(MESA_PYTHON2) $(GET_HASH_GEN)
$(intermediates)/main/get_hash.h: PRIVATE_XML := -f $(glapi)/gl_and_es_API.xml
$(intermediates)/main/get_hash.h: $(glapi)/gl_and_es_API.xml \
               $(LOCAL_PATH)/main/get_hash_params.py $(GET_HASH_GEN)
	$(call es-gen)

FORMAT_FALLBACK := $(LOCAL_PATH)/main/format_fallback.py
format_fallback_deps := \
	$(LOCAL_PATH)/main/formats.csv \
	$(LOCAL_PATH)/main/format_parser.py \
	$(FORMAT_FALLBACK)

$(intermediates)/main/format_fallback.c: PRIVATE_SCRIPT := $(MESA_PYTHON2) $(FORMAT_FALLBACK)
$(intermediates)/main/format_fallback.c: PRIVATE_XML :=
$(intermediates)/main/format_fallback.c: $(format_fallback_deps)
	$(call es-gen, $< /dev/stdout)

FORMAT_INFO := $(LOCAL_PATH)/main/format_info.py
format_info_deps := \
	$(LOCAL_PATH)/main/formats.csv \
	$(LOCAL_PATH)/main/format_parser.py \
	$(FORMAT_INFO)

$(intermediates)/main/format_info.h: PRIVATE_SCRIPT := $(MESA_PYTHON2) $(FORMAT_INFO)
$(intermediates)/main/format_info.h: PRIVATE_XML :=
$(intermediates)/main/format_info.h: $(format_info_deps)
	$(call es-gen, $<)

FORMAT_PACK := $(LOCAL_PATH)/main/format_pack.py
format_pack_deps := \
	$(LOCAL_PATH)/main/formats.csv \
	$(LOCAL_PATH)/main/format_parser.py \
	$(FORMAT_PACK)

$(intermediates)/main/format_pack.c: PRIVATE_SCRIPT := $(MESA_PYTHON2) $(FORMAT_PACK)
$(intermediates)/main/format_pack.c: PRIVATE_XML :=
$(intermediates)/main/format_pack.c: $(format_pack_deps)
	$(call es-gen, $<)

FORMAT_UNPACK := $(LOCAL_PATH)/main/format_unpack.py
format_unpack_deps := \
	$(LOCAL_PATH)/main/formats.csv \
	$(LOCAL_PATH)/main/format_parser.py \
	$(FORMAT_UNPACK)

$(intermediates)/main/format_unpack.c: PRIVATE_SCRIPT := $(MESA_PYTHON2) $(FORMAT_UNPACK)
$(intermediates)/main/format_unpack.c: PRIVATE_XML :=
$(intermediates)/main/format_unpack.c: $(format_unpack_deps)
	$(call es-gen, $<)
