/*
 * This file is part of MPlayer.
 *
 * MPlayer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MPlayer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with MPlayer; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef MPLAYER_MATRIXVIEW_FONT_H
#define MPLAYER_MATRIXVIEW_FONT_H

#include <stdint.h>

#define FONT_TEXTURE_W 128
#define FONT_TEXTURE_H 64
static const uint8_t font_texture[FONT_TEXTURE_H][FONT_TEXTURE_W] = {
    {
      2,   2,   2,   2,   5,  20,  52,  77,  13,   2,   2,   2,   2,   2,   2,   3,
     13,  42,  67,  71,  66,  34,   7,   2,   2,   2,   2,   4,  36,  69,  71,  71,
     71,  71,  70,  35,   4,   3,   2,   2,   2,   2,   2,   3,   2,  29,  70,  71,
     39,   3,   2,   3,   3,  44,  71,  71,  71,  72,  71,  71,  71,  65,  13,   2,
      3,   2,   3,   5,  30,  64,  72,  71,  45,  13,   3,   2,   2,   2,  29,  71,
     71,  71,  71,  71,  71,  71,  71,  47,   2,   2,   2,   2,   2,   5,  26,  58,
     63,  36,   7,   2,   2,   2,   2,   2,   2,  12,  58,  71,  71,  71,  71,  61,
     15,   2,   2,   2,   2,   3,   2,   3,   2,   2,   2,   2,   3,   2,   3,   5
    }, {
      2,   2,   2,   3,  30, 122, 127, 122,  20,   3,   2,   2,   2,   2,   3,  33,
    110, 125,  85,  54,  64, 111,  80,   8,   3,   3,   3,  20,  92,  63,  50,  50,
     83, 125, 127, 121,  29,   2,   2,   2,   2,   2,   3,   3,  14, 106, 118, 127,
     74,   2,   3,   3,   3,  42,  67,  67,  67,  67,  67, 102, 127, 120,  22,   3,
      2,   3,   8,  79, 125, 115,  73, 103, 127, 107,  28,   3,   2,   2,  21,  50,
     50,  49,  50,  50,  56, 118, 127,  85,   2,   2,   2,   2,   6,  65, 124, 127,
    123, 126,  89,  15,   2,   2,   2,   2,   3,  80, 127, 126,  65,  62, 124, 127,
     86,   5,   3,   2,   3,   3,   4,  12,  13,   7,   7,  12,  12,   4,   3,   6
    }, {
      2,   2,   2,   3,  12,  59, 125, 123,  20,   3,   2,   2,   2,   2,   7, 102,
    127,  99,   5,   3,   3,  24,  90,  32,   3,   3,   3,   3,   2,   3,   3,   3,
      5,  86, 127, 127,  51,   3,   2,   2,   2,   2,   3,   5,  78, 101,  70, 127,
     74,   3,   3,   3,   2,   3,   3,   3,   3,   3,   2,  71, 127, 120,  23,   2,
      3,   3,  50, 126, 126,  35,   2,  14, 113, 127,  78,   5,   3,   3,   3,   3,
      2,   2,   3,   3,  21, 118, 127,  78,   2,   2,   2,   2,  36, 125, 127,  77,
     35, 106, 127,  76,   2,   2,   2,   2,   2,  93, 127, 109,  12,  35, 123, 127,
    100,   7,   3,   3,   3,   3,  16, 105, 110,  47,  54, 109,  98,  15,   3,   5
    }, {
      2,   2,   2,   2,   3,  31, 124, 123,  21,   2,   2,   2,   2,   2,   9, 112,
    127,  93,   4,   3,   3,   3,   3,   2,   3,   3,   3,   3,   3,   3,   3,   3,
      2,  64, 127, 127,  51,   3,   2,   2,   2,   2,   3,  47, 116,  33,  62, 127,
     73,   3,   3,   2,   3,   7,  48,  77,  77,  77,  78, 107, 127, 119,  22,   3,
      2,   3,  90, 127, 114,  14,   3,   5,  94, 127,  95,   7,   3,   3,   3,   3,
      3,   3,   3,   4,  64, 127, 123,  29,   2,   2,   2,   2,  45, 127, 126,  56,
     15,  93, 127,  82,   2,   2,   2,   2,   3,  93, 127, 108,  15,  95, 127, 127,
     99,   8,   3,   3,   3,   2,  29, 127, 127,  41,  78, 127, 110,  14,   3,   6
    }, {
      2,   2,   2,   2,   2,  30, 124, 123,  20,   2,   2,   2,   2,   2,   5,  83,
    127, 113,  11,   2,   3,   3,   2,   3,   2,   3,   3,   3,   3,   3,   3,   3,
      3,  68, 127, 127,  51,   3,   3,   3,   2,   3,  20, 111,  62,   3,  62, 127,
     74,   2,   2,   3,   3,  50, 126, 127, 118,  66,  47,  47,  47,  43,   9,   2,
      2,   3,  98, 127, 125,  23,   3,  11, 110, 127,  87,   5,   3,   2,   2,   2,
      3,   3,   3,  26, 118, 127,  73,   4,   3,   2,   2,   2,  12, 100, 127, 122,
    109, 127, 115,  31,   2,   2,   2,   2,   2,  94, 127, 109,  55, 125, 127, 127,
     99,   7,   2,   3,   3,   3,  42, 127, 124,  32,  92, 127, 100,   7,   3,   5
    }, {
      2,   2,   2,   2,   2,  30, 124, 122,  20,   2,   2,   2,   2,   2,   2,  14,
     88, 126,  91,  18,   3,   3,   2,   2,   2,   2,   3,   3,   2,   9,   9,  10,
     25, 108, 127, 127,  48,   3,   2,   3,   4,   7,  86,  99,  15,  10,  66, 127,
     73,   2,   2,   2,   2,  65, 127, 127,  61,   4,   3,   3,   2,   2,   2,   2,
      2,   3,  92, 127, 127,  94,  48,  82, 126, 124,  57,   3,   3,   2,   2,   2,
      2,   4,   8,  91, 127, 106,  15,   3,   2,   2,   2,   2,   3,  53, 125, 127,
    127, 127,  74,   6,   2,   2,   2,   2,   2,  93, 127, 115, 115,  98, 121, 127,
     99,   7,   2,   2,   3,   3,  59, 127, 120,  26, 100, 127,  92,   3,   3,   5
    }, {
      2,   2,   2,   2,   2,  30, 124, 123,  20,   2,   2,   2,   2,   2,   3,   3,
     10,  66, 121, 110,  42,   5,   3,   2,   2,   2,   3,   2,   3,  87, 102, 103,
    114, 119, 118,  91,  15,   3,   3,   3,   3,  54, 126, 114, 102, 102, 115, 127,
     74,   3,   2,   2,   2,  66, 127, 127,  50,   3,   3,   3,   2,   2,   2,   2,
      2,   3,  72, 127, 114,  84, 104, 105,  91,  46,   5,   3,   3,   2,   2,   2,
      2,   3,  51, 126, 126,  47,   3,   3,   2,   2,   2,   2,  29, 120, 127, 107,
     82, 122, 125,  49,   2,   2,   2,   2,   3,  93, 127, 127, 123,  36, 117, 127,
     99,   7,   2,   2,   3,   3,  75, 127, 115,  24, 108, 127,  80,   3,   3,   5
    }, {
      2,   2,   2,   2,   2,  30, 124, 123,  20,   2,   2,   2,   2,   2,   2,   3,
      3,   4,  35, 107, 122,  66,  10,   3,   2,   2,   3,   3,   3,  34,  86, 120,
    112,  63,  29,   5,   3,   2,   3,   3,   4,  44,  59,  59,  59,  59,  93, 127,
     73,   3,   2,   2,   2,  65, 127, 127,  53,   2,   2,   2,   2,   2,   2,   2,
      2,   2,  32, 122, 125,  40,   3,   3,   2,   3,   3,   3,   3,   2,   2,   2,
      2,   7,  97, 127, 105,  10,   3,   3,   3,   2,   2,   2,  52, 127, 126,  45,
      5,  88, 127,  78,   2,   2,   2,   2,   3,  93, 127, 127,  83,   9, 117, 127,
     99,   7,   2,   2,   3,   3,  72, 111,  94,  20, 101, 111,  55,   2,   3,   5
    }, {
      6,   5,   6,   6,   6,  60, 249, 246,  40,   6,   5,   5,   5,   5,  13,  21,
     22,  22,  22,  47, 174, 254, 193,  49,   6,   5,   6,  16,  37,  36,  38,  83,
    183, 249, 209, 116,  23,   5,   6,   6,   6,   6,   7,   6,   5,   5, 123, 255,
    149,   5,   5,   5,   5, 129, 255, 255, 193,  42,  10,   8,  44,  61,  12,   5,
      6,   6,   7, 124, 243, 225,  82,  17,   6,   7,   7,   6,   6,   6,   5,   5,
      6,  20, 208, 255, 192,   6,   6,   5,   6,   5,   6,   5,  51, 237, 255, 199,
    149, 236, 249,  87,   6,   5,   5,   5,   5, 184, 255, 254,  72,  38, 238, 255,
    196,  14,   7,   6,   6,   5,  17,  24,  20,   8,  23,  24,  15,   5,   5,   5
    }, {
      7,   6,   6,   6,   5,  55, 226, 221,  38,   6,   5,   5,   5,   5,  96, 192,
    191, 192, 192, 191, 197, 234, 234, 151,   7,   6,   6,  74, 209, 209, 209, 210,
    210, 230, 235, 231,  85,   6,   6,   5,  21, 152, 174, 174, 174, 175, 204, 235,
    131,   5,   5,   5,   5,  53, 202, 233, 234, 210, 180, 176, 209, 151,  15,   5,
      6,   6,   6,   7,  63, 169, 215, 184, 148, 128,  14,   6,   6,   6,   6,   6,
      6,  18, 189, 235, 174,   6,   6,   6,   7,   6,   7,   6,   8,  82, 205, 242,
    244, 215, 115,  11,   6,   7,   6,   6,   6,  90, 219, 234, 205, 204, 235, 218,
    100,   7,   6,   6,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5
    }, {
      6,   6,   6,   7,   5,  13,  39,  36,  10,   6,   6,   5,   5,   5,  23,  40,
     40,  40,  39,  40,  40,  40,  39,  29,   6,   6,   6,  17,  38,  40,  40,  39,
     40,  41,  39,  41,  17,   6,   6,   6,  11,  50,  58,  49,  39,  38,  39,  38,
     25,   5,   5,   5,   5,  12,  37,  56,  58,  57,  58,  57,  51,  21,   6,   6,
      6,   6,   6,   7,   5,   5,  27,  38,  39,  39,  10,   6,   6,   6,   7,   6,
      5,   7,  33,  40,  30,   6,   6,   7,   6,   5,   6,   6,  18,  25,  36,  68,
     71,  40,  24,  23,  23,   9,   5,   6,   6,   6,  26,  40,  40,  40,  38,  25,
      6,   6,   6,   6,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5
    }, {
      5, 137, 201, 200, 201, 201, 201, 200, 201, 168,  18,   5,   5,   5,   5,   5,
      5,   6,  18,  25,  36,  44,  59,  51,  10,   7,   5,   6,   6,   6,   6,   6,
      6,   6,   6,   6,   6,   6,   6,   5,  15, 168, 217, 123,   5,   6,   6,   6,
      6,   6,   5,   5,   5,  76, 192, 194, 195, 195, 194, 210, 217, 158,   6,   5,
      6,   6,   5,   5,   5,   6,   6,   5,   6,   6,   6,   6,   6,   5,   5,  16,
     78,  78,  78,  79,  78,  79,  62,  10,   5,   6,   6,  10, 125, 175, 176, 177,
    175, 182, 216, 218, 183,  33,   6,   6,   6,   7,   6,   6,   6,   6,   5,   6,
      6,   6,   7,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5
    }, {
      5, 173, 247, 178, 168, 170, 169, 169, 169, 140,  15,   5,   5,   5,  61, 172,
    187, 204, 213, 220, 230, 238, 247, 212,  23,   5,   5,   6,   6,   6,   6,  19,
    121, 179, 147,  36,   7,   6,   5,   8,  45, 209, 255, 166,  44,  43,  43,  43,
     42,  28,   5,   5,   5,  18,  36,  37,  37,  37,  74, 235, 255, 183,   6,   6,
      6,   6,   6,   6,   6,   6,   6,   5,   6,   6,   6,   6,   5,   6,   6,  45,
    249, 248, 254, 255, 251, 248, 192,  16,   6,   6,   7,   7,  16,  22,  22,  22,
     22,  45, 243, 255, 134,   8,   6,   5,   6,  24,  78,  83,  60,  10,   5,   6,
      6,   6,   6,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5
    }, {
      5, 173, 228,  26,   7,   6,   5,   6,   6,   5,   5,   5,   5,   5, 111, 255,
    251, 246, 232, 226, 210, 202, 190, 147,  17,   6,   6,   7,   6,   6,  62, 196,
    252, 181,  49,   7,   6,   6,   6,  23, 200, 252, 255, 248, 237, 238, 238, 238,
    238, 151,   5,   5,   5,   5,   6,   5,   6,  30, 201, 255, 245,  85,   5,   6,
      6,   6,   6,   7,   6,   6,   6,   6,   7,   6,   6,   7,   6,   7,   5,  12,
     51,  52, 184, 255, 105,  52,  40,   8,   6,   5,   6,   7,  33,  44,  44,  44,
     44,  66, 244, 255, 144,  11,   6,   6,   6,  21, 123, 236, 244, 153,  32,   6,
      6,   7,   5,   6,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5
    }, {
      5, 173, 228,  27,   6,   6,   6,   5,   5,   6,   5,   5,   5,   5,  28,  70,
     75,  85,  81,  93,  86,  97,  84,   5,   6,   6,   8,   6,  21, 132, 239, 230,
    106,  19,   6,   6,   6,   7,   6,  13,  85, 215, 255, 191,  96,  96,  96,  96,
     96,  62,   5,   5,   5,   6,   6,   6,  17, 175, 255, 249, 114,   8,   5,   7,
      5,   5,  23,  28,  27,  27,  12,  22,  28,  28,  27,  11,   5,   6,   6,   6,
      6,   6, 169, 255,  71,   5,   6,   7,   6,   6,   6,  12, 174, 240, 240, 240,
    239, 241, 255, 255, 230,  43,   6,   6,   6,   7,   7,  53, 183, 253, 214,  83,
      9,   6,   6,   6,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5
    }, {
      5, 173, 228,  26,   6,   6,   6,   6,   6,   6,   5,   5,   5,   5,   5, 101,
    226, 236, 240, 249, 251, 255, 213,   6,   6,   6,   5,   5,  47, 211, 255, 184,
     36,   6,   6,   6,   5,   7,   6,   6,   6, 158, 255, 179,   7,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   6,  12, 146, 253, 253, 143,  11,   6,   6,   6,
      6,  13, 193, 227, 227, 225,  47, 199, 226, 227, 216,  39,   5,   6,   6,   7,
      6,   6, 168, 255,  70,   7,   6,   5,   6,   6,   6,   7,  44,  60,  60,  60,
     60,  79, 246, 255, 152,  14,   6,   6,   6,   6,   5,   7,  17, 130, 253, 247,
    132,  10,   6,   6,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5
    }, {
      2,  86, 114,  13,   3,   3,   3,   2,   2,   2,   3,   3,   2,   2,   2,  49,
    107, 101,  97,  90,  83,  78,  54,   2,   3,   3,   3,   3,   3,  14,  75, 123,
    110,  45,   5,   2,   3,   3,   2,   3,   4,  42, 127, 114,  16,   3,   3,   3,
      2,   2,   2,   2,   2,   2,   4,  54, 124, 127,  89,   8,   2,   3,   3,   3,
      2,   4,  24,  28,  28,  26,   6,  25,  28,  28,  26,   4,   2,   3,   3,   3,
      3,   3,  83, 127,  35,   3,   3,   3,   3,   3,   3,   3,   3,   2,   3,   3,
      2,  15, 120, 127,  64,   3,   2,   3,   2,   2,   3,   3,  40, 106, 126,  92,
     27,   4,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5
    }, {
      3,  86, 114,  13,   3,   3,   3,   2,   2,   2,   3,   3,   2,   3,  11,  33,
     47,  45,  52,  58,  67,  79,  83,  80,   9,   4,   3,   3,   3,   3,   5,  37,
    103, 118,  73,  12,   3,   3,   3,   3,   3,  10,  98, 127,  67,   3,   3,   3,
      3,   2,   2,   2,   2,   3,  38, 120, 127, 103,  17,   3,   3,   3,   3,   3,
      3,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   3,
      3,   3,  83, 127,  35,   2,   3,   3,   2,   3,   3,   2,   3,   3,   3,   3,
      3,  25, 126, 127,  63,   3,   3,   3,   3,   3,  15,  77, 123, 116,  55,   9,
      3,   3,   3,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5
    }, {
      3,  86, 121,  71,  65,  65,  65,  65,  64,  64,  64,  33,   2,   3,  51, 121,
    125, 126, 127, 127, 127, 127, 127, 110,  12,   3,   3,   3,  22,  26,  27,  26,
     34,  43,  42,  23,   3,   3,   3,   3,   3,   3,  29, 114, 122,  51,   5,   3,
      3,   2,   2,   2,   2,  21, 113, 127, 113,  26,   3,   3,   3,   2,   3,   3,
      3,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   5,  61,
     81,  81, 112, 127,  94,  81,  81,  35,   3,   2,   3,   3,   2,   3,   3,   3,
     10,  89, 127, 127,  53,   3,   3,   3,   3,  16,  77,  98,  84,  23,   3,   3,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5
    }, {
      3,  82, 121, 121, 121, 121, 121, 121, 121, 121, 121,  61,   4,   3,  42,  89,
     84,  76,  71,  57,  52,  40,  31,  19,   4,   3,   2,   3,  98, 115, 115, 115,
    115, 114, 115,  82,   6,   3,   2,   3,   3,   3,   3,  25,  91, 122,  88,  46,
     28,  13,   2,   2,   2,  40, 126, 127,  73,  40,  40,  39,  40,  33,   3,   3,
      3,   3,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   7,  90,
    121, 121, 121, 121, 121, 121, 121,  53,   3,   3,   3,   5,  60,  82,  83,  83,
    107, 127, 127, 109,  18,   3,   3,   3,   3,   4,   7,   8,   5,   3,   3,   3,
      2,   2,   2,   3,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   5
    }, {
      2,  12,  17,  17,  16,  17,  17,  16,  16,  17,  16,   9,   2,   2,   4,   5,
      2,   3,   3,   2,   3,   3,   2,   2,   2,   2,   2,   2,  15,  17,  17,  16,
     17,  17,  17,  12,   3,   3,   3,   3,   2,   3,   2,   3,   7,  32,  63,  69,
     58,  20,   3,   3,   2,  26,  82,  83,  82,  81,  82,  82,  81,  67,   2,   3,
      3,   2,   2,   3,   2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   4,  13,
     16,  17,  17,  17,  17,  17,  17,   9,   3,   3,   2,   5,  62,  83,  83,  83,
     82,  83,  71,  22,   2,   2,   2,   2,   2,   3,   3,   3,   3,   2,   3,   3,
      3,   3,   3,   2,   3,   3,   2,   3,   3,   2,   3,   3,   2,   3,   2,   5
    }, {
      2,   2,   2,   3,   3,   3,  14,  28,  29,  10,   3,   2,   2,   2,   3,   3,
      3,   2,   2,   3,   3,   3,   3,   2,   2,   2,   3,   7,  27,  29,   6,   3,
      2,   4,  23,  28,  11,   3,   3,   3,  11,  29,  28,  28,  29,  28,  29,  28,
     29,  24,   4,   3,   3,   3,   3,   3,   3,   3,   3,   2,   2,   3,   3,   3,
      3,   3,   3,   3,   3,   2,   2,   2,   3,  23,  28,  26,   4,   3,   3,   3,
     17,  29,  13,   3,  10,  28,  20,   3,   2,   3,   3,   2,   4,  27,  27,   4,
      3,  19,  25,   5,   3,   2,   2,   2,   3,   3,   3,   3,   3,   3,  12,  28,
     17,   3,   3,   3,   3,   3,   3,   3,   5,  15,  16,   5,   3,   3,   3,   5
    }, {
      2,   2,   2,   3,   3,   3,  36, 121, 122,  51,   2,   2,   2,   2,   2,   2,
      3,   3,   3,   3,   4,   3,   2,   2,   2,   2,   3,  24, 114, 122,  18,   3,
      2,  15, 113, 115,  19,   3,   3,   3,  38, 122, 122, 122, 122, 122, 122, 122,
    122, 101,   9,   2,   8,  96, 103, 104, 103, 103, 104, 103, 103, 103,  59,   3,
      3,  15,  43,  42,  43,  43,  43,  43,  45, 103, 122, 113,   7,   3,   3,   2,
     73, 122,  55,   2,  38, 122,  85,   3,   2,   3,   3,   3,  10, 115, 114,   8,
      3,  76, 112,  15,   2,   2,   2,   2,  11,  49,  53,  53,  53,  53,  79, 121,
     84,  23,   3,   3,   3,   3,  14,  30,  44, 115, 115,  48,  30,  18,   3,   5
    }, {
      2,   2,   2,   2,   3,   3,  18, 116, 127,  84,   4,   2,   2,   2,   2,   3,
      3,  38, 104, 105,  78,   3,   2,   2,   2,   2,   2,  26, 121, 127,  18,   2,
      2,  52, 127,  92,   6,   3,   2,   3,  34, 127, 127,  77,  35,  35,  36,  35,
     35,  28,   4,   3,  10, 120, 127, 103,  80,  80,  80,  80,  80,  80,  47,   2,
      3,  37, 118, 117, 118, 118, 118, 117, 119, 126, 127, 118,   7,   2,   3,   3,
     79, 127,  59,   3,  41, 127,  89,   2,   3,   3,   3,   3,  48, 125, 124,  75,
     73, 107, 123,  60,   2,   2,   2,   2,  22, 119, 112,  93,  93,  93, 114, 127,
    104,  39,   3,   3,   3,   3,  53, 122, 124, 127, 127, 124, 122,  75,   2,   6
    }, {
      6,   5,   7,  10,  13,  12,   9, 192, 255, 221,  24,   6,   7,   6,   6,   6,
      6,  97, 255, 255, 198,   7,   6,   5,   5,   5,   6,  70, 249, 255,  38,   8,
     11, 182, 253, 103,   6,   7,   6,   6,  48, 255, 255, 120,  58, 146,  70,   6,
      6,   6,   6,   7,  17, 229, 255, 135,   6,   7,   7,   6,   6,   6,   7,   7,
      7,  12,  28,  28,  28,  29,  29,  28,  35, 200, 255, 237,  15,   5,   6,   6,
    174, 255,  99,   6,  83, 255, 177,   5,   6,   7,   7,  10, 104, 251, 250, 164,
    160, 219, 247, 130,   5,   5,   5,   5,  24, 223, 173,  17,  12,  16, 176, 252,
     62,   8,   7,   5,   8,   6,  56, 134, 155, 252, 253, 160, 134,  78,   6,   5
    }, {
      5,   6,  24, 197, 233, 207,  31, 128, 255, 255,  62,   6,   6,   6,   6,   5,
      6,  48, 130, 131,  97,   6,   5,   5,   5,   5,   5,  53, 242, 255,  39,   6,
     16, 145, 151,  26,   7,   6,   7,   6,  36, 237, 255, 237, 246, 251,  80,   6,
      6,   5,   6,   6,  15, 212, 255, 180,  11,   6,   6,   6,   7,   6,   7,   5,
      5,   5,   5,   5,   5,   5,   5,   5,  12, 194, 255, 236,  15,   6,   6,   5,
    172, 255,  86,   5,  56, 184, 126,   5,   5,   6,   6,   6,  22, 242, 240,  17,
      5, 115, 166,  24,   5,   5,   5,   5,   6, 135, 232,  48,   8,  11, 203, 247,
     29,   6,   7,   5,   5,   6,  30,  68,  74, 248, 248, 104,  50,   5,   6,   6
    }, {
      6,   6,  73, 253, 255, 172,   7,  71, 249, 255, 134,   6,   6,   6,   5,   5,
      5,   6,   6,   6,   5,   6,   5,   5,   5,   5,   6,  28, 231, 255,  54,   7,
      6,   6,   7,   6,   6,   7,   6,   9, 126, 248, 255, 241, 145,  57,  12,   7,
      6,   5,   7,   7,   9, 133, 254, 240,  49,   6,   6,  17,  71,  64,  16,   8,
      6,   5,   5,   5,   5,   5,   5,   5,  12, 195, 255, 237,  14,   6,   6,   6,
    144, 255, 103,   5,   8,  12,  12,   5,   6,   6,   6,   6,  17, 223, 240,  21,
      6,  11,  12,   5,   5,   5,   5,   5,   6,  16, 110, 161,  70,  12, 229, 227,
     20,   6,   6,   5,   5,   7, 122, 247, 133, 246, 249, 236, 180,   6,   7,   6
    }, {
      6,   6, 154, 255, 254,  90,   6,  22, 224, 255, 189,  14,   6,   6,   6,   6,
      7,  39, 100, 102,  75,   6,   5,   5,   5,   5,   6,   8, 191, 255, 117,   6,
      6,   6,   6,   6,   5,   6,   5,  15, 184, 213, 255, 227,  34,   6,   6,   7,
      6,   6,   6,   7,   6,  23, 195, 255, 198,  33,   6,  93, 248, 220,  26,   6,
      5,   5,   5,   5,   5,   5,   5,   5,  16, 219, 255, 237,  15,   5,   5,   6,
     81, 255, 156,   7,   6,   5,   6,   5,   5,   6,   6,   6,  11, 173, 249,  67,
      6,   6,   6,   7,   6,   5,   5,   5,   6,   6,   6,  14,  14,  30, 238, 199,
     15,   7,   6,   6,   6,   6, 156, 252, 115, 247, 248, 193, 199,  14,   5,   5
    }, {
      7,  26, 217, 255, 246, 110,  43,  17, 176, 255, 239,  31,   6,   5,   6,   5,
      6,  96, 254, 255, 195,   6,   5,   5,   5,   5,   6,   5,  84, 250, 210,  25,
      6,   5,   6,   6,   6,   5,   5,   7,  28,  31, 204, 255, 132,   7,   6,   6,
      6,   5,   5,   5,   5,   5,  33, 176, 252, 211,  79, 162, 255, 185,   6,   5,
      5,   6,   6,   5,   5,   5,   5,   6,  84, 250, 255, 237,  16,   5,   5,   5,
     25, 211, 225,  34,   6,   6,   6,   6,   6,   5,   5,   5,   5,  75, 250, 158,
      9,   6,   6,   5,   5,   5,   5,   5,   5,   6,   5,   5,   6,  57, 246, 173,
     11,   6,   6,   5,   6,  12, 179, 241,  91, 247, 248, 102, 227,  62,   6,   5
    }, {
      6,  77, 254, 255, 255, 253, 244, 224, 227, 255, 255,  83,   6,   6,   6,   5,
      6,  93, 247, 248, 191,   6,   5,   5,   5,   5,   6,   7,  10, 155, 253, 162,
     25,   7,   6,   5,   6,   6,   6,   5,   5,   5,  60, 227, 245, 113,  18,   7,
      6,   5,   5,   5,   5,   6,   5,  15,  79, 163, 214, 251, 255, 113,   6,   6,
      6,  11,  20,  20,  20,  21,  36, 100, 230, 255, 255, 197,  11,   5,   5,   5,
      5,  72, 236, 171,  24,   7,   6,   7,   5,   5,   5,   5,   6,  11, 147, 245,
    101,  10,   7,   7,   5,   5,   5,   5,   5,   6,   6,   6,   7,  86, 253, 144,
      6,   6,   5,   5,   5,  19, 203, 234,  81, 247, 249,  67, 101, 169,  21,   5
    }, {
      6, 153, 255, 253, 217, 234, 250, 255, 255, 255, 255, 147,   6,   6,   6,   6,
      5,  12,  26,  26,  20,   5,   5,   5,   5,   5,   6,   6,   6,  17, 120, 231,
    210, 123,  76,  54,   8,   7,   5,   5,   5,   5,   6,  51, 177, 242, 198, 126,
     83,  30,   5,   5,   5,   6,   6,   7,   6,   9,  60, 252, 242,  56,   6,   6,
      5,  79, 241, 240, 240, 241, 244, 251, 255, 254, 225,  62,   5,   5,   5,   5,
      5,   7,  62, 192, 188,  85,  30,   6,   6,   5,   5,   5,   5,   5,  17, 113,
    212, 142,  76,  24,   5,   5,   5,   5,  21,  95, 105, 106, 105, 168, 255, 180,
    104,  45,   7,   6,   7,  21, 206, 247, 226, 249, 249, 223, 218, 214,  35,   6
    }, {
      8,  85, 114, 104,  31,  25,  58, 105, 114, 114, 114,  70,   6,   5,   5,   5,
      6,   6,   6,   6,   6,   5,   5,   5,   5,   5,   6,   6,   6,   5,   8,  31,
    102, 137, 122,  59,   6,   5,   5,   5,   9,  11,  11,  11,  19,  49,  96, 118,
     97,  29,   6,   5,   5,   5,   7,   6,   6,   5,  29,  83,  77,  13,   6,   6,
      5,  38, 117, 120, 120, 119, 119, 120, 120, 105,  34,   6,   6,   5,   5,   5,
      5,   5,   6,  14,  61, 101,  58,   6,   6,   5,   5,   5,   5,   6,   6,   8,
     21,  68,  86,  21,   5,   5,   5,   5,  21,  99, 110, 110, 110, 112, 115, 112,
    109,  46,   6,   6,   6,   8,  40,  54,  56,  55,  54,  55,  56,  51,  12,   6
    }, {
      3,   3,  20,  57,  57,  57,  57,  57,  57,  37,   2,   3,   3,  14,  66,  69,
     69,  69,  69,  69,  69,  69,  69,  69,  38,   3,   2,   2,   2,   2,   3,   7,
      8,   3,   2,   2,   2,   2,   3,   6,  62,  84,  84,  84,  84,  84,  84,  84,
     84,  84,  23,   3,   3,  27,  53,  57,  57,  52,  52,  53,  53,  32,   3,   3,
      3,   3,  50,  83,  84,  84,  84,  84,  84,  81,  26,   3,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   3,   3,   4,  57,  69,  69,  69,  69,
     69,  68,  69,  69,  67,  19,   3,   3,   2,   2,   2,   2,   3,  10,   6,   3,
      2,   2,   2,   2,   3,  37,  69,  69,  26,   3,   3,   3,   3,   2,   3,   6
    }, {
      3,   3,  45, 127, 115,  96,  96, 105, 127,  83,   3,   3,   3,  24, 123, 127,
    118, 110, 110, 110, 110, 110, 117, 127,  72,   3,   3,   2,   2,   2,   3,  55,
     79,   5,   2,   2,   2,   2,   3,   7,  96, 127, 127, 123, 120, 120, 120, 120,
    120, 120,  32,   3,   3,  20,  56, 126, 113,  39,  37,  37,  37,  22,   3,   3,
      3,   3,  49,  81,  81,  81,  87, 125, 119,  81,  24,   3,   2,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   3,   3,   5,  90, 110, 110, 110, 110,
    110, 111, 110, 110, 107,  29,   3,   3,   3,   2,   2,   2,   4,  99,  46,   3,
      2,   2,   2,   2,   3,  65, 127, 127,  58,   3,   3,   4,   5,   3,   3,   6
    }, {
      2,   2,  46, 127,  74,   6,   6,  38, 125,  83,   3,   3,   3,  24, 123, 127,
     54,   7,   7,   7,   7,   7,  51, 127,  71,   2,   2,   2,   2,   2,   3,  58,
     89,   5,   2,   2,   2,   2,   3,   4,  90, 127, 125,  39,   9,   9,   9,   9,
      9,   9,   5,   3,   3,  16,  49, 126, 113,  31,  29,  29,  29,  18,   3,   3,
      3,   3,  36,  62,  62,  62,  70, 124, 102,   9,   3,   3,   3,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   4,  59,  65,  65,  65,  65,
     65,  65,  65,  65,  65,  43,   3,   3,   2,   2,   2,   2,   4, 104,  48,   3,
      2,   2,   2,   2,   3,  48, 127, 127,  73,  14,  42,  77,  34,   3,   3,   6
    }, {
      3,   3,  46, 127,  72,   2,   3,  35, 125,  83,   3,   3,   3,  24, 123, 127,
     52,   3,   2,   2,   2,   2,  43, 118,  66,   2,   2,   2,   2,   2,   2,  58,
     90,   5,   2,   2,   2,   2,   3,   2,  72, 127, 125,  32,   3,   2,   2,   2,
      2,   2,   3,   3,   3,  62, 125, 127, 127, 126, 124, 123, 123,  74,   3,   3,
      3,   3,  73, 125, 127, 125, 121, 124, 119,  16,   3,   3,   3,   2,   2,   2,
      2,   2,   2,   2,   2,   2,   2,   2,   3,   3,   7, 118, 127, 127, 125, 124,
    125, 125, 125, 124, 125,  88,   3,   3,   2,   2,   2,   2,   4, 105,  49,   3,
      2,   2,   2,   2,   3,  31, 127, 127, 120, 118, 126, 120,  39,   3,   3,   5
    }, {
      2,   2,  46, 127,  93,  48,  47,  68, 126,  83,   3,   3,   2,  24, 123, 127,
     52,   3,   3,   2,   2,   2,   4,   8,   5,   2,   2,   2,   2,   2,   4,  40,
     69,   5,   2,   2,   2,   2,   3,   3,  38, 127, 127,  43,   3,   3,   2,   2,
      2,   2,   2,   2,   2,  19,  54, 126, 127, 122,  49,  36,  36,  22,   3,   3,
      3,   3,  14,  75, 127,  87,  22,  42, 118,  70,  10,   4,   3,   3,   3,  18,
     32,  31,  31,  31,  31,  31,  27,   5,   2,   3,   7, 111, 127, 119,  41,  37,
     36,  36,  36,  36,  36,  26,   3,   3,   2,   2,   2,   2,   3, 105,  48,   2,
      2,   2,   2,   2,  22, 105, 127, 127, 126, 101,  57,  19,   4,   2,   2,   5
    }, {
      2,   2,  46, 127, 113,  91,  91, 102, 127,  83,   3,   3,   3,  18, 121, 127,
     62,   3,   3,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,  28,
     34,   3,   2,   2,   2,   2,   3,   3,  13, 107, 127,  74,   4,   3,   2,   2,
      2,   2,   2,   2,   2,   3,  28, 125, 127, 124,  35,   3,   3,   4,   3,   3,
      3,   3,   3,  53, 127,  86,   4,   3,  30,  86,  81,  16,   3,   3,   3,  56,
    107, 107, 100,  80, 100, 107,  90,  11,   3,   3,   4,  84, 127, 124,  31,   3,
      2,   2,   2,   2,   2,   3,   4,   3,   2,   2,   2,   2,   3, 105,  48,   2,
      2,   2,   2,   2,  34, 123, 117, 127, 119,  24,   3,   2,   2,   2,   2,   5
    }, {
      2,   2,  45, 127,  74,   4,   5,  37, 126,  83,   3,   3,   2,   6,  94, 127,
    107,  12,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,  57,
     88,   5,   2,   2,   2,   2,   2,   3,   3,  64, 127, 116,  23,   3,   2,   2,
      2,   2,   2,   2,   2,   2,  27, 125, 127, 127,  64,   3,   3,   3,   3,   2,
      3,   3,   3,  16, 114, 112,  13,   3,   3,   4,   6,   3,   3,   3,   3,   5,
      6,   6,   2,   0,   2,   6,   5,   3,   3,   2,   3,  38, 124, 127,  89,   8,
      3,   2,   2,   2,   2,   3,   3,   3,   2,   2,   2,   2,   3, 105,  48,   2,
      2,   2,   2,   2,  14,  31,  21, 115, 127,  76,   4,   2,   2,   2,   2,   5
    }, {
      2,   2,  46, 127,  74,   3,   3,  35, 125,  83,   2,   3,   3,   2,  30, 115,
    127,  76,   8,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,  58,
     89,   5,   2,   2,   2,   2,   3,   3,   9,  92, 127, 127,  94,  16,   2,   2,
      2,   2,   2,   2,   2,   2,  27, 125, 119, 114, 111,  15,   3,   3,   3,   3,
      2,   3,   3,   4,  57, 126,  65,   5,   3,   3,   2,   3,   3,   3,   2,   2,
      3,   2,   0,   0,   0,   3,   3,   3,   2,   3,   3,   5,  73, 126, 126,  70,
      8,   2,   2,   2,   2,   2,   3,   2,   2,   2,   2,   2,   3, 105,  48,   2,
      2,   2,   2,   2,   3,   3,   3,  52, 124, 122,  52,   5,   2,   2,   2,   5
    }, {
      6,   6,  91, 255, 191, 104, 106, 146, 253, 166,   6,   5,   5,   5,   6,  53,
    201, 250, 172,  48,  21,  14,  15,   9,   6,   6,   5,   5,   5,   5,   6, 115,
    178,  11,   5,   5,   5,   5,   5,  10, 118, 255, 234, 175, 246, 212,  89,  29,
     21,  27,   9,   6,   6,   6,  56, 251, 215,  66, 225, 178,  33,   6,   5,   5,
      5,   6,   5,   6,  10, 138, 242, 126,  24,  13,   7,   6,   6,   5,   5,   5,
      5,   7,   7,   4,   5,   5,   5,   5,   5,   6,   7,   6,  14, 116, 235, 254,
    189,  67,  22,  15,  16,  14,   6,   5,   7,   6,   7,   6,   7, 164,  76,   6,
      6,   6,   6,   6,   5,   5,   5,   9, 118, 244, 248, 151,  51,  24,  23,  11
    }, {
      6,   6,  60, 174, 174, 174, 173, 173, 174, 113,   6,   5,   5,   5,   5,   6,
     20, 100, 188, 224, 187, 169, 143,  29,   7,   6,   5,   5,   5,   5,   7,  44,
     79,   8,   5,   5,   5,   5,   5,  41, 220, 235, 117,   9,  70, 165, 226, 208,
    194, 179,  25,   6,   6,   6,  51, 232, 196,  10,  41, 157, 193,  41,   5,   5,
      5,   6,   6,   6,   6,   7,  79, 172, 182, 150,  16,   5,   7,   5,   5,   5,
      5,   7,   5,   6,   5,   5,   5,   5,   5,   6,   5,   6,   6,   7,  38, 118,
    194, 230, 195, 169, 166,  92,   6,   6,   6,   6,   6,   6,   5,   7,   6,   6,
      7,   6,   5,   6,   5,   5,   5,   5,   8,  64, 164, 226, 233, 200, 169,  48
    }, {
      5,   6,   7,  11,  15,  11,   9,  15,   9,   6,   5,   5,   5,   5,   6,   6,
      6,   6,   5,  12,  31,  27,   6,   6,   5,   6,   6,   5,   5,   5,   6,   7,
      6,   7,   5,   5,   5,   5,   7,  16,  31,  29,  10,   7,   6,   7,  21,  40,
     34,  16,   8,   6,  10,  14,  20,  40,  34,  16,  15,  15,  26,  13,   5,   5,
      5,   7,  15,  15,  15,  16,  15,  14,  21,  16,   6,   6,   6,   5,   5,   5,
      5,   6,  12,  14,  10,   5,   5,   5,   5,   6,   6,  11,  14,  14,  15,  15,
     15,  25,  41,  41,  25,   6,   7,   6,   6,  12,  15,  10,   6,  15,  11,  13,
     14,   6,   6,   6,   5,   5,   5,   5,   6,  10,  24,  25,  29,  25,   8,   5
    }, {
      6,   6,   6, 120, 192, 118,  64, 192,  63,   6,   5,   5,   5,   5,   5,   5,
      6,   6,   6,   6,   6,   6,   5,   6,   6,   6,   5,   5,   5,   5,   6,   6,
      6,   6,   5,   5,   5,   5,   6,   7,   6,   6,   5,   6,   5,  34, 176, 192,
    191, 192,  52,   6,  93, 193, 192, 192, 192, 191, 191, 191, 191,  68,   5,   5,
      5,  50, 187, 192, 192, 191, 192, 193, 193, 182,  19,   6,   6,   6,  19,  24,
     25,  25, 146, 192, 129,  24,  24,  24,  19,   6,   5,  77, 163, 163, 161, 163,
    162, 164, 184, 192, 163,  18,   7,   5,   6, 119, 192,  83,  36, 181, 108, 153,
    154,  14,   6,   5,   5,  15,  24,  24,  26,  70, 216, 168,  21,   9,   6,   5
    }, {
      5,   5,   5, 180, 255, 134,  78, 254,  86,   6,   5,   5,   5,   5,   6,   6,
      6,   6,  34,  61,   6,   6,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   6,  17,  15,   6,   5,   5,   5,  43, 234, 252,
    253, 252,  67,   6, 126, 255, 214, 166, 167, 166, 166, 166, 166,  58,   5,   5,
      5,  70, 252, 255, 219, 167, 167, 166, 212, 249,  56,   6,   6,  11, 153, 218,
    218, 218, 247, 255, 244, 218, 219, 218, 162,  13,   7,  26,  35,  36,  37,  37,
     36,  43, 199, 255, 170,   8,   6,   6,   6, 184, 255, 114,  98, 254, 109, 238,
    159,   9,   6,   6,   6, 116, 219, 218, 219, 229, 255, 248, 192,  27,   6,   6
    }, {
      5,   5,  14, 200, 255, 103,  64, 249,  85,   5,   6,   5,   5,   5,   6,   6,
     89,  71, 116, 208,  44, 114,  20,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   7,  90,  83,   6,   5,   5,   5,  16,  69,  76,
     76,  76,  22,   5, 124, 255, 134,   6,  13,  40,  37,   7,   6,   5,   5,   5,
      5,  64, 249, 255, 144,   5,   8,   7,  52, 233, 139,   8,   7,   7, 138, 255,
    255, 201, 162, 162, 163, 162, 162, 162, 120,  11,   7, 145, 245, 245, 244, 244,
    244, 243, 253, 255, 224,  25,   6,   6,   6, 174, 255, 110, 164, 243, 120, 252,
     99,   6,   7,   6,   6, 139, 250, 154, 129, 175, 255, 226, 112,  19,   7,   5
    }, {
      5,   5,  24, 215, 255,  79,  37, 234,  90,   6,   6,   5,   5,   5,   6,   6,
    104, 236, 237, 247, 234, 172,  18,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   6,  70, 144,   6,   5,   5,   5,  32, 164, 177,
    177, 176,  50,   6, 115, 255, 140,   8,  59, 243, 218,   8,   6,   5,   5,   5,
      5,  47, 240, 255, 153,  46,  87, 143, 159,  86, 207,  49,   7,   6,  51, 244,
    255, 180,  15,   6,   6,   5,   5,   5,   5,   6,   6, 131, 254, 144,  97,  97,
     97, 102, 214, 255, 183,  13,   6,   6,   6, 153, 255,  91, 202, 175, 140, 222,
     33,   5,   6,   6,   6, 140, 242,  54,   6,  98, 255, 193,   5,   5,   5,   6
    }, {
      5,   5,  36, 233, 251,  62,  11, 208, 136,   7,   6,   5,   5,   5,   5,   6,
     76, 219, 247, 253, 240, 134,  12,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   7,  32, 218,  47,   5,   5,   5,  42, 232, 250,
    250, 249,  67,   5, 101, 255, 183,  12,  64, 255, 228,   7,   7,   5,   5,   5,
      5,  16, 219, 255, 245, 249, 255, 238, 185,  17,  37,  35,   7,   5,   9, 128,
    255, 253, 146,  17,   5,   5,   5,   5,   5,   6,   6,  71, 249, 124,   8,   6,
      7,  14, 190, 255, 159,   6,   6,   6,   5, 123, 255, 111,  25,  19,  21,  25,
      8,   5,   6,   6,   6, 141, 242,  53,   6,  73, 255, 195,   8,   6,   7,   5
    }, {
      2,   2,  25, 124, 120,  23,   3,  73,  93,   6,   3,   2,   2,   2,   3,   3,
     55,  63,  65, 107,  44,  81,  11,   2,   2,   2,   2,   2,   3,   4,   2,   2,
      2,   2,   3,   3,   2,   2,   3,   5,  85,  99,  20,   2,   3,   7,  32,  35,
     35,  34,  10,   3,  28, 122, 121,  29,  32, 127, 117,  14,   3,   2,   2,   2,
      2,   3,  75, 127, 126,  93,  52,  22,   3,   2,   2,   2,   2,   3,  29,  99,
    127, 127, 126,  90,  28,   6,   3,   3,   3,   3,   3,   5,  77, 112,  29,   4,
      3,   7,  96, 127,  80,   2,   2,   3,   3,  35, 125,  76,   3,   2,   3,   3,
      2,   2,   2,   2,   2,  70, 121,  26,   3,  22, 120, 107,  11,   3,   2,   5
    }, {
      3,   3,  29, 127, 113,  16,   2,  30, 116,  25,   3,   2,   2,   2,   3,   3,
      2,   3,  36,  71,   3,   3,   2,   2,   2,   2,   2,   3,  40,  65,  65,  65,
     65,  65,  65,  47,   4,   3,   3,   2,  32, 121, 110,  56,  22,  11,  10,  10,
     10,  10,   4,   3,   5,  74, 125, 112,  82, 127, 125,  44,   3,   2,   2,   2,
      2,   3,  25, 119, 125,  39,   4,   3,   2,   2,   2,   2,   2,   7,  92, 127,
    122,  77, 106, 127, 120,  92,  62,  38,   9,   3,   3,   3,   8,  57,  83,  37,
      3,  12, 109, 127,  79,   3,   3,   3,   3,  10, 106, 111,  15,   4,   3,   3,
      2,   2,   2,   2,   3,  71, 121,  27,   3,   6,  91, 124,  32,   3,   3,   6
    }, {
      3,   3,  42, 127, 107,  10,   3,   3,  63,  83,  10,   2,   2,   2,   2,   3,
      3,   4,   3,   3,   3,   3,   2,   2,   2,   2,   2,   3,  46,  76,  76,  76,
     76,  76,  75,  54,   4,   2,   3,   3,   4,  58, 123, 127, 119, 106, 104, 104,
    104, 104,  28,   3,   3,   7,  39,  58,  60,  99, 127, 101,  14,   2,   2,   2,
      2,   2,   2,  60, 125, 112,  28,   3,   3,   2,   2,   2,   2,   7,  93, 103,
     36,   3,  94, 127,  93,  36,  55,  58,  14,   3,   3,   3,   3,   3,   3,   3,
      4,  56, 127, 127,  76,   3,   2,   3,   2,   3,  48, 124,  81,  10,   3,   2,
      2,   2,   2,   2,   3,  70, 126,  78,  48,  14,  28, 115,  93,  10,   3,   5
    }, {
      2,   2,  56, 127,  99,   4,   3,   2,   6,  34,  11,   2,   2,   3,   3,   3,
      2,   3,   2,   3,   3,   3,   2,   2,   2,   2,   3,   3,   2,   3,   2,   2,
      2,   2,   3,   3,   3,   3,   3,   3,   2,   4,  45, 103, 125, 127, 127, 127,
    127, 127,  34,   3,   3,   3,   3,   3,   2,  22, 104, 127, 101,  39,  12,   2,
      2,   2,   3,   5,  55, 117, 115,  58,  22,  11,   6,   2,   2,   6,  46,  28,
     18,  19,  99, 127,  90,  19,  18,  18,  15,   4,   3,  33,  69,  69,  69,  69,
     87, 123, 127, 122,  37,   3,   3,   3,   3,   2,   5,  64, 121,  92,  34,  10,
     10,   4,   2,   3,   3,  47, 120, 124, 120,  31,   3,  35, 108,  89,  21,   7
    }, {
      3,   3,  58, 108,  75,   2,   3,   3,   3,   3,   2,   3,   2,   3,   3,   3,
      3,   3,   3,   3,   3,   3,   2,   3,   3,   3,   3,   3,   3,   3,   2,   2,
      2,   2,   3,   3,   3,   3,   2,   2,   2,   2,   2,   9,  36,  63,  81,  88,
     89,  88,  24,   3,   3,   3,   2,   2,   2,   3,  15,  57,  91,  98,  56,   3,
      2,   2,   2,   2,   2,  22,  66,  97,  91,  74,  26,   3,   2,   5,  70,  97,
     96,  97, 106, 108, 105,  97,  97,  97,  70,   6,   3,  48, 100, 100, 100, 100,
    100, 100,  95,  46,   3,   2,   2,   2,   2,   2,   2,   4,  30,  72,  91,  79,
     68,  11,   3,   3,   3,   5,  24,  30,  28,  10,   3,   3,  16,  61,  57,  10
    }, {
      2,   3,   7,  11,   8,  21,  38,  19,   3,   2,   3,   2,   3,   4,  18,  29,
     28,  29,  29,  29,  29,  29,  29,  27,   8,   3,  14,  38,  38,  38,  37,  37,
     37,  37,  38,  38,  37,  11,   2,   2,   2,   2,   3,   3,   3,   2,   3,   2,
      3,   2,   2,   3,   3,   3,   2,   2,   2,   3,   3,   3,   3,   3,   3,   3,
      3,   3,   2,   2,   2,   3,   3,   2,   2,   2,   3,   3,   3,   3,   9,  11,
     11,  11,  12,  12,  11,  11,  11,  11,   8,   3,   2,   3,   3,   2,   2,   2,
      2,   3,   3,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   3,   3,   2,
      2,   3,   3,   3,   3,   3,   3,   3,   2,   3,   3,   3,   3,   3,   3,   5
    }, {
      3,   3,   3,   3,   3,  84, 127,  59,   3,   3,   3,   3,   3,   3,  29,  46,
     45,  47, 102, 120,  62,  46,  45,  43,  11,   3,  41, 123, 123, 123, 123, 123,
    123, 123, 123, 123, 119,  31,   2,   2,   2,   2,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   3,   2,   2,   2,   2,   3,   3,   3,   3,   3,   3,   3,
      3,   2,   2,   2,   2,   3,   3,   2,   3,   2,   3,   3,   3,   3,   3,   3,
      3,   3,   3,   3,   2,   2,   2,   2,   2,   2,   3,   3,   3,   2,   2,   2,
      3,   3,   3,   3,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   2,   2,
      3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   5
    }, {
      2,  12,  89, 103, 102, 121, 127, 112, 103, 102,  64,   3,   3,   4,  74, 118,
    118, 119, 125, 127, 120, 118, 118, 113,  26,   2,  16,  45,  45,  45,  45,  46,
     45,  46,  46,  46,  43,  13,   2,   2,   2,  13,  58,  59,  59,  59,  58,  54,
     10,   2,   2,   3,   3,   2,   2,   2,   2,  35,  38,   3,   2,   3,   2,   2,
      3,   2,   2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   2,   3,   3,   3,
      3,   3,   3,   3,   3,   2,   2,   2,   2,   3,   3,   2,   2,   2,   2,   2,
      2,   3,   3,   3,   3,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   3,
      3,   3,   3,   2,   3,   2,   2,   3,   3,   3,   3,   3,   2,   3,   3,   5
    }, {
      5,  20, 140, 164, 175, 246, 253, 183, 165, 165, 103,   5,   5,   9, 166, 255,
    156,  65,  65,  65,  64,  74, 217, 249,  60,   5,  80, 238, 238, 239, 237, 240,
    238, 238, 238, 238, 230,  60,   5,   5,   5,  29, 132, 132, 132, 132, 133, 122,
     20,   5,   5,   5,   5,   5,   6,   6,   5, 159, 173,   6,   7,   6,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5
    }, {
      5,   6,   5,   7,  39, 234, 236,  41,   6,   7,   7,   5,   6,   9, 163, 255,
    124,   6,   6,   6,   7,  17, 177, 217,  52,   6,  23,  62, 116, 252, 255, 120,
     62,  61,  63,  62,  60,  18,   5,   5,   5,   5,   5,   5,   5,   5,   6,   6,
      5,   6,   5,   5,   5,   5,   6,  68, 123, 204, 213, 123,  76,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5
    }, {
      5,   6,   6,   6,  59, 250, 213,  25,   6,   6,   6,   5,   5,   9, 164, 255,
    130,   6,   6,   7,   7,   8,  27,  30,  11,   6,   6,   6,  25, 229, 255, 137,
      7,   6,   6,   6,   6,   5,   5,   5,   5,   5,   5,   5,   5,   5,   6,   5,
      6,   6,   5,   5,   5,   5,   5, 126, 225, 244, 248, 225, 140,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5
    }, {
      6,  14,  81,  96, 141, 255, 216,  99,  97,  97,  61,   5,   5,   8, 148, 255,
    181,  10,   6,   6,   6,   5,   6,   6,   7,   6,   6,   6,   6, 143, 254, 216,
     25,   6,   6,   6,   7,   6,   5,   6,   5,   5,   5,   5,   5,   6,   6,   6,
      6,   5,   5,   5,   5,   5,   5,  19,  30, 168, 183,  31,  21,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5
    }, {
      6,  25, 191, 220, 242, 255, 243, 222, 220, 221, 139,   5,   5,   5,  64, 246,
    244,  63,   7,   7,   6,   7,   6,   6,   8,   6,   6,   7,   6,  26, 211, 255,
    145,  13,   6,   6,   5,   6,   5,   6,   6, 154, 221, 221, 221, 221, 221, 221,
    124,   7,   5,   5,   5,   5,   5,   5,   5, 122, 129,   6,   6,   6,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5
    }, {
      5,   9,  23,  27, 165, 255, 140,  26,  26,  26,  18,   5,   5,   5,   8, 111,
    245, 219,  57,   6,   6,   6,   5,   7,   7,   6,   6,   6,   6,   6,  52, 211,
    250, 140,  18,   6,   6,   6,   6,   6,   5,  35,  48,  49,  49,  49,  51,  50,
     28,   6,   5,   5,   5,   5,   5,   5,   5,  12,  11,   6,   6,   6,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5
    }, {
      6,   6,   6,   6, 186, 255,  95,   5,   5,   5,   5,   5,   5,   5,   5,   8,
     73, 197, 236, 155,  88,  82,  44,   7,   6,   6,   7,   7,   6,   7,   6,  31,
    136, 225, 207, 141, 104,   8,   6,   6,   5,   5,   5,   5,   5,   5,   6,   5,
      5,   6,   5,   5,   5,   5,   5,   5,   5,   5,   6,   6,   7,   6,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5
    }, {
      5,   6,   5,   8,  84, 107,  28,   5,   5,   5,   5,   5,   5,   5,   5,   6,
      5,  17,  52,  99, 103,  90,  35,   6,   5,   5,   6,   5,   6,   6,   6,   5,
      6,  28,  62, 101,  58,   7,   5,   5,   5,   5,   5,   5,   5,   5,   6,   6,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   6,   6,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
      5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5
    }
};

#endif /* MPLAYER_MATRIXVIEW_FONT_H */
