/*---------------------------------------------------------------------------*
 *  passert.h  *
 *                                                                           *
 *  Copyright 2007, 2008 Nuance Communciations, Inc.                               *
 *                                                                           *
 *  Licensed under the Apache License, Version 2.0 (the 'License');          *
 *  you may not use this file except in compliance with the License.         *
 *                                                                           *
 *  You may obtain a copy of the License at                                  *
 *      http://www.apache.org/licenses/LICENSE-2.0                           *
 *                                                                           *
 *  Unless required by applicable law or agreed to in writing, software      *
 *  distributed under the License is distributed on an 'AS IS' BASIS,        *
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. * 
 *  See the License for the specific language governing permissions and      *
 *  limitations under the License.                                           *
 *                                                                           *
 *---------------------------------------------------------------------------*/

#ifndef PASSERT_H
#define PASSERT_H



/**
 * @addtogroup ESR_PortableModule ESR_Portable API functions
 *
 * @{
 */

#if defined(_WIN32) || defined(POSIX)
/**
 * Checks if platform supports ASSERT.
 */
#define HAS_ASSERT
#endif

#if defined(HAS_ASSERT)

#include <assert.h>

/**
 * Portable assert().
 */
#define passert(exp) assert(exp)

#elif defined(NDEBUG)

#define passert(exp)

#else

/**
* Portable assert().
*/
#define passert(exp) do { \
    if (!(exp)) \
    { \
      pfprintf(PSTDERR, __FILE__ "(%d): " #exp " failed.\n",__LINE__); \
      abort(); \
    } \
  } \
  while(0)

#endif  /* HAS_ASSERT */

/**
 * @}
 */

#endif 
