enum OperandTypes {
  kOperandTypeNone,
  kOperandTypeImmediate,
  kOperandTypeRegister,
  kOperandTypeX86Memory,
  kOperandTypeX86EffectiveAddress,
  kOperandTypeX86PCRelative,
  kOperandTypeARMBranchTarget,
  kOperandTypeARMSoRegReg,
  kOperandTypeARMSoRegImm,
  kOperandTypeARMSoImm,
  kOperandTypeARMRotImm,
  kOperandTypeARMSoImm2Part,
  kOperandTypeARMPredicate,
  kOperandTypeAddrModeImm12,
  kOperandTypeLdStSOReg,
  kOperandTypeARMAddrMode2,
  kOperandTypeARMAddrMode2Offset,
  kOperandTypeARMAddrMode3,
  kOperandTypeARMAddrMode3Offset,
  kOperandTypeARMLdStmMode,
  kOperandTypeARMAddrMode5,
  kOperandTypeARMAddrMode6,
  kOperandTypeARMAddrMode6Offset,
  kOperandTypeARMAddrMode7,
  kOperandTypeARMAddrModePC,
  kOperandTypeARMRegisterList,
  kOperandTypeARMDPRRegisterList,
  kOperandTypeARMSPRRegisterList,
  kOperandTypeARMTBAddrMode,
  kOperandTypeThumbITMask,
  kOperandTypeThumbAddrModeImmS1,
  kOperandTypeThumbAddrModeImmS2,
  kOperandTypeThumbAddrModeImmS4,
  kOperandTypeThumbAddrModeRegS1,
  kOperandTypeThumbAddrModeRegS2,
  kOperandTypeThumbAddrModeRegS4,
  kOperandTypeThumbAddrModeRR,
  kOperandTypeThumbAddrModeSP,
  kOperandTypeThumbAddrModePC,
  kOperandTypeThumb2AddrModeReg,
  kOperandTypeThumb2SoReg,
  kOperandTypeThumb2SoImm,
  kOperandTypeThumb2AddrModeImm8,
  kOperandTypeThumb2AddrModeImm8Offset,
  kOperandTypeThumb2AddrModeImm12,
  kOperandTypeThumb2AddrModeSoReg,
  kOperandTypeThumb2AddrModeImm8s4,
  kOperandTypeThumb2AddrModeImm8s4Offset
};

enum OperandFlags {
  kOperandFlagSource = 0x1,
  kOperandFlagTarget = 0x2
};

enum InstructionTypes {
  kInstructionTypeNone,
  kInstructionTypeMove,
  kInstructionTypeBranch,
  kInstructionTypePush,
  kInstructionTypePop,
  kInstructionTypeCall,
  kInstructionTypeReturn
};

namespace {
llvm::EDInstInfo instInfoX86[] = {
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeImmediate,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeImmediate,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    5,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    5,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    5,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    5,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    5,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    5,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    5,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeCall,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeCall,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeCall,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeCall,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeCall,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeCall,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeCall,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        3,
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        3,
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        3,
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        3,
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        3,
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        3,
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        3,
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        3,
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeReturn,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeReturn,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeImmediate,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeCall,
    2,
    {
      kOperandTypeImmediate,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeCall,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeCall,
    2,
    {
      kOperandTypeImmediate,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeCall,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeCall,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    2,
    {
      kOperandTypeImmediate,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    2,
    {
      kOperandTypeImmediate,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeReturn,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeReturn,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeReturn,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeReturn,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        3,
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        3,
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        3,
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        3,
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        3,
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        3,
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        3,
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        3,
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeBranch,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86EffectiveAddress,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeReturn,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeReturn,
    1,
    {
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeReturn,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeReturn,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        2,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    4,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        3,
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        3,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        2,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        2,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    3,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    0,
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeX86PCRelative,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeX86Memory,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeImmediate,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeX86Memory,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    0,
    1,
    {
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      kOperandFlagTarget,
      kOperandFlagSource,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    },
    {
      {
        1,
        0,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      },
      {
        0,
        1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1
      }
    }
  },
  {
    kInstructionTypeMove,
    2,
    {
      kOperandTypeRegister,
      kOperandTypeRegister,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
   