; This file checks support for comparing vector values with the icmp
; instruction.

; RUN: %p2i -i %s --filetype=obj --disassemble --args -O2 | FileCheck %s
; RUN: %p2i -i %s --filetype=obj --disassemble --args -Om1 | FileCheck %s

; RUN: %if --need=target_MIPS32 --need=allow_dump \
; RUN:   --command %p2i --filetype=asm --assemble --disassemble --target mips32\
; RUN:   -i %s --args -O2 \
; RUN:   | %if --need=target_MIPS32 --need=allow_dump \
; RUN:   --command FileCheck --check-prefix MIPS32 %s

; Check that sext elimination occurs when the result of the comparison
; instruction is already sign extended.  Sign extension to 4 x i32 uses
; the pslld instruction on x86.
define internal <4 x i32> @test_sext_elimination(<4 x i32> %a, <4 x i32> %b) {
entry:
  %res.trunc = icmp eq <4 x i32> %a, %b
  %res = sext <4 x i1> %res.trunc to <4 x i32>
  ret <4 x i32> %res
; CHECK-LABEL: test_sext_elimination
; CHECK: pcmpeqd
; CHECK-NOT: pslld

; MIPS32-LABEL: test_sext_elimination
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: xor [[T4:.*]],a0,[[T0]]
; MIPS32: sltiu [[T4]],[[T4]],1
; MIPS32: xor [[T5:.*]],a1,[[T1]]
; MIPS32: sltiu [[T5]],[[T5]],1
; MIPS32: xor [[T6:.*]],a2,[[T2]]
; MIPS32: sltiu [[T6]],[[T6]],1
; MIPS32: xor [[T7:.*]],a3,[[T3]]
; MIPS32: sltiu [[T7]],[[T7]],1
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sra [[T4]],[[T4]],0x1f
; MIPS32: andi [[T5]],[[T5]],0x1
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: sra [[T5]],[[T5]],0x1f
; MIPS32: andi [[T6]],[[T6]],0x1
; MIPS32: sll [[T6]],[[T6]],0x1f
; MIPS32: sra [[T6]],[[T6]],0x1f
; MIPS32: andi [[T7]],[[T7]],0x1
; MIPS32: sll [[T7]],[[T7]],0x1f
; MIPS32: sra [[T7]],[[T7]],0x1f
; MIPS32: move v0,[[T4]]
; MIPS32: move v1,[[T5]]
; MIPS32: move a0,[[T6]]
; MIPS32: move a1,[[T7]]
}

define internal <4 x i1> @test_icmp_v4i32_eq(<4 x i32> %a, <4 x i32> %b) {
entry:
  %res = icmp eq <4 x i32> %a, %b
  ret <4 x i1> %res
; CHECK-LABEL: test_icmp_v4i32_eq
; CHECK: pcmpeqd

; MIPS32-LABEL: test_icmp_v4i32_eq
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: xor [[T4:.*]],a0,[[T0]]
; MIPS32: sltiu [[T4]],[[T4]],1
; MIPS32: xor [[T5:.*]],a1,[[T1]]
; MIPS32: sltiu [[T5]],[[T5]],1
; MIPS32: xor [[T6:.*]],a2,[[T2]]
; MIPS32: sltiu [[T6]],[[T6]],1
; MIPS32: xor [[T7:.*]],a3,[[T3]]
; MIPS32: sltiu [[T7]],[[T7]],1
; MIPS32: move v0,[[T4]]
; MIPS32: move v1,[[T5]]
; MIPS32: move a0,[[T6]]
; MIPS32: move a1,[[T7]]
}

define internal <4 x i1> @test_icmp_v4i32_ne(<4 x i32> %a, <4 x i32> %b) {
entry:
  %res = icmp ne <4 x i32> %a, %b
  ret <4 x i1> %res
; CHECK-LABEL: test_icmp_v4i32_ne
; CHECK: pcmpeqd
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v4i32_ne
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: xor [[T4:.*]],a0,[[T0]]
; MIPS32: sltu [[T4]],zero,[[T4]]
; MIPS32: xor [[T5:.*]],a1,[[T1]]
; MIPS32: sltu [[T5]],zero,[[T5]]
; MIPS32: xor [[T6:.*]],a2,[[T2]]
; MIPS32: sltu [[T6]],zero,[[T6]]
; MIPS32: xor [[T7:.*]],a3,[[T3]]
; MIPS32: sltu [[T7]],zero,[[T7]]
; MIPS32: move v0,[[T4]]
; MIPS32: move v1,[[T5]]
; MIPS32: move a0,[[T6]]
; MIPS32: move a1,[[T7]]
}

define internal <4 x i1> @test_icmp_v4i32_sgt(<4 x i32> %a, <4 x i32> %b) {
entry:
  %res = icmp sgt <4 x i32> %a, %b
  ret <4 x i1> %res
; CHECK: pcmpgtd

; MIPS32-LABEL: test_icmp_v4i32_sgt
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: slt v0,[[T0]],[[T4:.*]]
; MIPS32: slt v1,[[T1]],[[T5:.*]]
; MIPS32: slt [[T2]],[[T2]],[[T6:.*]]
; MIPS32: slt [[T3]],[[T3]],[[T7:.*]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <4 x i1> @test_icmp_v4i32_sle(<4 x i32> %a, <4 x i32> %b) {
entry:
  %res = icmp sle <4 x i32> %a, %b
  ret <4 x i1> %res
; CHECK-LABEL: test_icmp_v4i32_sle
; CHECK: pcmpgtd
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v4i32_sle
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: slt [[T0]],[[T0]],[[T4:.*]]
; MIPS32: xori v0,[[T0]],0x1
; MIPS32: slt [[T1]],[[T1]],[[T5:.*]]
; MIPS32: xori v1,[[T1]],0x1
; MIPS32: slt [[T2]],[[T2]],[[T6:.*]]
; MIPS32: xori [[T2]],[[T2]],0x1
; MIPS32: slt [[T3]],[[T3]],[[T7:.*]]
; MIPS32: xori [[T3]],[[T3]],0x1
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <4 x i1> @test_icmp_v4i32_slt(<4 x i32> %a, <4 x i32> %b) {
entry:
  %res = icmp slt <4 x i32> %a, %b
  ret <4 x i1> %res
; CHECK-LABEL: test_icmp_v4i32_slt
; CHECK: pcmpgtd

; MIPS32-LABEL: test_icmp_v4i32_slt
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: slt [[T4:.*]],a0,[[T0]]
; MIPS32: slt [[T5:.*]],a1,[[T1]]
; MIPS32: slt [[T6:.*]],a2,[[T2]]
; MIPS32: slt [[T7:.*]],a3,[[T3]]
; MIPS32: move v0,[[T4]]
; MIPS32: move v1,[[T5]]
; MIPS32: move a0,[[T6]]
; MIPS32: move a1,[[T7]]
}

define internal <4 x i1> @test_icmp_v4i32_uge(<4 x i32> %a, <4 x i32> %b) {
entry:
  %res = icmp uge <4 x i32> %a, %b
  ret <4 x i1> %res
; CHECK-LABEL: test_icmp_v4i32_uge
; CHECK: pxor
; CHECK: pcmpgtd
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v4i32_uge
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: sltu [[T4:.*]],a0,[[T0]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: sltu [[T5:.*]],a1,[[T1]]
; MIPS32: xori [[T5]],[[T5]],0x1
; MIPS32: sltu [[T6:.*]],a2,[[T2]]
; MIPS32: xori [[T6]],[[T6]],0x1
; MIPS32: sltu [[T7:.*]],a3,[[T3]]
; MIPS32: xori [[T7]],[[T7]],0x1
; MIPS32: move v0,[[T4]]
; MIPS32: move v1,[[T5]]
; MIPS32: move a0,[[T6]]
; MIPS32: move a1,[[T7]]
}

define internal <4 x i1> @test_icmp_v4i32_ugt(<4 x i32> %a, <4 x i32> %b) {
entry:
  %res = icmp ugt <4 x i32> %a, %b
  ret <4 x i1> %res
; CHECK-LABEL: test_icmp_v4i32_ugt
; CHECK: pxor
; CHECK: pcmpgtd

; MIPS32-LABEL: test_icmp_v4i32_ugt
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: sltu v0,[[T0]],[[T4:.*]]
; MIPS32: sltu v1,[[T1]],[[T5:.*]]
; MIPS32: sltu [[T2]],[[T2]],[[T6:.*]]
; MIPS32: sltu [[T3]],[[T3]],[[T7:.*]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <4 x i1> @test_icmp_v4i32_ule(<4 x i32> %a, <4 x i32> %b) {
entry:
  %res = icmp ule <4 x i32> %a, %b
  ret <4 x i1> %res
; CHECK-LABEL: test_icmp_v4i32_ule
; CHECK: pxor
; CHECK: pcmpgtd
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v4i32_ule
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: sltu [[T0]],[[T0]],[[T4:.*]]
; MIPS32: xori v0,[[T0]],0x1
; MIPS32: sltu [[T1]],[[T1]],[[T5:.*]]
; MIPS32: xori v1,[[T1]],0x1
; MIPS32: sltu [[T2]],[[T2]],[[T6:.*]]
; MIPS32: xori [[T2]],[[T2]],0x1
; MIPS32: sltu [[T3]],[[T3]],[[T7:.*]]
; MIPS32: xori [[T3]],[[T3]],0x1
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <4 x i1> @test_icmp_v4i32_ult(<4 x i32> %a, <4 x i32> %b) {
entry:
  %res = icmp ult <4 x i32> %a, %b
  ret <4 x i1> %res
; CHECK-LABEL: test_icmp_v4i32_ult
; CHECK: pxor
; CHECK: pcmpgtd

; MIPS32-LABEL: test_icmp_v4i32_ult
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: sltu [[T4:.*]],a0,[[T0]]
; MIPS32: sltu [[T5:.*]],a1,[[T1]]
; MIPS32: sltu [[T6:.*]],a2,[[T2]]
; MIPS32: sltu [[T7:.*]],a3,[[T3]]
; MIPS32: move v0,[[T4]]
; MIPS32: move v1,[[T5]]
; MIPS32: move a0,[[T6]]
; MIPS32: move a1,[[T7]]
}

define internal <4 x i1> @test_icmp_v4i1_eq(<4 x i1> %a, <4 x i1> %b) {
entry:
  %res = icmp eq <4 x i1> %a, %b
  ret <4 x i1> %res
; CHECK-LABEL: test_icmp_v4i1_eq
; CHECK: pcmpeqd

; MIPS32-LABEL: test_icmp_v4i1_eq
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: andi [[T4:.*]],a0,0x1
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: xor [[T4]],[[T4]],[[T0]]
; MIPS32: sltiu [[T4]],[[T4]],1
; MIPS32: andi [[T5:.*]],a1,0x1
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: xor [[T5]],[[T5]],[[T1]]
; MIPS32: sltiu [[T5]],[[T5]],1
; MIPS32: andi [[T6:.*]],a2,0x1
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T6]],[[T6]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: xor [[T6]],[[T6]],[[T2]]
; MIPS32: sltiu [[T6]],[[T6]],1
; MIPS32: andi [[T7:.*]],a3,0x1
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T7]],[[T7]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: xor [[T7]],[[T7]],[[T3]]
; MIPS32: sltiu [[T7]],[[T7]],1
; MIPS32: move v0,[[T4]]
; MIPS32: move v1,[[T5]]
; MIPS32: move a0,[[T6]]
; MIPS32: move a1,[[T7]]
}

define internal <4 x i1> @test_icmp_v4i1_ne(<4 x i1> %a, <4 x i1> %b) {
entry:
  %res = icmp ne <4 x i1> %a, %b
  ret <4 x i1> %res
; CHECK-LABEL: test_icmp_v4i1_ne
; CHECK: pcmpeqd
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v4i1_ne
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: andi [[T4:.*]],a0,0x1
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: xor [[T4]],[[T4]],[[T0]]
; MIPS32: sltu [[T4]],zero,[[T4]]
; MIPS32: andi [[T5:.*]],a1,0x1
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: xor [[T5]],[[T5]],[[T1]]
; MIPS32: sltu [[T5]],zero,[[T5]]
; MIPS32: andi [[T6:.*]],a2,0x1
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T6]],[[T6]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: xor [[T6]],[[T6]],[[T2]]
; MIPS32: sltu [[T6]],zero,[[T6]]
; MIPS32: andi [[T7:.*]],a3,0x1
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T7]],[[T7]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: xor [[T7]],[[T7]],[[T3]]
; MIPS32: sltu [[T7]],zero,[[T7]]
; MIPS32: move v0,[[T4]]
; MIPS32: move v1,[[T5]]
; MIPS32: move a0,[[T6]]
; MIPS32: move a1,[[T7]]
}

define internal <4 x i1> @test_icmp_v4i1_sgt(<4 x i1> %a, <4 x i1> %b) {
entry:
  %res = icmp sgt <4 x i1> %a, %b
  ret <4 x i1> %res
; CHECK-LABEL: test_icmp_v4i1_sgt
; CHECK: pcmpgtd

; MIPS32-LABEL: test_icmp_v4i1_sgt
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: andi [[T4:.*]],a0,0x1
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: slt v0,[[T0]],[[T4]]
; MIPS32: andi [[T5:.*]],a1,0x1
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: slt v1,[[T1]],[[T5]]
; MIPS32: andi [[T6:.*]],a2,0x1
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T6]],[[T6]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: slt [[T2]],[[T2]],[[T6]]
; MIPS32: andi [[T7:.*]],a3,0x1
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T7]],[[T7]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: slt [[T3]],[[T3]],[[T7]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <4 x i1> @test_icmp_v4i1_sle(<4 x i1> %a, <4 x i1> %b) {
entry:
  %res = icmp sle <4 x i1> %a, %b
  ret <4 x i1> %res
; CHECK-LABEL: test_icmp_v4i1_sle
; CHECK: pcmpgtd
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v4i1_sle
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: andi [[T4:.*]],a0,0x1
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: slt [[T0]],[[T0]],[[T4]]
; MIPS32: xori v0,[[T0]],0x1
; MIPS32: andi [[T5:.*]],a1,0x1
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: slt [[T1]],[[T1]],[[T5]]
; MIPS32: xori v1,[[T1]],0x1
; MIPS32: andi [[T6:.*]],a2,0x1
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T6]],[[T6]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: slt [[T2]],[[T2]],[[T6]]
; MIPS32: xori [[T2]],[[T2]],0x1
; MIPS32: andi [[T7:.*]],a3,0x1
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T7]],[[T7]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: slt [[T3]],[[T3]],[[T7]]
; MIPS32: xori [[T3]],[[T3]],0x1
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <4 x i1> @test_icmp_v4i1_slt(<4 x i1> %a, <4 x i1> %b) {
entry:
  %res = icmp slt <4 x i1> %a, %b
  ret <4 x i1> %res
; CHECK-LABEL: test_icmp_v4i1_slt
; CHECK: pcmpgtd

; MIPS32-LABEL: test_icmp_v4i1_slt
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: andi [[T4:.*]],a0,0x1
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: slt [[T4]],[[T4]],[[T0]]
; MIPS32: andi [[T5:.*]],a1,0x1
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: slt [[T5]],[[T5]],[[T1]]
; MIPS32: andi [[T6:.*]],a2,0x1
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T6]],[[T6]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: slt [[T6]],[[T6]],[[T2]]
; MIPS32: andi [[T7:.*]],a3,0x1
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T7]],[[T7]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: slt [[T7]],[[T7]],[[T3]]
; MIPS32: move v0,[[T4]]
; MIPS32: move v1,[[T5]]
; MIPS32: move a0,[[T6]]
; MIPS32: move a1,[[T7]]
}

define internal <4 x i1> @test_icmp_v4i1_uge(<4 x i1> %a, <4 x i1> %b) {
entry:
  %res = icmp uge <4 x i1> %a, %b
  ret <4 x i1> %res
; CHECK-LABEL: test_icmp_v4i1_uge
; CHECK: pxor
; CHECK: pcmpgtd
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v4i1_uge
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: andi [[T4:.*]],a0,0x1
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sltu [[T4]],[[T4]],[[T0]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T5:.*]],a1,0x1
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T5]],[[T5]],[[T1]]
; MIPS32: xori [[T5]],[[T5]],0x1
; MIPS32: andi [[T6:.*]],a2,0x1
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T6]],[[T6]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: sltu [[T6]],[[T6]],[[T2]]
; MIPS32: xori [[T6]],[[T6]],0x1
; MIPS32: andi [[T7:.*]],a3,0x1
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T7]],[[T7]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: sltu [[T7]],[[T7]],[[T3]]
; MIPS32: xori [[T7]],[[T7]],0x1
; MIPS32: move v0,[[T4]]
; MIPS32: move v1,[[T5]]
; MIPS32: move a0,[[T6]]
; MIPS32: move a1,[[T7]]
}

define internal <4 x i1> @test_icmp_v4i1_ugt(<4 x i1> %a, <4 x i1> %b) {
entry:
  %res = icmp ugt <4 x i1> %a, %b
  ret <4 x i1> %res
; CHECK-LABEL: test_icmp_v4i1_ugt
; CHECK: pxor
; CHECK: pcmpgtd

; MIPS32-LABEL: test_icmp_v4i1_ugt
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: andi [[T4:.*]],a0,0x1
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sltu v0,[[T0]],[[T4]]
; MIPS32: andi [[T5:.*]],a1,0x1
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu v1,[[T1]],[[T5]]
; MIPS32: andi [[T6:.*]],a2,0x1
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T6]],[[T6]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: sltu [[T2]],[[T2]],[[T6]]
; MIPS32: andi [[T7:.*]],a3,0x1
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T7]],[[T7]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: sltu [[T3]],[[T3]],[[T7]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <4 x i1> @test_icmp_v4i1_ule(<4 x i1> %a, <4 x i1> %b) {
entry:
  %res = icmp ule <4 x i1> %a, %b
  ret <4 x i1> %res
; CHECK-LABEL: test_icmp_v4i1_ule
; CHECK: pxor
; CHECK: pcmpgtd
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v4i1_ule
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: andi [[T4:.*]],a0,0x1
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T4]]
; MIPS32: xori v0,[[T0]],0x1
; MIPS32: andi [[T5:.*]],a1,0x1
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T1]],[[T1]],[[T5]]
; MIPS32: xori v1,[[T1]],0x1
; MIPS32: andi [[T6:.*]],a2,0x1
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T6]],[[T6]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: sltu [[T2]],[[T2]],[[T6]]
; MIPS32: xori [[T2]],[[T2]],0x1
; MIPS32: andi [[T7:.*]],a3,0x1
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T7]],[[T7]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: sltu [[T3]],[[T3]],[[T7]]
; MIPS32: xori [[T3]],[[T3]],0x1
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <4 x i1> @test_icmp_v4i1_ult(<4 x i1> %a, <4 x i1> %b) {
entry:
  %res = icmp ult <4 x i1> %a, %b
  ret <4 x i1> %res
; CHECK-LABEL: test_icmp_v4i1_ult
; CHECK: pxor
; CHECK: pcmpgtd

; MIPS32-LABEL: test_icmp_v4i1_ult
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: andi [[T4:.*]],a0,0x1
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sltu [[T4]],[[T4]],[[T0]]
; MIPS32: andi [[T5:.*]],a1,0x1
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T5]],[[T5]],[[T1]]
; MIPS32: andi [[T6:.*]],a2,0x1
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T6]],[[T6]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: sltu [[T6]],[[T6]],[[T2]]
; MIPS32: andi [[T7:.*]],a3,0x1
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T7]],[[T7]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: sltu [[T7]],[[T7]],[[T3]]
; MIPS32: move v0,[[T4]]
; MIPS32: move v1,[[T5]]
; MIPS32: move a0,[[T6]]
; MIPS32: move a1,[[T7]]
}

define internal <8 x i1> @test_icmp_v8i16_eq(<8 x i16> %a, <8 x i16> %b) {
entry:
  %res = icmp eq <8 x i16> %a, %b
  ret <8 x i1> %res
; CHECK-LABEL: test_icmp_v8i16_eq
; CHECK: pcmpeqw

; MIPS32-LABEL: test_icmp_v8i16_eq
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: xor [[T8]],[[T8]],[[T9]]
; MIPS32: sltiu [[T8]],[[T8]],1
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: xor [[T10]],[[T10]],[[T0]]
; MIPS32: sltiu [[T10]],[[T10]],1
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: xor [[T0]],[[T0]],[[T4]]
; MIPS32: sltiu [[T0]],[[T0]],1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: sll [[T5]],[[T5]],0x10
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x10
; MIPS32: srl [[T1]],[[T1]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: xor [[T11]],[[T11]],[[T1]]
; MIPS32: sltiu [[T11]],[[T11]],1
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: xor [[T0]],[[T0]],[[T1]]
; MIPS32: sltiu [[T0]],[[T0]],1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T6]],[[T6]],0x10
; MIPS32: sll [[T6]],[[T6]],0x10
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: srl [[T12:.*]],a2,0x10
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T2]],[[T2]],0x10
; MIPS32: xor [[T12]],[[T12]],[[T2]]
; MIPS32: sltiu [[T12]],[[T12]],1
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: xor [[T0]],[[T0]],[[T1]]
; MIPS32: sltiu [[T0]],[[T0]],1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T7]],[[T7]],0x10
; MIPS32: sll [[T7]],[[T7]],0x10
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: srl [[T13:.*]],a3,0x10
; MIPS32: srl [[T3]],[[T3]],0x10
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T3]],[[T3]],0x10
; MIPS32: xor [[T13]],[[T13]],[[T3]]
; MIPS32: sltiu [[T13]],[[T13]],1
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <8 x i1> @test_icmp_v8i16_ne(<8 x i16> %a, <8 x i16> %b) {
entry:
  %res = icmp ne <8 x i16> %a, %b
  ret <8 x i1> %res
; CHECK-LABEL: test_icmp_v8i16_ne
; CHECK: pcmpeqw
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v8i16_ne
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: xor [[T8]],[[T8]],[[T9]]
; MIPS32: sltu [[T8]],zero,[[T8]]
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: xor [[T10]],[[T10]],[[T0]]
; MIPS32: sltu [[T10]],zero,[[T10]]
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: xor [[T0]],[[T0]],[[T4]]
; MIPS32: sltu [[T0]],zero,[[T0]]
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: sll [[T5]],[[T5]],0x10
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x10
; MIPS32: srl [[T1]],[[T1]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: xor [[T11]],[[T11]],[[T1]]
; MIPS32: sltu [[T11]],zero,[[T11]]
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: xor [[T0]],[[T0]],[[T1]]
; MIPS32: sltu [[T0]],zero,[[T0]]
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T6]],[[T6]],0x10
; MIPS32: sll [[T6]],[[T6]],0x10
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: srl [[T12:.*]],a2,0x10
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T2]],[[T2]],0x10
; MIPS32: xor [[T12]],[[T12]],[[T2]]
; MIPS32: sltu [[T12]],zero,[[T12]]
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: xor [[T0]],[[T0]],[[T1]]
; MIPS32: sltu [[T0]],zero,[[T0]]
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T7]],[[T7]],0x10
; MIPS32: sll [[T7]],[[T7]],0x10
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: srl [[T13:.*]],a3,0x10
; MIPS32: srl [[T3]],[[T3]],0x10
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T3]],[[T3]],0x10
; MIPS32: xor [[T13]],[[T13]],[[T3]]
; MIPS32: sltu [[T13]],zero,[[T13]]
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <8 x i1> @test_icmp_v8i16_sgt(<8 x i16> %a, <8 x i16> %b) {
entry:
  %res = icmp sgt <8 x i16> %a, %b
  ret <8 x i1> %res
; CHECK-LABEL: test_icmp_v8i16_sgt
; CHECK: pcmpgtw

; MIPS32-LABEL: test_icmp_v8i16_sgt
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: slt [[T9]],[[T9]],[[T8]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: or [[T9]],[[T9]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: slt [[T0]],[[T0]],[[T10]]
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: or v0,[[T0]],[[T9]]
; MIPS32: move [[T10]],a1
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: slt [[T4]],[[T4]],[[T10]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: sll [[T5]],[[T5]],0x10
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x10
; MIPS32: srl [[T1]],[[T1]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: slt [[T1]],[[T1]],[[T11]]
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: or v1,[[T1]],[[T4]]
; MIPS32: move [[T10]],a2
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: move [[T11]],[[T2]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: srl [[T6]],[[T6]],0x10
; MIPS32: sll [[T6]],[[T6]],0x10
; MIPS32: or [[T11]],[[T11]],[[T6]]
; MIPS32: srl [[T12:.*]],a2,0x10
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T2]],[[T2]],0x10
; MIPS32: slt [[T2]],[[T2]],[[T12]]
; MIPS32: sll [[T2]],[[T2]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: or [[T2]],[[T2]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: move [[T11]],[[T3]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: srl [[T7]],[[T7]],0x10
; MIPS32: sll [[T7]],[[T7]],0x10
; MIPS32: or [[T11]],[[T11]],[[T7]]
; MIPS32: srl [[T13:.*]],a3,0x10
; MIPS32: srl [[T3]],[[T3]],0x10
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T3]],[[T3]],0x10
; MIPS32: slt [[T3]],[[T3]],[[T13]]
; MIPS32: sll [[T3]],[[T3]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: or [[T3]],[[T3]],[[T11]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <8 x i1> @test_icmp_v8i16_sle(<8 x i16> %a, <8 x i16> %b) {
entry:
  %res = icmp sle <8 x i16> %a, %b
  ret <8 x i1> %res
; CHECK-LABEL: test_icmp_v8i16_sle
; CHECK: pcmpgtw
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v8i16_sle
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: slt [[T9]],[[T9]],[[T8]]
; MIPS32: xori [[T9]],[[T9]],0x1
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: or [[T9]],[[T9]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: slt [[T0]],[[T0]],[[T10]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: or v0,[[T0]],[[T9]]
; MIPS32: move [[T10]],a1
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: slt [[T4]],[[T4]],[[T10]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: sll [[T5]],[[T5]],0x10
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x10
; MIPS32: srl [[T1]],[[T1]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: slt [[T1]],[[T1]],[[T11]]
; MIPS32: xori [[T1]],[[T1]],0x1
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: or v1,[[T1]],[[T4]]
; MIPS32: move [[T10]],a2
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: move [[T11]],[[T2]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: srl [[T6]],[[T6]],0x10
; MIPS32: sll [[T6]],[[T6]],0x10
; MIPS32: or [[T11]],[[T11]],[[T6]]
; MIPS32: srl [[T12:.*]],a2,0x10
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T2]],[[T2]],0x10
; MIPS32: slt [[T2]],[[T2]],[[T12]]
; MIPS32: xori [[T2]],[[T2]],0x1
; MIPS32: sll [[T2]],[[T2]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: or [[T2]],[[T2]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: move [[T11]],[[T3]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: srl [[T7]],[[T7]],0x10
; MIPS32: sll [[T7]],[[T7]],0x10
; MIPS32: or [[T11]],[[T11]],[[T7]]
; MIPS32: srl [[T13:.*]],a3,0x10
; MIPS32: srl [[T3]],[[T3]],0x10
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T3]],[[T3]],0x10
; MIPS32: slt [[T3]],[[T3]],[[T13]]
; MIPS32: xori [[T3]],[[T3]],0x1
; MIPS32: sll [[T3]],[[T3]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: or [[T3]],[[T3]],[[T11]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <8 x i1> @test_icmp_v8i16_slt(<8 x i16> %a, <8 x i16> %b) {
entry:
  %res = icmp slt <8 x i16> %a, %b
  ret <8 x i1> %res
; CHECK-LABEL: test_icmp_v8i16_slt
; CHECK: pcmpgtw

; MIPS32-LABEL: test_icmp_v8i16_slt
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: slt [[T8]],[[T8]],[[T9]]
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: slt [[T10]],[[T10]],[[T0]]
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: slt [[T0]],[[T0]],[[T4]]
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: sll [[T5]],[[T5]],0x10
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x10
; MIPS32: srl [[T1]],[[T1]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: slt [[T11]],[[T11]],[[T1]]
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: slt [[T0]],[[T0]],[[T1]]
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T6]],[[T6]],0x10
; MIPS32: sll [[T6]],[[T6]],0x10
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: srl [[T12:.*]],a2,0x10
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T2]],[[T2]],0x10
; MIPS32: slt [[T12]],[[T12]],[[T2]]
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: slt [[T0]],[[T0]],[[T1]]
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T7]],[[T7]],0x10
; MIPS32: sll [[T7]],[[T7]],0x10
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: srl [[T13:.*]],a3,0x10
; MIPS32: srl [[T3]],[[T3]],0x10
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T3]],[[T3]],0x10
; MIPS32: slt [[T13]],[[T13]],[[T3]]
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <8 x i1> @test_icmp_v8i16_uge(<8 x i16> %a, <8 x i16> %b) {
entry:
  %res = icmp uge <8 x i16> %a, %b
  ret <8 x i1> %res
; CHECK-LABEL: test_icmp_v8i16_uge
; CHECK: pxor
; CHECK: pcmpgtw
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v8i16_uge
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: sltu [[T8]],[[T8]],[[T9]]
; MIPS32: xori [[T8]],[[T8]],0x1
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sltu [[T10]],[[T10]],[[T0]]
; MIPS32: xori [[T10]],[[T10]],0x1
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: sltu [[T0]],[[T0]],[[T4]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: sll [[T5]],[[T5]],0x10
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x10
; MIPS32: srl [[T1]],[[T1]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: sltu [[T11]],[[T11]],[[T1]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: sltu [[T0]],[[T0]],[[T1]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T6]],[[T6]],0x10
; MIPS32: sll [[T6]],[[T6]],0x10
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: srl [[T12:.*]],a2,0x10
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T2]],[[T2]],0x10
; MIPS32: sltu [[T12]],[[T12]],[[T2]]
; MIPS32: xori [[T12]],[[T12]],0x1
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: sltu [[T0]],[[T0]],[[T1]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T7]],[[T7]],0x10
; MIPS32: sll [[T7]],[[T7]],0x10
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: srl [[T13:.*]],a3,0x10
; MIPS32: srl [[T3]],[[T3]],0x10
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T3]],[[T3]],0x10
; MIPS32: sltu [[T13]],[[T13]],[[T3]]
; MIPS32: xori [[T13]],[[T13]],0x1
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <8 x i1> @test_icmp_v8i16_ugt(<8 x i16> %a, <8 x i16> %b) {
entry:
  %res = icmp ugt <8 x i16> %a, %b
  ret <8 x i1> %res
; CHECK-LABEL: test_icmp_v8i16_ugt
; CHECK: pxor
; CHECK: pcmpgtw

; MIPS32-LABEL: test_icmp_v8i16_ugt
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: sltu [[T9]],[[T9]],[[T8]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: or [[T9]],[[T9]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sltu [[T0]],[[T0]],[[T10]]
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: or v0,[[T0]],[[T9]]
; MIPS32: move [[T10]],a1
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: sltu [[T4]],[[T4]],[[T10]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: sll [[T5]],[[T5]],0x10
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x10
; MIPS32: srl [[T1]],[[T1]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: sltu [[T1]],[[T1]],[[T11]]
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: or v1,[[T1]],[[T4]]
; MIPS32: move [[T10]],a2
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: move [[T11]],[[T2]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: srl [[T6]],[[T6]],0x10
; MIPS32: sll [[T6]],[[T6]],0x10
; MIPS32: or [[T11]],[[T11]],[[T6]]
; MIPS32: srl [[T12:.*]],a2,0x10
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T2]],[[T2]],0x10
; MIPS32: sltu [[T2]],[[T2]],[[T12]]
; MIPS32: sll [[T2]],[[T2]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: or [[T2]],[[T2]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: move [[T11]],[[T3]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: srl [[T7]],[[T7]],0x10
; MIPS32: sll [[T7]],[[T7]],0x10
; MIPS32: or [[T11]],[[T11]],[[T7]]
; MIPS32: srl [[T13:.*]],a3,0x10
; MIPS32: srl [[T3]],[[T3]],0x10
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T3]],[[T3]],0x10
; MIPS32: sltu [[T3]],[[T3]],[[T13]]
; MIPS32: sll [[T3]],[[T3]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: or [[T3]],[[T3]],[[T11]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <8 x i1> @test_icmp_v8i16_ule(<8 x i16> %a, <8 x i16> %b) {
entry:
  %res = icmp ule <8 x i16> %a, %b
  ret <8 x i1> %res
; CHECK-LABEL: test_icmp_v8i16_ule
; CHECK: pxor
; CHECK: pcmpgtw
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v8i16_ule
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: sltu [[T9]],[[T9]],[[T8]]
; MIPS32: xori [[T9]],[[T9]],0x1
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: or [[T9]],[[T9]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sltu [[T0]],[[T0]],[[T10]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: or v0,[[T0]],[[T9]]
; MIPS32: move [[T10]],a1
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: sltu [[T4]],[[T4]],[[T10]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: sll [[T5]],[[T5]],0x10
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x10
; MIPS32: srl [[T1]],[[T1]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: sltu [[T1]],[[T1]],[[T11]]
; MIPS32: xori [[T1]],[[T1]],0x1
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: or v1,[[T1]],[[T4]]
; MIPS32: move [[T10]],a2
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: move [[T11]],[[T2]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: srl [[T6]],[[T6]],0x10
; MIPS32: sll [[T6]],[[T6]],0x10
; MIPS32: or [[T11]],[[T11]],[[T6]]
; MIPS32: srl [[T12:.*]],a2,0x10
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T2]],[[T2]],0x10
; MIPS32: sltu [[T2]],[[T2]],[[T12]]
; MIPS32: xori [[T2]],[[T2]],0x1
; MIPS32: sll [[T2]],[[T2]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: or [[T2]],[[T2]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: move [[T11]],[[T3]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: srl [[T7]],[[T7]],0x10
; MIPS32: sll [[T7]],[[T7]],0x10
; MIPS32: or [[T11]],[[T11]],[[T7]]
; MIPS32: srl [[T13:.*]],a3,0x10
; MIPS32: srl [[T3]],[[T3]],0x10
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T3]],[[T3]],0x10
; MIPS32: sltu [[T3]],[[T3]],[[T13]]
; MIPS32: xori [[T3]],[[T3]],0x1
; MIPS32: sll [[T3]],[[T3]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: or [[T3]],[[T3]],[[T11]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <8 x i1> @test_icmp_v8i16_ult(<8 x i16> %a, <8 x i16> %b) {
entry:
  %res = icmp ult <8 x i16> %a, %b
  ret <8 x i1> %res
; CHECK-LABEL: test_icmp_v8i16_ult
; CHECK: pxor
; CHECK: pcmpgtw

; MIPS32-LABEL: test_icmp_v8i16_ult
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: sltu [[T8]],[[T8]],[[T9]]
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sltu [[T10]],[[T10]],[[T0]]
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: sltu [[T0]],[[T0]],[[T4]]
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: sll [[T5]],[[T5]],0x10
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x10
; MIPS32: srl [[T1]],[[T1]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: sltu [[T11]],[[T11]],[[T1]]
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: sltu [[T0]],[[T0]],[[T1]]
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T6]],[[T6]],0x10
; MIPS32: sll [[T6]],[[T6]],0x10
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: srl [[T12:.*]],a2,0x10
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T2]],[[T2]],0x10
; MIPS32: sltu [[T12]],[[T12]],[[T2]]
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: sltu [[T0]],[[T0]],[[T1]]
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T7]],[[T7]],0x10
; MIPS32: sll [[T7]],[[T7]],0x10
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: srl [[T13:.*]],a3,0x10
; MIPS32: srl [[T3]],[[T3]],0x10
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T3]],[[T3]],0x10
; MIPS32: sltu [[T13]],[[T13]],[[T3]]
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <8 x i1> @test_icmp_v8i1_eq(<8 x i1> %a, <8 x i1> %b) {
entry:
  %res = icmp eq <8 x i1> %a, %b
  ret <8 x i1> %res
; CHECK-LABEL: test_icmp_v8i1_eq
; CHECK: pcmpeqw

; MIPS32-LABEL: test_icmp_v8i1_eq
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: xor [[T8]],[[T8]],[[T9]]
; MIPS32: sltiu [[T8]],[[T8]],1
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x10
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: xor [[T10]],[[T10]],[[T0]]
; MIPS32: sltiu [[T10]],[[T10]],1
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: xor [[T0]],[[T0]],[[T4]]
; MIPS32: sltiu [[T0]],[[T0]],1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: sll [[T5]],[[T5]],0x10
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x10
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: srl [[T1]],[[T1]],0x10
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: xor [[T11]],[[T11]],[[T1]]
; MIPS32: sltiu [[T11]],[[T11]],1
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: xor [[T0]],[[T0]],[[T1]]
; MIPS32: sltiu [[T0]],[[T0]],1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T6]],[[T6]],0x10
; MIPS32: sll [[T6]],[[T6]],0x10
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: srl [[T12:.*]],a2,0x10
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: xor [[T12]],[[T12]],[[T2]]
; MIPS32: sltiu [[T12]],[[T12]],1
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: xor [[T0]],[[T0]],[[T1]]
; MIPS32: sltiu [[T0]],[[T0]],1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T7]],[[T7]],0x10
; MIPS32: sll [[T7]],[[T7]],0x10
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: srl [[T13:.*]],a3,0x10
; MIPS32: andi [[T13]],[[T13]],0x1
; MIPS32: srl [[T3]],[[T3]],0x10
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T13]],[[T13]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: xor [[T13]],[[T13]],[[T3]]
; MIPS32: sltiu [[T13]],[[T13]],1
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <8 x i1> @test_icmp_v8i1_ne(<8 x i1> %a, <8 x i1> %b) {
entry:
  %res = icmp ne <8 x i1> %a, %b
  ret <8 x i1> %res
; CHECK-LABEL: test_icmp_v8i1_ne
; CHECK: pcmpeqw
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v8i1_ne
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: xor [[T8]],[[T8]],[[T9]]
; MIPS32: sltu [[T8]],zero,[[T8]]
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x10
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: xor [[T10]],[[T10]],[[T0]]
; MIPS32: sltu [[T10]],zero,[[T10]]
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: xor [[T0]],[[T0]],[[T4]]
; MIPS32: sltu [[T0]],zero,[[T0]]
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: sll [[T5]],[[T5]],0x10
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x10
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: srl [[T1]],[[T1]],0x10
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: xor [[T11]],[[T11]],[[T1]]
; MIPS32: sltu [[T11]],zero,[[T11]]
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: xor [[T0]],[[T0]],[[T1]]
; MIPS32: sltu [[T0]],zero,[[T0]]
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T6]],[[T6]],0x10
; MIPS32: sll [[T6]],[[T6]],0x10
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: srl [[T12:.*]],a2,0x10
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: xor [[T12]],[[T12]],[[T2]]
; MIPS32: sltu [[T12]],zero,[[T12]]
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: xor [[T0]],[[T0]],[[T1]]
; MIPS32: sltu [[T0]],zero,[[T0]]
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T7]],[[T7]],0x10
; MIPS32: sll [[T7]],[[T7]],0x10
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: srl [[T13:.*]],a3,0x10
; MIPS32: andi [[T13]],[[T13]],0x1
; MIPS32: srl [[T3]],[[T3]],0x10
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T13]],[[T13]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: xor [[T13]],[[T13]],[[T3]]
; MIPS32: sltu [[T13]],zero,[[T13]]
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <8 x i1> @test_icmp_v8i1_sgt(<8 x i1> %a, <8 x i1> %b) {
entry:
  %res = icmp sgt <8 x i1> %a, %b
  ret <8 x i1> %res
; CHECK-LABEL: test_icmp_v8i1_sgt
; CHECK: pcmpgtw

; MIPS32-LABEL: test_icmp_v8i1_sgt
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: slt [[T9]],[[T9]],[[T8]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: or [[T9]],[[T9]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x10
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: slt [[T0]],[[T0]],[[T10]]
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: or v0,[[T0]],[[T9]]
; MIPS32: move [[T10]],a1
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: slt [[T4]],[[T4]],[[T10]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: sll [[T5]],[[T5]],0x10
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x10
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: srl [[T1]],[[T1]],0x10
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: slt [[T1]],[[T1]],[[T11]]
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: or v1,[[T1]],[[T4]]
; MIPS32: move [[T10]],a2
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T2]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: srl [[T6]],[[T6]],0x10
; MIPS32: sll [[T6]],[[T6]],0x10
; MIPS32: or [[T11]],[[T11]],[[T6]]
; MIPS32: srl [[T12:.*]],a2,0x10
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: slt [[T2]],[[T2]],[[T12]]
; MIPS32: sll [[T2]],[[T2]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: or [[T2]],[[T2]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T3]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: srl [[T7]],[[T7]],0x10
; MIPS32: sll [[T7]],[[T7]],0x10
; MIPS32: or [[T11]],[[T11]],[[T7]]
; MIPS32: srl [[T13:.*]],a3,0x10
; MIPS32: andi [[T13]],[[T13]],0x1
; MIPS32: srl [[T3]],[[T3]],0x10
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T13]],[[T13]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: slt [[T3]],[[T3]],[[T13]]
; MIPS32: sll [[T3]],[[T3]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: or [[T3]],[[T3]],[[T11]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <8 x i1> @test_icmp_v8i1_sle(<8 x i1> %a, <8 x i1> %b) {
entry:
  %res = icmp sle <8 x i1> %a, %b
  ret <8 x i1> %res
; CHECK-LABEL: test_icmp_v8i1_sle
; CHECK: pcmpgtw
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v8i1_sle
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: slt [[T9]],[[T9]],[[T8]]
; MIPS32: xori [[T9]],[[T9]],0x1
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: or [[T9]],[[T9]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x10
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: slt [[T0]],[[T0]],[[T10]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: or v0,[[T0]],[[T9]]
; MIPS32: move [[T10]],a1
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: slt [[T4]],[[T4]],[[T10]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: sll [[T5]],[[T5]],0x10
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x10
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: srl [[T1]],[[T1]],0x10
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: slt [[T1]],[[T1]],[[T11]]
; MIPS32: xori [[T1]],[[T1]],0x1
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: or v1,[[T1]],[[T4]]
; MIPS32: move [[T10]],a2
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T2]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: srl [[T6]],[[T6]],0x10
; MIPS32: sll [[T6]],[[T6]],0x10
; MIPS32: or [[T11]],[[T11]],[[T6]]
; MIPS32: srl [[T12:.*]],a2,0x10
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: slt [[T2]],[[T2]],[[T12]]
; MIPS32: xori [[T2]],[[T2]],0x1
; MIPS32: sll [[T2]],[[T2]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: or [[T2]],[[T2]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T3]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: srl [[T7]],[[T7]],0x10
; MIPS32: sll [[T7]],[[T7]],0x10
; MIPS32: or [[T11]],[[T11]],[[T7]]
; MIPS32: srl [[T13:.*]],a3,0x10
; MIPS32: andi [[T13]],[[T13]],0x1
; MIPS32: srl [[T3]],[[T3]],0x10
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T13]],[[T13]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: slt [[T3]],[[T3]],[[T13]]
; MIPS32: xori [[T3]],[[T3]],0x1
; MIPS32: sll [[T3]],[[T3]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: or [[T3]],[[T3]],[[T11]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <8 x i1> @test_icmp_v8i1_slt(<8 x i1> %a, <8 x i1> %b) {
entry:
  %res = icmp slt <8 x i1> %a, %b
  ret <8 x i1> %res
; CHECK-LABEL: test_icmp_v8i1_slt
; CHECK: pcmpgtw

; MIPS32-LABEL: test_icmp_v8i1_slt
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: slt [[T8]],[[T8]],[[T9]]
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x10
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: slt [[T10]],[[T10]],[[T0]]
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: slt [[T0]],[[T0]],[[T4]]
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: sll [[T5]],[[T5]],0x10
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x10
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: srl [[T1]],[[T1]],0x10
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: slt [[T11]],[[T11]],[[T1]]
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: slt [[T0]],[[T0]],[[T1]]
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T6]],[[T6]],0x10
; MIPS32: sll [[T6]],[[T6]],0x10
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: srl [[T12:.*]],a2,0x10
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: slt [[T12]],[[T12]],[[T2]]
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: slt [[T0]],[[T0]],[[T1]]
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T7]],[[T7]],0x10
; MIPS32: sll [[T7]],[[T7]],0x10
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: srl [[T13:.*]],a3,0x10
; MIPS32: andi [[T13]],[[T13]],0x1
; MIPS32: srl [[T3]],[[T3]],0x10
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T13]],[[T13]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: slt [[T13]],[[T13]],[[T3]]
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <8 x i1> @test_icmp_v8i1_uge(<8 x i1> %a, <8 x i1> %b) {
entry:
  %res = icmp uge <8 x i1> %a, %b
  ret <8 x i1> %res
; CHECK-LABEL: test_icmp_v8i1_uge
; CHECK: pxor
; CHECK: pcmpgtw
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v8i1_uge
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: sltu [[T8]],[[T8]],[[T9]]
; MIPS32: xori [[T8]],[[T8]],0x1
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x10
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sltu [[T10]],[[T10]],[[T0]]
; MIPS32: xori [[T10]],[[T10]],0x1
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T4]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: sll [[T5]],[[T5]],0x10
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x10
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: srl [[T1]],[[T1]],0x10
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T11]],[[T11]],[[T1]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T1]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T6]],[[T6]],0x10
; MIPS32: sll [[T6]],[[T6]],0x10
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: srl [[T12:.*]],a2,0x10
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: sltu [[T12]],[[T12]],[[T2]]
; MIPS32: xori [[T12]],[[T12]],0x1
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T1]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T7]],[[T7]],0x10
; MIPS32: sll [[T7]],[[T7]],0x10
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: srl [[T13:.*]],a3,0x10
; MIPS32: andi [[T13]],[[T13]],0x1
; MIPS32: srl [[T3]],[[T3]],0x10
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T13]],[[T13]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: sltu [[T13]],[[T13]],[[T3]]
; MIPS32: xori [[T13]],[[T13]],0x1
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <8 x i1> @test_icmp_v8i1_ugt(<8 x i1> %a, <8 x i1> %b) {
entry:
  %res = icmp ugt <8 x i1> %a, %b
  ret <8 x i1> %res
; CHECK-LABEL: test_icmp_v8i1_ugt
; CHECK: pxor
; CHECK: pcmpgtw

; MIPS32-LABEL: test_icmp_v8i1_ugt
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: sltu [[T9]],[[T9]],[[T8]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: or [[T9]],[[T9]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x10
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T10]]
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: or v0,[[T0]],[[T9]]
; MIPS32: move [[T10]],a1
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sltu [[T4]],[[T4]],[[T10]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: sll [[T5]],[[T5]],0x10
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x10
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: srl [[T1]],[[T1]],0x10
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T1]],[[T1]],[[T11]]
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: or v1,[[T1]],[[T4]]
; MIPS32: move [[T10]],a2
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T2]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: srl [[T6]],[[T6]],0x10
; MIPS32: sll [[T6]],[[T6]],0x10
; MIPS32: or [[T11]],[[T11]],[[T6]]
; MIPS32: srl [[T12:.*]],a2,0x10
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: sltu [[T2]],[[T2]],[[T12]]
; MIPS32: sll [[T2]],[[T2]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: or [[T2]],[[T2]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T3]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: srl [[T7]],[[T7]],0x10
; MIPS32: sll [[T7]],[[T7]],0x10
; MIPS32: or [[T11]],[[T11]],[[T7]]
; MIPS32: srl [[T13:.*]],a3,0x10
; MIPS32: andi [[T13]],[[T13]],0x1
; MIPS32: srl [[T3]],[[T3]],0x10
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T13]],[[T13]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: sltu [[T3]],[[T3]],[[T13]]
; MIPS32: sll [[T3]],[[T3]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: or [[T3]],[[T3]],[[T11]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <8 x i1> @test_icmp_v8i1_ule(<8 x i1> %a, <8 x i1> %b) {
entry:
  %res = icmp ule <8 x i1> %a, %b
  ret <8 x i1> %res
; CHECK-LABEL: test_icmp_v8i1_ule
; CHECK: pxor
; CHECK: pcmpgtw
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v8i1_ule
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: sltu [[T9]],[[T9]],[[T8]]
; MIPS32: xori [[T9]],[[T9]],0x1
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: or [[T9]],[[T9]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x10
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T10]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: or v0,[[T0]],[[T9]]
; MIPS32: move [[T10]],a1
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sltu [[T4]],[[T4]],[[T10]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: sll [[T5]],[[T5]],0x10
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x10
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: srl [[T1]],[[T1]],0x10
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T1]],[[T1]],[[T11]]
; MIPS32: xori [[T1]],[[T1]],0x1
; MIPS32: sll [[T1]],[[T1]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: or v1,[[T1]],[[T4]]
; MIPS32: move [[T10]],a2
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T2]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: srl [[T6]],[[T6]],0x10
; MIPS32: sll [[T6]],[[T6]],0x10
; MIPS32: or [[T11]],[[T11]],[[T6]]
; MIPS32: srl [[T12:.*]],a2,0x10
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: sltu [[T2]],[[T2]],[[T12]]
; MIPS32: xori [[T2]],[[T2]],0x1
; MIPS32: sll [[T2]],[[T2]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: or [[T2]],[[T2]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: andi [[T10]],[[T10]],0xffff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T3]]
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xffff
; MIPS32: srl [[T7]],[[T7]],0x10
; MIPS32: sll [[T7]],[[T7]],0x10
; MIPS32: or [[T11]],[[T11]],[[T7]]
; MIPS32: srl [[T13:.*]],a3,0x10
; MIPS32: andi [[T13]],[[T13]],0x1
; MIPS32: srl [[T3]],[[T3]],0x10
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T13]],[[T13]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: sltu [[T3]],[[T3]],[[T13]]
; MIPS32: xori [[T3]],[[T3]],0x1
; MIPS32: sll [[T3]],[[T3]],0x10
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: or [[T3]],[[T3]],[[T11]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <8 x i1> @test_icmp_v8i1_ult(<8 x i1> %a, <8 x i1> %b) {
entry:
  %res = icmp ult <8 x i1> %a, %b
  ret <8 x i1> %res
; CHECK-LABEL: test_icmp_v8i1_ult
; CHECK: pxor
; CHECK: pcmpgtw

; MIPS32-LABEL: test_icmp_v8i1_ult
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xffff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: sltu [[T8]],[[T8]],[[T9]]
; MIPS32: andi [[T8]],[[T8]],0xffff
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x10
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sltu [[T10]],[[T10]],[[T0]]
; MIPS32: sll [[T10]],[[T10]],0x10
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xffff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T4]]
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: sll [[T5]],[[T5]],0x10
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x10
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: srl [[T1]],[[T1]],0x10
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T11]],[[T11]],[[T1]]
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T1]]
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T6]],[[T6]],0x10
; MIPS32: sll [[T6]],[[T6]],0x10
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: srl [[T12:.*]],a2,0x10
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: sltu [[T12]],[[T12]],[[T2]]
; MIPS32: sll [[T12]],[[T12]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xffff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T1]]
; MIPS32: andi [[T0]],[[T0]],0xffff
; MIPS32: srl [[T7]],[[T7]],0x10
; MIPS32: sll [[T7]],[[T7]],0x10
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: srl [[T13:.*]],a3,0x10
; MIPS32: andi [[T13]],[[T13]],0x1
; MIPS32: srl [[T3]],[[T3]],0x10
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T13]],[[T13]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: sltu [[T13]],[[T13]],[[T3]]
; MIPS32: sll [[T13]],[[T13]],0x10
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <16 x i1> @test_icmp_v16i8_eq(<16 x i8> %a, <16 x i8> %b) {
entry:
  %res = icmp eq <16 x i8> %a, %b
  ret <16 x i1> %res
; CHECK-LABEL: test_icmp_v16i8_eq
; CHECK: pcmpeqb

; MIPS32-LABEL: test_icmp_v16i8_eq
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T8]],[[T8]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: xor [[T8]],[[T8]],[[T9]]
; MIPS32: sltiu [[T8]],[[T8]],1
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x8
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: xor [[T4]],[[T4]],[[T9]]
; MIPS32: sltiu [[T4]],[[T4]],1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T9]],0xffff
; MIPS32: ori [[T9]],[[T9]],0xff
; MIPS32: and [[T8]],[[T8]],[[T9]]
; MIPS32: or [[T4]],[[T4]],[[T8]]
; MIPS32: move [[T8]],a0
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T8]],[[T8]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: xor [[T8]],[[T8]],[[T9]]
; MIPS32: sltiu [[T8]],[[T8]],1
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: lui [[T9]],0xff00
; MIPS32: ori [[T9]],[[T9]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T9]]
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x18
; MIPS32: srl [[T0]],[[T0]],0x18
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: xor [[T10]],[[T10]],[[T0]]
; MIPS32: sltiu [[T10]],[[T10]],1
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T8]],[[T8]],0x8
; MIPS32: srl [[T8]],[[T8]],0x8
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: xor [[T0]],[[T0]],[[T4]]
; MIPS32: sltiu [[T0]],[[T0]],1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: move [[T4]],a1
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sll [[T5]],[[T5]],0x18
; MIPS32: xor [[T4]],[[T4]],[[T5]]
; MIPS32: sltiu [[T4]],[[T4]],1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T5]],0xffff
; MIPS32: ori [[T5]],[[T5]],0xff
; MIPS32: and [[T0]],[[T0]],[[T5]]
; MIPS32: or [[T4]],[[T4]],[[T0]]
; MIPS32: move [[T0]],a1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T5]],[[T5]],0x18
; MIPS32: xor [[T0]],[[T0]],[[T5]]
; MIPS32: sltiu [[T0]],[[T0]],1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T5]],0xff00
; MIPS32: ori [[T5]],[[T5]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T5]]
; MIPS32: or [[T0]],[[T0]],[[T4]]
; MIPS32: srl [[T11:.*]],a1,0x18
; MIPS32: srl [[T1]],[[T1]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: xor [[T11]],[[T11]],[[T1]]
; MIPS32: sltiu [[T11]],[[T11]],1
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: xor [[T0]],[[T0]],[[T1]]
; MIPS32: sltiu [[T0]],[[T0]],1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T6]],[[T6]],0x8
; MIPS32: sll [[T6]],[[T6]],0x8
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: move [[T1]],a2
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: xor [[T1]],[[T1]],[[T4]]
; MIPS32: sltiu [[T1]],[[T1]],1
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T4]],0xffff
; MIPS32: ori [[T4]],[[T4]],0xff
; MIPS32: and [[T0]],[[T0]],[[T4]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: xor [[T0]],[[T0]],[[T4]]
; MIPS32: sltiu [[T0]],[[T0]],1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T4]],0xff00
; MIPS32: ori [[T4]],[[T4]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T4]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T12:.*]],a2,0x18
; MIPS32: srl [[T2]],[[T2]],0x18
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: xor [[T12]],[[T12]],[[T2]]
; MIPS32: sltiu [[T12]],[[T12]],1
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: xor [[T0]],[[T0]],[[T1]]
; MIPS32: sltiu [[T0]],[[T0]],1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T7]],[[T7]],0x8
; MIPS32: sll [[T7]],[[T7]],0x8
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: move [[T1]],a3
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x8
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: xor [[T1]],[[T1]],[[T2]]
; MIPS32: sltiu [[T1]],[[T1]],1
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T2]],0xffff
; MIPS32: ori [[T2]],[[T2]],0xff
; MIPS32: and [[T0]],[[T0]],[[T2]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: xor [[T0]],[[T0]],[[T2]]
; MIPS32: sltiu [[T0]],[[T0]],1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T2]],0xff00
; MIPS32: ori [[T2]],[[T2]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T2]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T13:.*]],a3,0x18
; MIPS32: srl [[T3]],[[T3]],0x18
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T3]],[[T3]],0x18
; MIPS32: xor [[T13]],[[T13]],[[T3]]
; MIPS32: sltiu [[T13]],[[T13]],1
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <16 x i1> @test_icmp_v16i8_ne(<16 x i8> %a, <16 x i8> %b) {
entry:
  %res = icmp ne <16 x i8> %a, %b
  ret <16 x i1> %res
; CHECK-LABEL: test_icmp_v16i8_ne
; CHECK: pcmpeqb
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v16i8_ne
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T8]],[[T8]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: xor [[T8]],[[T8]],[[T9]]
; MIPS32: sltu [[T8]],zero,[[T8]]
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x8
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: xor [[T4]],[[T4]],[[T9]]
; MIPS32: sltu [[T4]],zero,[[T4]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T9]],0xffff
; MIPS32: ori [[T9]],[[T9]],0xff
; MIPS32: and [[T8]],[[T8]],[[T9]]
; MIPS32: or [[T4]],[[T4]],[[T8]]
; MIPS32: move [[T8]],a0
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T8]],[[T8]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: xor [[T8]],[[T8]],[[T9]]
; MIPS32: sltu [[T8]],zero,[[T8]]
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: lui [[T9]],0xff00
; MIPS32: ori [[T9]],[[T9]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T9]]
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x18
; MIPS32: srl [[T0]],[[T0]],0x18
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: xor [[T10]],[[T10]],[[T0]]
; MIPS32: sltu [[T10]],zero,[[T10]]
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T8]],[[T8]],0x8
; MIPS32: srl [[T8]],[[T8]],0x8
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: xor [[T0]],[[T0]],[[T4]]
; MIPS32: sltu [[T0]],zero,[[T0]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: move [[T4]],a1
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sll [[T5]],[[T5]],0x18
; MIPS32: xor [[T4]],[[T4]],[[T5]]
; MIPS32: sltu [[T4]],zero,[[T4]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T5]],0xffff
; MIPS32: ori [[T5]],[[T5]],0xff
; MIPS32: and [[T0]],[[T0]],[[T5]]
; MIPS32: or [[T4]],[[T4]],[[T0]]
; MIPS32: move [[T0]],a1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T5]],[[T5]],0x18
; MIPS32: xor [[T0]],[[T0]],[[T5]]
; MIPS32: sltu [[T0]],zero,[[T0]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T5]],0xff00
; MIPS32: ori [[T5]],[[T5]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T5]]
; MIPS32: or [[T0]],[[T0]],[[T4]]
; MIPS32: srl [[T11:.*]],a1,0x18
; MIPS32: srl [[T1]],[[T1]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: xor [[T11]],[[T11]],[[T1]]
; MIPS32: sltu [[T11]],zero,[[T11]]
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: xor [[T0]],[[T0]],[[T1]]
; MIPS32: sltu [[T0]],zero,[[T0]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T6]],[[T6]],0x8
; MIPS32: sll [[T6]],[[T6]],0x8
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: move [[T1]],a2
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: xor [[T1]],[[T1]],[[T4]]
; MIPS32: sltu [[T1]],zero,[[T1]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T4]],0xffff
; MIPS32: ori [[T4]],[[T4]],0xff
; MIPS32: and [[T0]],[[T0]],[[T4]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: xor [[T0]],[[T0]],[[T4]]
; MIPS32: sltu [[T0]],zero,[[T0]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T4]],0xff00
; MIPS32: ori [[T4]],[[T4]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T4]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T12:.*]],a2,0x18
; MIPS32: srl [[T2]],[[T2]],0x18
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: xor [[T12]],[[T12]],[[T2]]
; MIPS32: sltu [[T12]],zero,[[T12]]
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: xor [[T0]],[[T0]],[[T1]]
; MIPS32: sltu [[T0]],zero,[[T0]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T7]],[[T7]],0x8
; MIPS32: sll [[T7]],[[T7]],0x8
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: move [[T1]],a3
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x8
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: xor [[T1]],[[T1]],[[T2]]
; MIPS32: sltu [[T1]],zero,[[T1]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T2]],0xffff
; MIPS32: ori [[T2]],[[T2]],0xff
; MIPS32: and [[T0]],[[T0]],[[T2]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: xor [[T0]],[[T0]],[[T2]]
; MIPS32: sltu [[T0]],zero,[[T0]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T2]],0xff00
; MIPS32: ori [[T2]],[[T2]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T2]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T13:.*]],a3,0x18
; MIPS32: srl [[T3]],[[T3]],0x18
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T3]],[[T3]],0x18
; MIPS32: xor [[T13]],[[T13]],[[T3]]
; MIPS32: sltu [[T13]],zero,[[T13]]
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <16 x i1> @test_icmp_v16i8_sgt(<16 x i8> %a, <16 x i8> %b) {
entry:
  %res = icmp sgt <16 x i8> %a, %b
  ret <16 x i1> %res
; CHECK-LABEL: test_icmp_v16i8_sgt
; CHECK: pcmpgtb

; MIPS32-LABEL: test_icmp_v16i8_sgt
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T8]],[[T8]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: slt [[T9]],[[T9]],[[T8]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: or [[T9]],[[T9]],[[T4]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: move [[T8]],[[T0]]
; MIPS32: srl [[T8]],[[T8]],0x8
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sll [[T8]],[[T8]],0x18
; MIPS32: slt [[T8]],[[T8]],[[T4]]
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T8]],[[T8]],0x8
; MIPS32: lui [[T4]],0xffff
; MIPS32: ori [[T4]],[[T4]],0xff
; MIPS32: and [[T9]],[[T9]],[[T4]]
; MIPS32: or [[T8]],[[T8]],[[T9]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: slt [[T9]],[[T9]],[[T4]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: lui [[T4]],0xff00
; MIPS32: ori [[T4]],[[T4]],0xffff
; MIPS32: and [[T8]],[[T8]],[[T4]]
; MIPS32: or [[T9]],[[T9]],[[T8]]
; MIPS32: srl [[T10:.*]],a0,0x18
; MIPS32: srl [[T0]],[[T0]],0x18
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: slt [[T0]],[[T0]],[[T10]]
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T9]],[[T9]],0x8
; MIPS32: srl [[T9]],[[T9]],0x8
; MIPS32: or v0,[[T0]],[[T9]]
; MIPS32: move [[T10]],a1
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: slt [[T4]],[[T4]],[[T10]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: move [[T10]],a1
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T5]],[[T5]],0x18
; MIPS32: slt [[T5]],[[T5]],[[T10]]
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T4]],[[T4]],[[T10]]
; MIPS32: or [[T5]],[[T5]],[[T4]]
; MIPS32: move [[T10]],a1
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: slt [[T4]],[[T4]],[[T10]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T5]],[[T5]],[[T10]]
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x18
; MIPS32: srl [[T1]],[[T1]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: slt [[T1]],[[T1]],[[T11]]
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: or v1,[[T1]],[[T4]]
; MIPS32: move [[T10]],a2
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T11]],[[T2]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: srl [[T6]],[[T6]],0x8
; MIPS32: sll [[T6]],[[T6]],0x8
; MIPS32: or [[T11]],[[T11]],[[T6]]
; MIPS32: move [[T10]],a2
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: slt [[T4]],[[T4]],[[T10]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T11]],[[T11]],[[T10]]
; MIPS32: or [[T4]],[[T4]],[[T11]]
; MIPS32: move [[T10]],a2
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T11]],[[T2]]
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T10]]
; MIPS32: or [[T11]],[[T11]],[[T4]]
; MIPS32: srl [[T12:.*]],a2,0x18
; MIPS32: srl [[T2]],[[T2]],0x18
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: slt [[T2]],[[T2]],[[T12]]
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: sll [[T11]],[[T11]],0x8
; MIPS32: srl [[T11]],[[T11]],0x8
; MIPS32: or [[T2]],[[T2]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T11]],[[T3]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: srl [[T7]],[[T7]],0x8
; MIPS32: sll [[T7]],[[T7]],0x8
; MIPS32: or [[T11]],[[T11]],[[T7]]
; MIPS32: move [[T10]],a3
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T12]],[[T3]]
; MIPS32: srl [[T12]],[[T12]],0x8
; MIPS32: andi [[T12]],[[T12]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: slt [[T12]],[[T12]],[[T10]]
; MIPS32: andi [[T12]],[[T12]],0xff
; MIPS32: sll [[T12]],[[T12]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T11]],[[T11]],[[T10]]
; MIPS32: or [[T12]],[[T12]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T11]],[[T3]]
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T12]],[[T12]],[[T10]]
; MIPS32: or [[T11]],[[T11]],[[T12]]
; MIPS32: srl [[T13:.*]],a3,0x18
; MIPS32: srl [[T3]],[[T3]],0x18
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T3]],[[T3]],0x18
; MIPS32: slt [[T3]],[[T3]],[[T13]]
; MIPS32: sll [[T3]],[[T3]],0x18
; MIPS32: sll [[T11]],[[T11]],0x8
; MIPS32: srl [[T11]],[[T11]],0x8
; MIPS32: or [[T3]],[[T3]],[[T11]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <16 x i1> @test_icmp_v16i8_sle(<16 x i8> %a, <16 x i8> %b) {
entry:
  %res = icmp sle <16 x i8> %a, %b
  ret <16 x i1> %res
; CHECK-LABEL: test_icmp_v16i8_sle
; CHECK: pcmpgtb
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v16i8_sle
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T8]],[[T8]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: slt [[T9]],[[T9]],[[T8]]
; MIPS32: xori [[T9]],[[T9]],0x1
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: or [[T9]],[[T9]],[[T4]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: move [[T8]],[[T0]]
; MIPS32: srl [[T8]],[[T8]],0x8
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sll [[T8]],[[T8]],0x18
; MIPS32: slt [[T8]],[[T8]],[[T4]]
; MIPS32: xori [[T8]],[[T8]],0x1
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T8]],[[T8]],0x8
; MIPS32: lui [[T4]],0xffff
; MIPS32: ori [[T4]],[[T4]],0xff
; MIPS32: and [[T9]],[[T9]],[[T4]]
; MIPS32: or [[T8]],[[T8]],[[T9]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: slt [[T9]],[[T9]],[[T4]]
; MIPS32: xori [[T9]],[[T9]],0x1
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: lui [[T4]],0xff00
; MIPS32: ori [[T4]],[[T4]],0xffff
; MIPS32: and [[T8]],[[T8]],[[T4]]
; MIPS32: or [[T9]],[[T9]],[[T8]]
; MIPS32: srl [[T10:.*]],a0,0x18
; MIPS32: srl [[T0]],[[T0]],0x18
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: slt [[T0]],[[T0]],[[T10]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T9]],[[T9]],0x8
; MIPS32: srl [[T9]],[[T9]],0x8
; MIPS32: or v0,[[T0]],[[T9]]
; MIPS32: move [[T10]],a1
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: slt [[T4]],[[T4]],[[T10]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: move [[T10]],a1
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T5]],[[T5]],0x18
; MIPS32: slt [[T5]],[[T5]],[[T10]]
; MIPS32: xori [[T5]],[[T5]],0x1
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T4]],[[T4]],[[T10]]
; MIPS32: or [[T5]],[[T5]],[[T4]]
; MIPS32: move [[T10]],a1
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: slt [[T4]],[[T4]],[[T10]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T5]],[[T5]],[[T10]]
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x18
; MIPS32: srl [[T1]],[[T1]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: slt [[T1]],[[T1]],[[T11]]
; MIPS32: xori [[T1]],[[T1]],0x1
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: or v1,[[T1]],[[T4]]
; MIPS32: move [[T10]],a2
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T11]],[[T2]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: srl [[T6]],[[T6]],0x8
; MIPS32: sll [[T6]],[[T6]],0x8
; MIPS32: or [[T11]],[[T11]],[[T6]]
; MIPS32: move [[T10]],a2
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: slt [[T4]],[[T4]],[[T10]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T11]],[[T11]],[[T10]]
; MIPS32: or [[T4]],[[T4]],[[T11]]
; MIPS32: move [[T10]],a2
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T11]],[[T2]]
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T10]]
; MIPS32: or [[T11]],[[T11]],[[T4]]
; MIPS32: srl [[T12:.*]],a2,0x18
; MIPS32: srl [[T2]],[[T2]],0x18
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: slt [[T2]],[[T2]],[[T12]]
; MIPS32: xori [[T2]],[[T2]],0x1
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: sll [[T11]],[[T11]],0x8
; MIPS32: srl [[T11]],[[T11]],0x8
; MIPS32: or [[T2]],[[T2]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T11]],[[T3]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: srl [[T7]],[[T7]],0x8
; MIPS32: sll [[T7]],[[T7]],0x8
; MIPS32: or [[T11]],[[T11]],[[T7]]
; MIPS32: move [[T10]],a3
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T12]],[[T3]]
; MIPS32: srl [[T12]],[[T12]],0x8
; MIPS32: andi [[T12]],[[T12]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: slt [[T12]],[[T12]],[[T10]]
; MIPS32: xori [[T12]],[[T12]],0x1
; MIPS32: andi [[T12]],[[T12]],0xff
; MIPS32: sll [[T12]],[[T12]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T11]],[[T11]],[[T10]]
; MIPS32: or [[T12]],[[T12]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T11]],[[T3]]
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T12]],[[T12]],[[T10]]
; MIPS32: or [[T11]],[[T11]],[[T12]]
; MIPS32: srl [[T13:.*]],a3,0x18
; MIPS32: srl [[T3]],[[T3]],0x18
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T3]],[[T3]],0x18
; MIPS32: slt [[T3]],[[T3]],[[T13]]
; MIPS32: xori [[T3]],[[T3]],0x1
; MIPS32: sll [[T3]],[[T3]],0x18
; MIPS32: sll [[T11]],[[T11]],0x8
; MIPS32: srl [[T11]],[[T11]],0x8
; MIPS32: or [[T3]],[[T3]],[[T11]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <16 x i1> @test_icmp_v16i8_slt(<16 x i8> %a, <16 x i8> %b) {
entry:
  %res = icmp slt <16 x i8> %a, %b
  ret <16 x i1> %res
; CHECK-LABEL: test_icmp_v16i8_slt
; CHECK: pcmpgtb

; MIPS32-LABEL: test_icmp_v16i8_slt
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T8]],[[T8]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: slt [[T8]],[[T8]],[[T9]]
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x8
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: slt [[T4]],[[T4]],[[T9]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T9]],0xffff
; MIPS32: ori [[T9]],[[T9]],0xff
; MIPS32: and [[T8]],[[T8]],[[T9]]
; MIPS32: or [[T4]],[[T4]],[[T8]]
; MIPS32: move [[T8]],a0
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T8]],[[T8]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: slt [[T8]],[[T8]],[[T9]]
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: lui [[T9]],0xff00
; MIPS32: ori [[T9]],[[T9]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T9]]
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x18
; MIPS32: srl [[T0]],[[T0]],0x18
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: slt [[T10]],[[T10]],[[T0]]
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T8]],[[T8]],0x8
; MIPS32: srl [[T8]],[[T8]],0x8
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: slt [[T0]],[[T0]],[[T4]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: move [[T4]],a1
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sll [[T5]],[[T5]],0x18
; MIPS32: slt [[T4]],[[T4]],[[T5]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T5]],0xffff
; MIPS32: ori [[T5]],[[T5]],0xff
; MIPS32: and [[T0]],[[T0]],[[T5]]
; MIPS32: or [[T4]],[[T4]],[[T0]]
; MIPS32: move [[T0]],a1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T5]],[[T5]],0x18
; MIPS32: slt [[T0]],[[T0]],[[T5]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T5]],0xff00
; MIPS32: ori [[T5]],[[T5]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T5]]
; MIPS32: or [[T0]],[[T0]],[[T4]]
; MIPS32: srl [[T11:.*]],a1,0x18
; MIPS32: srl [[T1]],[[T1]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: slt [[T11]],[[T11]],[[T1]]
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: slt [[T0]],[[T0]],[[T1]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T6]],[[T6]],0x8
; MIPS32: sll [[T6]],[[T6]],0x8
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: move [[T1]],a2
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: slt [[T1]],[[T1]],[[T4]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T4]],0xffff
; MIPS32: ori [[T4]],[[T4]],0xff
; MIPS32: and [[T0]],[[T0]],[[T4]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: slt [[T0]],[[T0]],[[T4]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T4]],0xff00
; MIPS32: ori [[T4]],[[T4]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T4]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T12:.*]],a2,0x18
; MIPS32: srl [[T2]],[[T2]],0x18
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: slt [[T12]],[[T12]],[[T2]]
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: slt [[T0]],[[T0]],[[T1]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T7]],[[T7]],0x8
; MIPS32: sll [[T7]],[[T7]],0x8
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: move [[T1]],a3
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x8
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: slt [[T1]],[[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T2]],0xffff
; MIPS32: ori [[T2]],[[T2]],0xff
; MIPS32: and [[T0]],[[T0]],[[T2]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: slt [[T0]],[[T0]],[[T2]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T2]],0xff00
; MIPS32: ori [[T2]],[[T2]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T2]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T13:.*]],a3,0x18
; MIPS32: srl [[T3]],[[T3]],0x18
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T3]],[[T3]],0x18
; MIPS32: slt [[T13]],[[T13]],[[T3]]
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <16 x i1> @test_icmp_v16i8_uge(<16 x i8> %a, <16 x i8> %b) {
entry:
  %res = icmp uge <16 x i8> %a, %b
  ret <16 x i1> %res
; CHECK-LABEL: test_icmp_v16i8_uge
; CHECK: pxor
; CHECK: pcmpgtb
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v16i8_uge
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T8]],[[T8]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: sltu [[T8]],[[T8]],[[T9]]
; MIPS32: xori [[T8]],[[T8]],0x1
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x8
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: sltu [[T4]],[[T4]],[[T9]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T9]],0xffff
; MIPS32: ori [[T9]],[[T9]],0xff
; MIPS32: and [[T8]],[[T8]],[[T9]]
; MIPS32: or [[T4]],[[T4]],[[T8]]
; MIPS32: move [[T8]],a0
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T8]],[[T8]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: sltu [[T8]],[[T8]],[[T9]]
; MIPS32: xori [[T8]],[[T8]],0x1
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: lui [[T9]],0xff00
; MIPS32: ori [[T9]],[[T9]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T9]]
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x18
; MIPS32: srl [[T0]],[[T0]],0x18
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sltu [[T10]],[[T10]],[[T0]]
; MIPS32: xori [[T10]],[[T10]],0x1
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T8]],[[T8]],0x8
; MIPS32: srl [[T8]],[[T8]],0x8
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sltu [[T0]],[[T0]],[[T4]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: move [[T4]],a1
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sll [[T5]],[[T5]],0x18
; MIPS32: sltu [[T4]],[[T4]],[[T5]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T5]],0xffff
; MIPS32: ori [[T5]],[[T5]],0xff
; MIPS32: and [[T0]],[[T0]],[[T5]]
; MIPS32: or [[T4]],[[T4]],[[T0]]
; MIPS32: move [[T0]],a1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T5]],[[T5]],0x18
; MIPS32: sltu [[T0]],[[T0]],[[T5]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T5]],0xff00
; MIPS32: ori [[T5]],[[T5]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T5]]
; MIPS32: or [[T0]],[[T0]],[[T4]]
; MIPS32: srl [[T11:.*]],a1,0x18
; MIPS32: srl [[T1]],[[T1]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sltu [[T11]],[[T11]],[[T1]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sltu [[T0]],[[T0]],[[T1]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T6]],[[T6]],0x8
; MIPS32: sll [[T6]],[[T6]],0x8
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: move [[T1]],a2
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sltu [[T1]],[[T1]],[[T4]]
; MIPS32: xori [[T1]],[[T1]],0x1
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T4]],0xffff
; MIPS32: ori [[T4]],[[T4]],0xff
; MIPS32: and [[T0]],[[T0]],[[T4]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sltu [[T0]],[[T0]],[[T4]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T4]],0xff00
; MIPS32: ori [[T4]],[[T4]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T4]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T12:.*]],a2,0x18
; MIPS32: srl [[T2]],[[T2]],0x18
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: sltu [[T12]],[[T12]],[[T2]]
; MIPS32: xori [[T12]],[[T12]],0x1
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sltu [[T0]],[[T0]],[[T1]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T7]],[[T7]],0x8
; MIPS32: sll [[T7]],[[T7]],0x8
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: move [[T1]],a3
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x8
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: sltu [[T1]],[[T1]],[[T2]]
; MIPS32: xori [[T1]],[[T1]],0x1
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T2]],0xffff
; MIPS32: ori [[T2]],[[T2]],0xff
; MIPS32: and [[T0]],[[T0]],[[T2]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: sltu [[T0]],[[T0]],[[T2]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T2]],0xff00
; MIPS32: ori [[T2]],[[T2]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T2]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T13:.*]],a3,0x18
; MIPS32: srl [[T3]],[[T3]],0x18
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T3]],[[T3]],0x18
; MIPS32: sltu [[T13]],[[T13]],[[T3]]
; MIPS32: xori [[T13]],[[T13]],0x1
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <16 x i1> @test_icmp_v16i8_ugt(<16 x i8> %a, <16 x i8> %b) {
entry:
  %res = icmp ugt <16 x i8> %a, %b
  ret <16 x i1> %res
; CHECK-LABEL: test_icmp_v16i8_ugt
; CHECK: pxor
; CHECK: pcmpgtb

; MIPS32-LABEL: test_icmp_v16i8_ugt
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T8]],[[T8]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: sltu [[T9]],[[T9]],[[T8]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: or [[T9]],[[T9]],[[T4]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: move [[T8]],[[T0]]
; MIPS32: srl [[T8]],[[T8]],0x8
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sll [[T8]],[[T8]],0x18
; MIPS32: sltu [[T8]],[[T8]],[[T4]]
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T8]],[[T8]],0x8
; MIPS32: lui [[T4]],0xffff
; MIPS32: ori [[T4]],[[T4]],0xff
; MIPS32: and [[T9]],[[T9]],[[T4]]
; MIPS32: or [[T8]],[[T8]],[[T9]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: sltu [[T9]],[[T9]],[[T4]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: lui [[T4]],0xff00
; MIPS32: ori [[T4]],[[T4]],0xffff
; MIPS32: and [[T8]],[[T8]],[[T4]]
; MIPS32: or [[T9]],[[T9]],[[T8]]
; MIPS32: srl [[T10:.*]],a0,0x18
; MIPS32: srl [[T0]],[[T0]],0x18
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sltu [[T0]],[[T0]],[[T10]]
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T9]],[[T9]],0x8
; MIPS32: srl [[T9]],[[T9]],0x8
; MIPS32: or v0,[[T0]],[[T9]]
; MIPS32: move [[T10]],a1
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sltu [[T4]],[[T4]],[[T10]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: move [[T10]],a1
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T5]],[[T5]],0x18
; MIPS32: sltu [[T5]],[[T5]],[[T10]]
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T4]],[[T4]],[[T10]]
; MIPS32: or [[T5]],[[T5]],[[T4]]
; MIPS32: move [[T10]],a1
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sltu [[T4]],[[T4]],[[T10]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T5]],[[T5]],[[T10]]
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x18
; MIPS32: srl [[T1]],[[T1]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sltu [[T1]],[[T1]],[[T11]]
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: or v1,[[T1]],[[T4]]
; MIPS32: move [[T10]],a2
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T11]],[[T2]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: srl [[T6]],[[T6]],0x8
; MIPS32: sll [[T6]],[[T6]],0x8
; MIPS32: or [[T11]],[[T11]],[[T6]]
; MIPS32: move [[T10]],a2
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sltu [[T4]],[[T4]],[[T10]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T11]],[[T11]],[[T10]]
; MIPS32: or [[T4]],[[T4]],[[T11]]
; MIPS32: move [[T10]],a2
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T11]],[[T2]]
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T10]]
; MIPS32: or [[T11]],[[T11]],[[T4]]
; MIPS32: srl [[T12:.*]],a2,0x18
; MIPS32: srl [[T2]],[[T2]],0x18
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: sltu [[T2]],[[T2]],[[T12]]
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: sll [[T11]],[[T11]],0x8
; MIPS32: srl [[T11]],[[T11]],0x8
; MIPS32: or [[T2]],[[T2]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T11]],[[T3]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: srl [[T7]],[[T7]],0x8
; MIPS32: sll [[T7]],[[T7]],0x8
; MIPS32: or [[T11]],[[T11]],[[T7]]
; MIPS32: move [[T10]],a3
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T12]],[[T3]]
; MIPS32: srl [[T12]],[[T12]],0x8
; MIPS32: andi [[T12]],[[T12]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sltu [[T12]],[[T12]],[[T10]]
; MIPS32: andi [[T12]],[[T12]],0xff
; MIPS32: sll [[T12]],[[T12]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T11]],[[T11]],[[T10]]
; MIPS32: or [[T12]],[[T12]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T11]],[[T3]]
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T12]],[[T12]],[[T10]]
; MIPS32: or [[T11]],[[T11]],[[T12]]
; MIPS32: srl [[T13:.*]],a3,0x18
; MIPS32: srl [[T3]],[[T3]],0x18
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T3]],[[T3]],0x18
; MIPS32: sltu [[T3]],[[T3]],[[T13]]
; MIPS32: sll [[T3]],[[T3]],0x18
; MIPS32: sll [[T11]],[[T11]],0x8
; MIPS32: srl [[T11]],[[T11]],0x8
; MIPS32: or [[T3]],[[T3]],[[T11]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <16 x i1> @test_icmp_v16i8_ule(<16 x i8> %a, <16 x i8> %b) {
entry:
  %res = icmp ule <16 x i8> %a, %b
  ret <16 x i1> %res
; CHECK-LABEL: test_icmp_v16i8_ule
; CHECK: pxor
; CHECK: pcmpgtb
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v16i8_ule
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T8]],[[T8]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: sltu [[T9]],[[T9]],[[T8]]
; MIPS32: xori [[T9]],[[T9]],0x1
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: or [[T9]],[[T9]],[[T4]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: move [[T8]],[[T0]]
; MIPS32: srl [[T8]],[[T8]],0x8
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sll [[T8]],[[T8]],0x18
; MIPS32: sltu [[T8]],[[T8]],[[T4]]
; MIPS32: xori [[T8]],[[T8]],0x1
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T8]],[[T8]],0x8
; MIPS32: lui [[T4]],0xffff
; MIPS32: ori [[T4]],[[T4]],0xff
; MIPS32: and [[T9]],[[T9]],[[T4]]
; MIPS32: or [[T8]],[[T8]],[[T9]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: sltu [[T9]],[[T9]],[[T4]]
; MIPS32: xori [[T9]],[[T9]],0x1
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: lui [[T4]],0xff00
; MIPS32: ori [[T4]],[[T4]],0xffff
; MIPS32: and [[T8]],[[T8]],[[T4]]
; MIPS32: or [[T9]],[[T9]],[[T8]]
; MIPS32: srl [[T10:.*]],a0,0x18
; MIPS32: srl [[T0]],[[T0]],0x18
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sltu [[T0]],[[T0]],[[T10]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T9]],[[T9]],0x8
; MIPS32: srl [[T9]],[[T9]],0x8
; MIPS32: or v0,[[T0]],[[T9]]
; MIPS32: move [[T10]],a1
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sltu [[T4]],[[T4]],[[T10]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: move [[T10]],a1
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T5]],[[T5]],0x18
; MIPS32: sltu [[T5]],[[T5]],[[T10]]
; MIPS32: xori [[T5]],[[T5]],0x1
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T4]],[[T4]],[[T10]]
; MIPS32: or [[T5]],[[T5]],[[T4]]
; MIPS32: move [[T10]],a1
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sltu [[T4]],[[T4]],[[T10]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T5]],[[T5]],[[T10]]
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x18
; MIPS32: srl [[T1]],[[T1]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sltu [[T1]],[[T1]],[[T11]]
; MIPS32: xori [[T1]],[[T1]],0x1
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: or v1,[[T1]],[[T4]]
; MIPS32: move [[T10]],a2
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T11]],[[T2]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: srl [[T6]],[[T6]],0x8
; MIPS32: sll [[T6]],[[T6]],0x8
; MIPS32: or [[T11]],[[T11]],[[T6]]
; MIPS32: move [[T10]],a2
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sltu [[T4]],[[T4]],[[T10]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T11]],[[T11]],[[T10]]
; MIPS32: or [[T4]],[[T4]],[[T11]]
; MIPS32: move [[T10]],a2
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T11]],[[T2]]
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T10]]
; MIPS32: or [[T11]],[[T11]],[[T4]]
; MIPS32: srl [[T12:.*]],a2,0x18
; MIPS32: srl [[T2]],[[T2]],0x18
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: sltu [[T2]],[[T2]],[[T12]]
; MIPS32: xori [[T2]],[[T2]],0x1
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: sll [[T11]],[[T11]],0x8
; MIPS32: srl [[T11]],[[T11]],0x8
; MIPS32: or [[T2]],[[T2]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T11]],[[T3]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: srl [[T7]],[[T7]],0x8
; MIPS32: sll [[T7]],[[T7]],0x8
; MIPS32: or [[T11]],[[T11]],[[T7]]
; MIPS32: move [[T10]],a3
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T12]],[[T3]]
; MIPS32: srl [[T12]],[[T12]],0x8
; MIPS32: andi [[T12]],[[T12]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sltu [[T12]],[[T12]],[[T10]]
; MIPS32: xori [[T12]],[[T12]],0x1
; MIPS32: andi [[T12]],[[T12]],0xff
; MIPS32: sll [[T12]],[[T12]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T11]],[[T11]],[[T10]]
; MIPS32: or [[T12]],[[T12]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: move [[T11]],[[T3]]
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T12]],[[T12]],[[T10]]
; MIPS32: or [[T11]],[[T11]],[[T12]]
; MIPS32: srl [[T13:.*]],a3,0x18
; MIPS32: srl [[T3]],[[T3]],0x18
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T3]],[[T3]],0x18
; MIPS32: sltu [[T3]],[[T3]],[[T13]]
; MIPS32: xori [[T3]],[[T3]],0x1
; MIPS32: sll [[T3]],[[T3]],0x18
; MIPS32: sll [[T11]],[[T11]],0x8
; MIPS32: srl [[T11]],[[T11]],0x8
; MIPS32: or [[T3]],[[T3]],[[T11]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <16 x i1> @test_icmp_v16i8_ult(<16 x i8> %a, <16 x i8> %b) {
entry:
  %res = icmp ult <16 x i8> %a, %b
  ret <16 x i1> %res
; CHECK-LABEL: test_icmp_v16i8_ult
; CHECK: pxor
; CHECK: pcmpgtb

; MIPS32-LABEL: test_icmp_v16i8_ult
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T8]],[[T8]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: sltu [[T8]],[[T8]],[[T9]]
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x8
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: sltu [[T4]],[[T4]],[[T9]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T9]],0xffff
; MIPS32: ori [[T9]],[[T9]],0xff
; MIPS32: and [[T8]],[[T8]],[[T9]]
; MIPS32: or [[T4]],[[T4]],[[T8]]
; MIPS32: move [[T8]],a0
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T8]],[[T8]],0x18
; MIPS32: sll [[T9]],[[T9]],0x18
; MIPS32: sltu [[T8]],[[T8]],[[T9]]
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: lui [[T9]],0xff00
; MIPS32: ori [[T9]],[[T9]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T9]]
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x18
; MIPS32: srl [[T0]],[[T0]],0x18
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sltu [[T10]],[[T10]],[[T0]]
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T8]],[[T8]],0x8
; MIPS32: srl [[T8]],[[T8]],0x8
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sltu [[T0]],[[T0]],[[T4]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: move [[T4]],a1
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sll [[T5]],[[T5]],0x18
; MIPS32: sltu [[T4]],[[T4]],[[T5]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T5]],0xffff
; MIPS32: ori [[T5]],[[T5]],0xff
; MIPS32: and [[T0]],[[T0]],[[T5]]
; MIPS32: or [[T4]],[[T4]],[[T0]]
; MIPS32: move [[T0]],a1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T5]],[[T5]],0x18
; MIPS32: sltu [[T0]],[[T0]],[[T5]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T5]],0xff00
; MIPS32: ori [[T5]],[[T5]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T5]]
; MIPS32: or [[T0]],[[T0]],[[T4]]
; MIPS32: srl [[T11:.*]],a1,0x18
; MIPS32: srl [[T1]],[[T1]],0x18
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sltu [[T11]],[[T11]],[[T1]]
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sltu [[T0]],[[T0]],[[T1]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T6]],[[T6]],0x8
; MIPS32: sll [[T6]],[[T6]],0x8
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: move [[T1]],a2
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sltu [[T1]],[[T1]],[[T4]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T4]],0xffff
; MIPS32: ori [[T4]],[[T4]],0xff
; MIPS32: and [[T0]],[[T0]],[[T4]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T4]],[[T4]],0x18
; MIPS32: sltu [[T0]],[[T0]],[[T4]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T4]],0xff00
; MIPS32: ori [[T4]],[[T4]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T4]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T12:.*]],a2,0x18
; MIPS32: srl [[T2]],[[T2]],0x18
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: sltu [[T12]],[[T12]],[[T2]]
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sltu [[T0]],[[T0]],[[T1]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T7]],[[T7]],0x8
; MIPS32: sll [[T7]],[[T7]],0x8
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: move [[T1]],a3
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x8
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: sltu [[T1]],[[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T2]],0xffff
; MIPS32: ori [[T2]],[[T2]],0xff
; MIPS32: and [[T0]],[[T0]],[[T2]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: sltu [[T0]],[[T0]],[[T2]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T2]],0xff00
; MIPS32: ori [[T2]],[[T2]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T2]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T13:.*]],a3,0x18
; MIPS32: srl [[T3]],[[T3]],0x18
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T3]],[[T3]],0x18
; MIPS32: sltu [[T13]],[[T13]],[[T3]]
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <16 x i1> @test_icmp_v16i1_eq(<16 x i1> %a, <16 x i1> %b) {
entry:
  %res = icmp eq <16 x i1> %a, %b
  ret <16 x i1> %res
; CHECK-LABEL: test_icmp_v16i1_eq
; CHECK: pcmpeqb

; MIPS32-LABEL: test_icmp_v16i1_eq
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: xor [[T8]],[[T8]],[[T9]]
; MIPS32: sltiu [[T8]],[[T8]],1
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x8
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: xor [[T4]],[[T4]],[[T9]]
; MIPS32: sltiu [[T4]],[[T4]],1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T9]],0xffff
; MIPS32: ori [[T9]],[[T9]],0xff
; MIPS32: and [[T8]],[[T8]],[[T9]]
; MIPS32: or [[T4]],[[T4]],[[T8]]
; MIPS32: move [[T8]],a0
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: xor [[T8]],[[T8]],[[T9]]
; MIPS32: sltiu [[T8]],[[T8]],1
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: lui [[T9]],0xff00
; MIPS32: ori [[T9]],[[T9]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T9]]
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x18
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: srl [[T0]],[[T0]],0x18
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: xor [[T10]],[[T10]],[[T0]]
; MIPS32: sltiu [[T10]],[[T10]],1
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T8]],[[T8]],0x8
; MIPS32: srl [[T8]],[[T8]],0x8
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: xor [[T0]],[[T0]],[[T4]]
; MIPS32: sltiu [[T0]],[[T0]],1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: move [[T4]],a1
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: andi [[T5]],[[T5]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: xor [[T4]],[[T4]],[[T5]]
; MIPS32: sltiu [[T4]],[[T4]],1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T5]],0xffff
; MIPS32: ori [[T5]],[[T5]],0xff
; MIPS32: and [[T0]],[[T0]],[[T5]]
; MIPS32: or [[T4]],[[T4]],[[T0]]
; MIPS32: move [[T0]],a1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: andi [[T5]],[[T5]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: xor [[T0]],[[T0]],[[T5]]
; MIPS32: sltiu [[T0]],[[T0]],1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T5]],0xff00
; MIPS32: ori [[T5]],[[T5]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T5]]
; MIPS32: or [[T0]],[[T0]],[[T4]]
; MIPS32: srl [[T11:.*]],a1,0x18
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: srl [[T1]],[[T1]],0x18
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: xor [[T11]],[[T11]],[[T1]]
; MIPS32: sltiu [[T11]],[[T11]],1
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: xor [[T0]],[[T0]],[[T1]]
; MIPS32: sltiu [[T0]],[[T0]],1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T6]],[[T6]],0x8
; MIPS32: sll [[T6]],[[T6]],0x8
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: move [[T1]],a2
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: xor [[T1]],[[T1]],[[T4]]
; MIPS32: sltiu [[T1]],[[T1]],1
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T4]],0xffff
; MIPS32: ori [[T4]],[[T4]],0xff
; MIPS32: and [[T0]],[[T0]],[[T4]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: xor [[T0]],[[T0]],[[T4]]
; MIPS32: sltiu [[T0]],[[T0]],1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T4]],0xff00
; MIPS32: ori [[T4]],[[T4]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T4]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T12:.*]],a2,0x18
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: srl [[T2]],[[T2]],0x18
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: xor [[T12]],[[T12]],[[T2]]
; MIPS32: sltiu [[T12]],[[T12]],1
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: xor [[T0]],[[T0]],[[T1]]
; MIPS32: sltiu [[T0]],[[T0]],1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T7]],[[T7]],0x8
; MIPS32: sll [[T7]],[[T7]],0x8
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: move [[T1]],a3
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x8
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: xor [[T1]],[[T1]],[[T2]]
; MIPS32: sltiu [[T1]],[[T1]],1
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T2]],0xffff
; MIPS32: ori [[T2]],[[T2]],0xff
; MIPS32: and [[T0]],[[T0]],[[T2]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: xor [[T0]],[[T0]],[[T2]]
; MIPS32: sltiu [[T0]],[[T0]],1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T2]],0xff00
; MIPS32: ori [[T2]],[[T2]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T2]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T13:.*]],a3,0x18
; MIPS32: andi [[T13]],[[T13]],0x1
; MIPS32: srl [[T3]],[[T3]],0x18
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T13]],[[T13]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: xor [[T13]],[[T13]],[[T3]]
; MIPS32: sltiu [[T13]],[[T13]],1
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <16 x i1> @test_icmp_v16i1_ne(<16 x i1> %a, <16 x i1> %b) {
entry:
  %res = icmp ne <16 x i1> %a, %b
  ret <16 x i1> %res
; CHECK-LABEL: test_icmp_v16i1_ne
; CHECK: pcmpeqb
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v16i1_ne
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: xor [[T8]],[[T8]],[[T9]]
; MIPS32: sltu [[T8]],zero,[[T8]]
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x8
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: xor [[T4]],[[T4]],[[T9]]
; MIPS32: sltu [[T4]],zero,[[T4]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T9]],0xffff
; MIPS32: ori [[T9]],[[T9]],0xff
; MIPS32: and [[T8]],[[T8]],[[T9]]
; MIPS32: or [[T4]],[[T4]],[[T8]]
; MIPS32: move [[T8]],a0
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: xor [[T8]],[[T8]],[[T9]]
; MIPS32: sltu [[T8]],zero,[[T8]]
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: lui [[T9]],0xff00
; MIPS32: ori [[T9]],[[T9]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T9]]
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x18
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: srl [[T0]],[[T0]],0x18
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: xor [[T10]],[[T10]],[[T0]]
; MIPS32: sltu [[T10]],zero,[[T10]]
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T8]],[[T8]],0x8
; MIPS32: srl [[T8]],[[T8]],0x8
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: xor [[T0]],[[T0]],[[T4]]
; MIPS32: sltu [[T0]],zero,[[T0]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: move [[T4]],a1
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: andi [[T5]],[[T5]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: xor [[T4]],[[T4]],[[T5]]
; MIPS32: sltu [[T4]],zero,[[T4]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T5]],0xffff
; MIPS32: ori [[T5]],[[T5]],0xff
; MIPS32: and [[T0]],[[T0]],[[T5]]
; MIPS32: or [[T4]],[[T4]],[[T0]]
; MIPS32: move [[T0]],a1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: andi [[T5]],[[T5]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: xor [[T0]],[[T0]],[[T5]]
; MIPS32: sltu [[T0]],zero,[[T0]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T5]],0xff00
; MIPS32: ori [[T5]],[[T5]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T5]]
; MIPS32: or [[T0]],[[T0]],[[T4]]
; MIPS32: srl [[T11:.*]],a1,0x18
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: srl [[T1]],[[T1]],0x18
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: xor [[T11]],[[T11]],[[T1]]
; MIPS32: sltu [[T11]],zero,[[T11]]
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: xor [[T0]],[[T0]],[[T1]]
; MIPS32: sltu [[T0]],zero,[[T0]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T6]],[[T6]],0x8
; MIPS32: sll [[T6]],[[T6]],0x8
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: move [[T1]],a2
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: xor [[T1]],[[T1]],[[T4]]
; MIPS32: sltu [[T1]],zero,[[T1]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T4]],0xffff
; MIPS32: ori [[T4]],[[T4]],0xff
; MIPS32: and [[T0]],[[T0]],[[T4]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: xor [[T0]],[[T0]],[[T4]]
; MIPS32: sltu [[T0]],zero,[[T0]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T4]],0xff00
; MIPS32: ori [[T4]],[[T4]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T4]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T12:.*]],a2,0x18
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: srl [[T2]],[[T2]],0x18
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: xor [[T12]],[[T12]],[[T2]]
; MIPS32: sltu [[T12]],zero,[[T12]]
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: xor [[T0]],[[T0]],[[T1]]
; MIPS32: sltu [[T0]],zero,[[T0]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T7]],[[T7]],0x8
; MIPS32: sll [[T7]],[[T7]],0x8
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: move [[T1]],a3
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x8
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: xor [[T1]],[[T1]],[[T2]]
; MIPS32: sltu [[T1]],zero,[[T1]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T2]],0xffff
; MIPS32: ori [[T2]],[[T2]],0xff
; MIPS32: and [[T0]],[[T0]],[[T2]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: xor [[T0]],[[T0]],[[T2]]
; MIPS32: sltu [[T0]],zero,[[T0]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T2]],0xff00
; MIPS32: ori [[T2]],[[T2]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T2]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T13:.*]],a3,0x18
; MIPS32: andi [[T13]],[[T13]],0x1
; MIPS32: srl [[T3]],[[T3]],0x18
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T13]],[[T13]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: xor [[T13]],[[T13]],[[T3]]
; MIPS32: sltu [[T13]],zero,[[T13]]
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <16 x i1> @test_icmp_v16i1_sgt(<16 x i1> %a, <16 x i1> %b) {
entry:
  %res = icmp sgt <16 x i1> %a, %b
  ret <16 x i1> %res
; CHECK-LABEL: test_icmp_v16i1_sgt
; CHECK: pcmpgtb

; MIPS32-LABEL: test_icmp_v16i1_sgt
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: slt [[T9]],[[T9]],[[T8]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: or [[T9]],[[T9]],[[T4]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: move [[T8]],[[T0]]
; MIPS32: srl [[T8]],[[T8]],0x8
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: slt [[T8]],[[T8]],[[T4]]
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T8]],[[T8]],0x8
; MIPS32: lui [[T4]],0xffff
; MIPS32: ori [[T4]],[[T4]],0xff
; MIPS32: and [[T9]],[[T9]],[[T4]]
; MIPS32: or [[T8]],[[T8]],[[T9]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: slt [[T9]],[[T9]],[[T4]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: lui [[T4]],0xff00
; MIPS32: ori [[T4]],[[T4]],0xffff
; MIPS32: and [[T8]],[[T8]],[[T4]]
; MIPS32: or [[T9]],[[T9]],[[T8]]
; MIPS32: srl [[T10:.*]],a0,0x18
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: srl [[T0]],[[T0]],0x18
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: slt [[T0]],[[T0]],[[T10]]
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T9]],[[T9]],0x8
; MIPS32: srl [[T9]],[[T9]],0x8
; MIPS32: or v0,[[T0]],[[T9]]
; MIPS32: move [[T10]],a1
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: slt [[T4]],[[T4]],[[T10]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: move [[T10]],a1
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: andi [[T5]],[[T5]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: slt [[T5]],[[T5]],[[T10]]
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T4]],[[T4]],[[T10]]
; MIPS32: or [[T5]],[[T5]],[[T4]]
; MIPS32: move [[T10]],a1
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: slt [[T4]],[[T4]],[[T10]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T5]],[[T5]],[[T10]]
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x18
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: srl [[T1]],[[T1]],0x18
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: slt [[T1]],[[T1]],[[T11]]
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: or v1,[[T1]],[[T4]]
; MIPS32: move [[T10]],a2
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T2]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: srl [[T6]],[[T6]],0x8
; MIPS32: sll [[T6]],[[T6]],0x8
; MIPS32: or [[T11]],[[T11]],[[T6]]
; MIPS32: move [[T10]],a2
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: slt [[T4]],[[T4]],[[T10]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T11]],[[T11]],[[T10]]
; MIPS32: or [[T4]],[[T4]],[[T11]]
; MIPS32: move [[T10]],a2
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T2]]
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T10]]
; MIPS32: or [[T11]],[[T11]],[[T4]]
; MIPS32: srl [[T12:.*]],a2,0x18
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: srl [[T2]],[[T2]],0x18
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: slt [[T2]],[[T2]],[[T12]]
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: sll [[T11]],[[T11]],0x8
; MIPS32: srl [[T11]],[[T11]],0x8
; MIPS32: or [[T2]],[[T2]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T3]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: srl [[T7]],[[T7]],0x8
; MIPS32: sll [[T7]],[[T7]],0x8
; MIPS32: or [[T11]],[[T11]],[[T7]]
; MIPS32: move [[T10]],a3
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T12]],[[T3]]
; MIPS32: srl [[T12]],[[T12]],0x8
; MIPS32: andi [[T12]],[[T12]],0xff
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: slt [[T12]],[[T12]],[[T10]]
; MIPS32: andi [[T12]],[[T12]],0xff
; MIPS32: sll [[T12]],[[T12]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T11]],[[T11]],[[T10]]
; MIPS32: or [[T12]],[[T12]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T3]]
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T12]],[[T12]],[[T10]]
; MIPS32: or [[T11]],[[T11]],[[T12]]
; MIPS32: srl [[T13:.*]],a3,0x18
; MIPS32: andi [[T13]],[[T13]],0x1
; MIPS32: srl [[T3]],[[T3]],0x18
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T13]],[[T13]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: slt [[T3]],[[T3]],[[T13]]
; MIPS32: sll [[T3]],[[T3]],0x18
; MIPS32: sll [[T11]],[[T11]],0x8
; MIPS32: srl [[T11]],[[T11]],0x8
; MIPS32: or [[T3]],[[T3]],[[T11]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <16 x i1> @test_icmp_v16i1_sle(<16 x i1> %a, <16 x i1> %b) {
entry:
  %res = icmp sle <16 x i1> %a, %b
  ret <16 x i1> %res
; CHECK-LABEL: test_icmp_v16i1_sle
; CHECK: pcmpgtb
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v16i1_sle
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: slt [[T9]],[[T9]],[[T8]]
; MIPS32: xori [[T9]],[[T9]],0x1
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: or [[T9]],[[T9]],[[T4]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: move [[T8]],[[T0]]
; MIPS32: srl [[T8]],[[T8]],0x8
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: slt [[T8]],[[T8]],[[T4]]
; MIPS32: xori [[T8]],[[T8]],0x1
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T8]],[[T8]],0x8
; MIPS32: lui [[T4]],0xffff
; MIPS32: ori [[T4]],[[T4]],0xff
; MIPS32: and [[T9]],[[T9]],[[T4]]
; MIPS32: or [[T8]],[[T8]],[[T9]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: slt [[T9]],[[T9]],[[T4]]
; MIPS32: xori [[T9]],[[T9]],0x1
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: lui [[T4]],0xff00
; MIPS32: ori [[T4]],[[T4]],0xffff
; MIPS32: and [[T8]],[[T8]],[[T4]]
; MIPS32: or [[T9]],[[T9]],[[T8]]
; MIPS32: srl [[T10:.*]],a0,0x18
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: srl [[T0]],[[T0]],0x18
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: slt [[T0]],[[T0]],[[T10]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T9]],[[T9]],0x8
; MIPS32: srl [[T9]],[[T9]],0x8
; MIPS32: or v0,[[T0]],[[T9]]
; MIPS32: move [[T10]],a1
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: slt [[T4]],[[T4]],[[T10]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: move [[T10]],a1
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: andi [[T5]],[[T5]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: slt [[T5]],[[T5]],[[T10]]
; MIPS32: xori [[T5]],[[T5]],0x1
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T4]],[[T4]],[[T10]]
; MIPS32: or [[T5]],[[T5]],[[T4]]
; MIPS32: move [[T10]],a1
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: slt [[T4]],[[T4]],[[T10]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T5]],[[T5]],[[T10]]
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x18
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: srl [[T1]],[[T1]],0x18
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: slt [[T1]],[[T1]],[[T11]]
; MIPS32: xori [[T1]],[[T1]],0x1
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: or v1,[[T1]],[[T4]]
; MIPS32: move [[T10]],a2
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T2]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: srl [[T6]],[[T6]],0x8
; MIPS32: sll [[T6]],[[T6]],0x8
; MIPS32: or [[T11]],[[T11]],[[T6]]
; MIPS32: move [[T10]],a2
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: slt [[T4]],[[T4]],[[T10]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T11]],[[T11]],[[T10]]
; MIPS32: or [[T4]],[[T4]],[[T11]]
; MIPS32: move [[T10]],a2
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T2]]
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T10]]
; MIPS32: or [[T11]],[[T11]],[[T4]]
; MIPS32: srl [[T12:.*]],a2,0x18
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: srl [[T2]],[[T2]],0x18
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: slt [[T2]],[[T2]],[[T12]]
; MIPS32: xori [[T2]],[[T2]],0x1
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: sll [[T11]],[[T11]],0x8
; MIPS32: srl [[T11]],[[T11]],0x8
; MIPS32: or [[T2]],[[T2]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T3]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: srl [[T7]],[[T7]],0x8
; MIPS32: sll [[T7]],[[T7]],0x8
; MIPS32: or [[T11]],[[T11]],[[T7]]
; MIPS32: move [[T10]],a3
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T12]],[[T3]]
; MIPS32: srl [[T12]],[[T12]],0x8
; MIPS32: andi [[T12]],[[T12]],0xff
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: slt [[T12]],[[T12]],[[T10]]
; MIPS32: xori [[T12]],[[T12]],0x1
; MIPS32: andi [[T12]],[[T12]],0xff
; MIPS32: sll [[T12]],[[T12]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T11]],[[T11]],[[T10]]
; MIPS32: or [[T12]],[[T12]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T3]]
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: slt [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T12]],[[T12]],[[T10]]
; MIPS32: or [[T11]],[[T11]],[[T12]]
; MIPS32: srl [[T13:.*]],a3,0x18
; MIPS32: andi [[T13]],[[T13]],0x1
; MIPS32: srl [[T3]],[[T3]],0x18
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T13]],[[T13]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: slt [[T3]],[[T3]],[[T13]]
; MIPS32: xori [[T3]],[[T3]],0x1
; MIPS32: sll [[T3]],[[T3]],0x18
; MIPS32: sll [[T11]],[[T11]],0x8
; MIPS32: srl [[T11]],[[T11]],0x8
; MIPS32: or [[T3]],[[T3]],[[T11]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <16 x i1> @test_icmp_v16i1_slt(<16 x i1> %a, <16 x i1> %b) {
entry:
  %res = icmp slt <16 x i1> %a, %b
  ret <16 x i1> %res
; CHECK-LABEL: test_icmp_v16i1_slt
; CHECK: pcmpgtb

; MIPS32-LABEL: test_icmp_v16i1_slt
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: slt [[T8]],[[T8]],[[T9]]
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x8
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: slt [[T4]],[[T4]],[[T9]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T9]],0xffff
; MIPS32: ori [[T9]],[[T9]],0xff
; MIPS32: and [[T8]],[[T8]],[[T9]]
; MIPS32: or [[T4]],[[T4]],[[T8]]
; MIPS32: move [[T8]],a0
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: slt [[T8]],[[T8]],[[T9]]
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: lui [[T9]],0xff00
; MIPS32: ori [[T9]],[[T9]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T9]]
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x18
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: srl [[T0]],[[T0]],0x18
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: slt [[T10]],[[T10]],[[T0]]
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T8]],[[T8]],0x8
; MIPS32: srl [[T8]],[[T8]],0x8
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: slt [[T0]],[[T0]],[[T4]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: move [[T4]],a1
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: andi [[T5]],[[T5]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: slt [[T4]],[[T4]],[[T5]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T5]],0xffff
; MIPS32: ori [[T5]],[[T5]],0xff
; MIPS32: and [[T0]],[[T0]],[[T5]]
; MIPS32: or [[T4]],[[T4]],[[T0]]
; MIPS32: move [[T0]],a1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: andi [[T5]],[[T5]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: slt [[T0]],[[T0]],[[T5]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T5]],0xff00
; MIPS32: ori [[T5]],[[T5]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T5]]
; MIPS32: or [[T0]],[[T0]],[[T4]]
; MIPS32: srl [[T11:.*]],a1,0x18
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: srl [[T1]],[[T1]],0x18
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: slt [[T11]],[[T11]],[[T1]]
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: slt [[T0]],[[T0]],[[T1]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T6]],[[T6]],0x8
; MIPS32: sll [[T6]],[[T6]],0x8
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: move [[T1]],a2
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: slt [[T1]],[[T1]],[[T4]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T4]],0xffff
; MIPS32: ori [[T4]],[[T4]],0xff
; MIPS32: and [[T0]],[[T0]],[[T4]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: slt [[T0]],[[T0]],[[T4]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T4]],0xff00
; MIPS32: ori [[T4]],[[T4]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T4]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T12:.*]],a2,0x18
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: srl [[T2]],[[T2]],0x18
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: slt [[T12]],[[T12]],[[T2]]
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: slt [[T0]],[[T0]],[[T1]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T7]],[[T7]],0x8
; MIPS32: sll [[T7]],[[T7]],0x8
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: move [[T1]],a3
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x8
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: slt [[T1]],[[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T2]],0xffff
; MIPS32: ori [[T2]],[[T2]],0xff
; MIPS32: and [[T0]],[[T0]],[[T2]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: slt [[T0]],[[T0]],[[T2]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T2]],0xff00
; MIPS32: ori [[T2]],[[T2]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T2]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T13:.*]],a3,0x18
; MIPS32: andi [[T13]],[[T13]],0x1
; MIPS32: srl [[T3]],[[T3]],0x18
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T13]],[[T13]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: slt [[T13]],[[T13]],[[T3]]
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <16 x i1> @test_icmp_v16i1_uge(<16 x i1> %a, <16 x i1> %b) {
entry:
  %res = icmp uge <16 x i1> %a, %b
  ret <16 x i1> %res
; CHECK-LABEL: test_icmp_v16i1_uge
; CHECK: pxor
; CHECK: pcmpgtb
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v16i1_uge
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: sltu [[T8]],[[T8]],[[T9]]
; MIPS32: xori [[T8]],[[T8]],0x1
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x8
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: sltu [[T4]],[[T4]],[[T9]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T9]],0xffff
; MIPS32: ori [[T9]],[[T9]],0xff
; MIPS32: and [[T8]],[[T8]],[[T9]]
; MIPS32: or [[T4]],[[T4]],[[T8]]
; MIPS32: move [[T8]],a0
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: sltu [[T8]],[[T8]],[[T9]]
; MIPS32: xori [[T8]],[[T8]],0x1
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: lui [[T9]],0xff00
; MIPS32: ori [[T9]],[[T9]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T9]]
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x18
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: srl [[T0]],[[T0]],0x18
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sltu [[T10]],[[T10]],[[T0]]
; MIPS32: xori [[T10]],[[T10]],0x1
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T8]],[[T8]],0x8
; MIPS32: srl [[T8]],[[T8]],0x8
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T4]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: move [[T4]],a1
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: andi [[T5]],[[T5]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: sltu [[T4]],[[T4]],[[T5]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T5]],0xffff
; MIPS32: ori [[T5]],[[T5]],0xff
; MIPS32: and [[T0]],[[T0]],[[T5]]
; MIPS32: or [[T4]],[[T4]],[[T0]]
; MIPS32: move [[T0]],a1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: andi [[T5]],[[T5]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T5]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T5]],0xff00
; MIPS32: ori [[T5]],[[T5]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T5]]
; MIPS32: or [[T0]],[[T0]],[[T4]]
; MIPS32: srl [[T11:.*]],a1,0x18
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: srl [[T1]],[[T1]],0x18
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T11]],[[T11]],[[T1]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T1]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T6]],[[T6]],0x8
; MIPS32: sll [[T6]],[[T6]],0x8
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: move [[T1]],a2
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sltu [[T1]],[[T1]],[[T4]]
; MIPS32: xori [[T1]],[[T1]],0x1
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T4]],0xffff
; MIPS32: ori [[T4]],[[T4]],0xff
; MIPS32: and [[T0]],[[T0]],[[T4]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T4]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T4]],0xff00
; MIPS32: ori [[T4]],[[T4]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T4]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T12:.*]],a2,0x18
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: srl [[T2]],[[T2]],0x18
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: sltu [[T12]],[[T12]],[[T2]]
; MIPS32: xori [[T12]],[[T12]],0x1
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T1]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T7]],[[T7]],0x8
; MIPS32: sll [[T7]],[[T7]],0x8
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: move [[T1]],a3
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x8
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: sltu [[T1]],[[T1]],[[T2]]
; MIPS32: xori [[T1]],[[T1]],0x1
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T2]],0xffff
; MIPS32: ori [[T2]],[[T2]],0xff
; MIPS32: and [[T0]],[[T0]],[[T2]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T2]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T2]],0xff00
; MIPS32: ori [[T2]],[[T2]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T2]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T13:.*]],a3,0x18
; MIPS32: andi [[T13]],[[T13]],0x1
; MIPS32: srl [[T3]],[[T3]],0x18
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T13]],[[T13]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: sltu [[T13]],[[T13]],[[T3]]
; MIPS32: xori [[T13]],[[T13]],0x1
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}

define internal <16 x i1> @test_icmp_v16i1_ugt(<16 x i1> %a, <16 x i1> %b) {
entry:
  %res = icmp ugt <16 x i1> %a, %b
  ret <16 x i1> %res
; CHECK-LABEL: test_icmp_v16i1_ugt
; CHECK: pxor
; CHECK: pcmpgtb

; MIPS32-LABEL: test_icmp_v16i1_ugt
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: sltu [[T9]],[[T9]],[[T8]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: or [[T9]],[[T9]],[[T4]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: move [[T8]],[[T0]]
; MIPS32: srl [[T8]],[[T8]],0x8
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sltu [[T8]],[[T8]],[[T4]]
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T8]],[[T8]],0x8
; MIPS32: lui [[T4]],0xffff
; MIPS32: ori [[T4]],[[T4]],0xff
; MIPS32: and [[T9]],[[T9]],[[T4]]
; MIPS32: or [[T8]],[[T8]],[[T9]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: sltu [[T9]],[[T9]],[[T4]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: lui [[T4]],0xff00
; MIPS32: ori [[T4]],[[T4]],0xffff
; MIPS32: and [[T8]],[[T8]],[[T4]]
; MIPS32: or [[T9]],[[T9]],[[T8]]
; MIPS32: srl [[T10:.*]],a0,0x18
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: srl [[T0]],[[T0]],0x18
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T10]]
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T9]],[[T9]],0x8
; MIPS32: srl [[T9]],[[T9]],0x8
; MIPS32: or v0,[[T0]],[[T9]]
; MIPS32: move [[T10]],a1
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sltu [[T4]],[[T4]],[[T10]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: move [[T10]],a1
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: andi [[T5]],[[T5]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: sltu [[T5]],[[T5]],[[T10]]
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T4]],[[T4]],[[T10]]
; MIPS32: or [[T5]],[[T5]],[[T4]]
; MIPS32: move [[T10]],a1
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sltu [[T4]],[[T4]],[[T10]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T5]],[[T5]],[[T10]]
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x18
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: srl [[T1]],[[T1]],0x18
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T1]],[[T1]],[[T11]]
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: or v1,[[T1]],[[T4]]
; MIPS32: move [[T10]],a2
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T2]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: srl [[T6]],[[T6]],0x8
; MIPS32: sll [[T6]],[[T6]],0x8
; MIPS32: or [[T11]],[[T11]],[[T6]]
; MIPS32: move [[T10]],a2
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sltu [[T4]],[[T4]],[[T10]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T11]],[[T11]],[[T10]]
; MIPS32: or [[T4]],[[T4]],[[T11]]
; MIPS32: move [[T10]],a2
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T2]]
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T10]]
; MIPS32: or [[T11]],[[T11]],[[T4]]
; MIPS32: srl [[T12:.*]],a2,0x18
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: srl [[T2]],[[T2]],0x18
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: sltu [[T2]],[[T2]],[[T12]]
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: sll [[T11]],[[T11]],0x8
; MIPS32: srl [[T11]],[[T11]],0x8
; MIPS32: or [[T2]],[[T2]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T3]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: srl [[T7]],[[T7]],0x8
; MIPS32: sll [[T7]],[[T7]],0x8
; MIPS32: or [[T11]],[[T11]],[[T7]]
; MIPS32: move [[T10]],a3
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T12]],[[T3]]
; MIPS32: srl [[T12]],[[T12]],0x8
; MIPS32: andi [[T12]],[[T12]],0xff
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sltu [[T12]],[[T12]],[[T10]]
; MIPS32: andi [[T12]],[[T12]],0xff
; MIPS32: sll [[T12]],[[T12]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T11]],[[T11]],[[T10]]
; MIPS32: or [[T12]],[[T12]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T3]]
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T12]],[[T12]],[[T10]]
; MIPS32: or [[T11]],[[T11]],[[T12]]
; MIPS32: srl [[T13:.*]],a3,0x18
; MIPS32: andi [[T13]],[[T13]],0x1
; MIPS32: srl [[T3]],[[T3]],0x18
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T13]],[[T13]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: sltu [[T3]],[[T3]],[[T13]]
; MIPS32: sll [[T3]],[[T3]],0x18
; MIPS32: sll [[T11]],[[T11]],0x8
; MIPS32: srl [[T11]],[[T11]],0x8
; MIPS32: or [[T3]],[[T3]],[[T11]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <16 x i1> @test_icmp_v16i1_ule(<16 x i1> %a, <16 x i1> %b) {
entry:
  %res = icmp ule <16 x i1> %a, %b
  ret <16 x i1> %res
; CHECK-LABEL: test_icmp_v16i1_ule
; CHECK: pxor
; CHECK: pcmpgtb
; CHECK: pxor

; MIPS32-LABEL: test_icmp_v16i1_ule
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: sltu [[T9]],[[T9]],[[T8]]
; MIPS32: xori [[T9]],[[T9]],0x1
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: or [[T9]],[[T9]],[[T4]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: move [[T8]],[[T0]]
; MIPS32: srl [[T8]],[[T8]],0x8
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sltu [[T8]],[[T8]],[[T4]]
; MIPS32: xori [[T8]],[[T8]],0x1
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T8]],[[T8]],0x8
; MIPS32: lui [[T4]],0xffff
; MIPS32: ori [[T4]],[[T4]],0xff
; MIPS32: and [[T9]],[[T9]],[[T4]]
; MIPS32: or [[T8]],[[T8]],[[T9]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: sltu [[T9]],[[T9]],[[T4]]
; MIPS32: xori [[T9]],[[T9]],0x1
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: sll [[T9]],[[T9]],0x10
; MIPS32: lui [[T4]],0xff00
; MIPS32: ori [[T4]],[[T4]],0xffff
; MIPS32: and [[T8]],[[T8]],[[T4]]
; MIPS32: or [[T9]],[[T9]],[[T8]]
; MIPS32: srl [[T10:.*]],a0,0x18
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: srl [[T0]],[[T0]],0x18
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T10]]
; MIPS32: xori [[T0]],[[T0]],0x1
; MIPS32: sll [[T0]],[[T0]],0x18
; MIPS32: sll [[T9]],[[T9]],0x8
; MIPS32: srl [[T9]],[[T9]],0x8
; MIPS32: or v0,[[T0]],[[T9]]
; MIPS32: move [[T10]],a1
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sltu [[T4]],[[T4]],[[T10]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: move [[T10]],a1
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: andi [[T5]],[[T5]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: sltu [[T5]],[[T5]],[[T10]]
; MIPS32: xori [[T5]],[[T5]],0x1
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T4]],[[T4]],[[T10]]
; MIPS32: or [[T5]],[[T5]],[[T4]]
; MIPS32: move [[T10]],a1
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sltu [[T4]],[[T4]],[[T10]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T5]],[[T5]],[[T10]]
; MIPS32: or [[T4]],[[T4]],[[T5]]
; MIPS32: srl [[T11:.*]],a1,0x18
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: srl [[T1]],[[T1]],0x18
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T1]],[[T1]],[[T11]]
; MIPS32: xori [[T1]],[[T1]],0x1
; MIPS32: sll [[T1]],[[T1]],0x18
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: or v1,[[T1]],[[T4]]
; MIPS32: move [[T10]],a2
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T2]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: srl [[T6]],[[T6]],0x8
; MIPS32: sll [[T6]],[[T6]],0x8
; MIPS32: or [[T11]],[[T11]],[[T6]]
; MIPS32: move [[T10]],a2
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sltu [[T4]],[[T4]],[[T10]]
; MIPS32: xori [[T4]],[[T4]],0x1
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T11]],[[T11]],[[T10]]
; MIPS32: or [[T4]],[[T4]],[[T11]]
; MIPS32: move [[T10]],a2
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T2]]
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T10]]
; MIPS32: or [[T11]],[[T11]],[[T4]]
; MIPS32: srl [[T12:.*]],a2,0x18
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: srl [[T2]],[[T2]],0x18
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: sltu [[T2]],[[T2]],[[T12]]
; MIPS32: xori [[T2]],[[T2]],0x1
; MIPS32: sll [[T2]],[[T2]],0x18
; MIPS32: sll [[T11]],[[T11]],0x8
; MIPS32: srl [[T11]],[[T11]],0x8
; MIPS32: or [[T2]],[[T2]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T3]]
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: srl [[T7]],[[T7]],0x8
; MIPS32: sll [[T7]],[[T7]],0x8
; MIPS32: or [[T11]],[[T11]],[[T7]]
; MIPS32: move [[T10]],a3
; MIPS32: srl [[T10]],[[T10]],0x8
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T12]],[[T3]]
; MIPS32: srl [[T12]],[[T12]],0x8
; MIPS32: andi [[T12]],[[T12]],0xff
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sltu [[T12]],[[T12]],[[T10]]
; MIPS32: xori [[T12]],[[T12]],0x1
; MIPS32: andi [[T12]],[[T12]],0xff
; MIPS32: sll [[T12]],[[T12]],0x8
; MIPS32: lui [[T10]],0xffff
; MIPS32: ori [[T10]],[[T10]],0xff
; MIPS32: and [[T11]],[[T11]],[[T10]]
; MIPS32: or [[T12]],[[T12]],[[T11]]
; MIPS32: move [[T10]],a3
; MIPS32: srl [[T10]],[[T10]],0x10
; MIPS32: andi [[T10]],[[T10]],0xff
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: move [[T11]],[[T3]]
; MIPS32: srl [[T11]],[[T11]],0x10
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sltu [[T11]],[[T11]],[[T10]]
; MIPS32: xori [[T11]],[[T11]],0x1
; MIPS32: andi [[T11]],[[T11]],0xff
; MIPS32: sll [[T11]],[[T11]],0x10
; MIPS32: lui [[T10]],0xff00
; MIPS32: ori [[T10]],[[T10]],0xffff
; MIPS32: and [[T12]],[[T12]],[[T10]]
; MIPS32: or [[T11]],[[T11]],[[T12]]
; MIPS32: srl [[T13:.*]],a3,0x18
; MIPS32: andi [[T13]],[[T13]],0x1
; MIPS32: srl [[T3]],[[T3]],0x18
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T13]],[[T13]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: sltu [[T3]],[[T3]],[[T13]]
; MIPS32: xori [[T3]],[[T3]],0x1
; MIPS32: sll [[T3]],[[T3]],0x18
; MIPS32: sll [[T11]],[[T11]],0x8
; MIPS32: srl [[T11]],[[T11]],0x8
; MIPS32: or [[T3]],[[T3]],[[T11]]
; MIPS32: move a0,[[T2]]
; MIPS32: move a1,[[T3]]
}

define internal <16 x i1> @test_icmp_v16i1_ult(<16 x i1> %a, <16 x i1> %b) {
entry:
  %res = icmp ult <16 x i1> %a, %b
  ret <16 x i1> %res
; CHECK-LABEL: test_icmp_v16i1_ult
; CHECK: pxor
; CHECK: pcmpgtb

; MIPS32-LABEL: test_icmp_v16i1_ult
; MIPS32: lw [[T0:.*]],
; MIPS32: lw [[T1:.*]],
; MIPS32: lw [[T2:.*]],
; MIPS32: lw [[T3:.*]],
; MIPS32: move [[T4:.*]],zero
; MIPS32: move [[T5:.*]],zero
; MIPS32: move [[T6:.*]],zero
; MIPS32: move [[T7:.*]],zero
; MIPS32: move [[T8:.*]],a0
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9:.*]],[[T0]]
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: sltu [[T8]],[[T8]],[[T9]]
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: move [[T4]],a0
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x8
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: sltu [[T4]],[[T4]],[[T9]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T9]],0xffff
; MIPS32: ori [[T9]],[[T9]],0xff
; MIPS32: and [[T8]],[[T8]],[[T9]]
; MIPS32: or [[T4]],[[T4]],[[T8]]
; MIPS32: move [[T8]],a0
; MIPS32: srl [[T8]],[[T8]],0x10
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: andi [[T8]],[[T8]],0x1
; MIPS32: move [[T9]],[[T0]]
; MIPS32: srl [[T9]],[[T9]],0x10
; MIPS32: andi [[T9]],[[T9]],0xff
; MIPS32: andi [[T9]],[[T9]],0x1
; MIPS32: sll [[T8]],[[T8]],0x1f
; MIPS32: sll [[T9]],[[T9]],0x1f
; MIPS32: sltu [[T8]],[[T8]],[[T9]]
; MIPS32: andi [[T8]],[[T8]],0xff
; MIPS32: sll [[T8]],[[T8]],0x10
; MIPS32: lui [[T9]],0xff00
; MIPS32: ori [[T9]],[[T9]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T9]]
; MIPS32: or [[T8]],[[T8]],[[T4]]
; MIPS32: srl [[T10:.*]],a0,0x18
; MIPS32: andi [[T10]],[[T10]],0x1
; MIPS32: srl [[T0]],[[T0]],0x18
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: sll [[T10]],[[T10]],0x1f
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sltu [[T10]],[[T10]],[[T0]]
; MIPS32: sll [[T10]],[[T10]],0x18
; MIPS32: sll [[T8]],[[T8]],0x8
; MIPS32: srl [[T8]],[[T8]],0x8
; MIPS32: or [[T10]],[[T10]],[[T8]]
; MIPS32: move [[T0]],a1
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T4]],[[T1]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T4]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: sll [[T5]],[[T5]],0x8
; MIPS32: or [[T0]],[[T0]],[[T5]]
; MIPS32: move [[T4]],a1
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x8
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: andi [[T5]],[[T5]],0x1
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: sltu [[T4]],[[T4]],[[T5]]
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: sll [[T4]],[[T4]],0x8
; MIPS32: lui [[T5]],0xffff
; MIPS32: ori [[T5]],[[T5]],0xff
; MIPS32: and [[T0]],[[T0]],[[T5]]
; MIPS32: or [[T4]],[[T4]],[[T0]]
; MIPS32: move [[T0]],a1
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T5]],[[T1]]
; MIPS32: srl [[T5]],[[T5]],0x10
; MIPS32: andi [[T5]],[[T5]],0xff
; MIPS32: andi [[T5]],[[T5]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T5]],[[T5]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T5]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T5]],0xff00
; MIPS32: ori [[T5]],[[T5]],0xffff
; MIPS32: and [[T4]],[[T4]],[[T5]]
; MIPS32: or [[T0]],[[T0]],[[T4]]
; MIPS32: srl [[T11:.*]],a1,0x18
; MIPS32: andi [[T11]],[[T11]],0x1
; MIPS32: srl [[T1]],[[T1]],0x18
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T11]],[[T11]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T11]],[[T11]],[[T1]]
; MIPS32: sll [[T11]],[[T11]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T11]],[[T11]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T1]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T6]],[[T6]],0x8
; MIPS32: sll [[T6]],[[T6]],0x8
; MIPS32: or [[T0]],[[T0]],[[T6]]
; MIPS32: move [[T1]],a2
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x8
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sltu [[T1]],[[T1]],[[T4]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T4]],0xffff
; MIPS32: ori [[T4]],[[T4]],0xff
; MIPS32: and [[T0]],[[T0]],[[T4]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a2
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T4]],[[T2]]
; MIPS32: srl [[T4]],[[T4]],0x10
; MIPS32: andi [[T4]],[[T4]],0xff
; MIPS32: andi [[T4]],[[T4]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T4]],[[T4]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T4]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T4]],0xff00
; MIPS32: ori [[T4]],[[T4]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T4]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T12:.*]],a2,0x18
; MIPS32: andi [[T12]],[[T12]],0x1
; MIPS32: srl [[T2]],[[T2]],0x18
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T12]],[[T12]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: sltu [[T12]],[[T12]],[[T2]]
; MIPS32: sll [[T12]],[[T12]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T12]],[[T12]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T1]],[[T3]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T1]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: srl [[T7]],[[T7]],0x8
; MIPS32: sll [[T7]],[[T7]],0x8
; MIPS32: or [[T0]],[[T0]],[[T7]]
; MIPS32: move [[T1]],a3
; MIPS32: srl [[T1]],[[T1]],0x8
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: andi [[T1]],[[T1]],0x1
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x8
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T1]],[[T1]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: sltu [[T1]],[[T1]],[[T2]]
; MIPS32: andi [[T1]],[[T1]],0xff
; MIPS32: sll [[T1]],[[T1]],0x8
; MIPS32: lui [[T2]],0xffff
; MIPS32: ori [[T2]],[[T2]],0xff
; MIPS32: and [[T0]],[[T0]],[[T2]]
; MIPS32: or [[T1]],[[T1]],[[T0]]
; MIPS32: move [[T0]],a3
; MIPS32: srl [[T0]],[[T0]],0x10
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: andi [[T0]],[[T0]],0x1
; MIPS32: move [[T2]],[[T3]]
; MIPS32: srl [[T2]],[[T2]],0x10
; MIPS32: andi [[T2]],[[T2]],0xff
; MIPS32: andi [[T2]],[[T2]],0x1
; MIPS32: sll [[T0]],[[T0]],0x1f
; MIPS32: sll [[T2]],[[T2]],0x1f
; MIPS32: sltu [[T0]],[[T0]],[[T2]]
; MIPS32: andi [[T0]],[[T0]],0xff
; MIPS32: sll [[T0]],[[T0]],0x10
; MIPS32: lui [[T2]],0xff00
; MIPS32: ori [[T2]],[[T2]],0xffff
; MIPS32: and [[T1]],[[T1]],[[T2]]
; MIPS32: or [[T0]],[[T0]],[[T1]]
; MIPS32: srl [[T13:.*]],a3,0x18
; MIPS32: andi [[T13]],[[T13]],0x1
; MIPS32: srl [[T3]],[[T3]],0x18
; MIPS32: andi [[T3]],[[T3]],0x1
; MIPS32: sll [[T13]],[[T13]],0x1f
; MIPS32: sll [[T3]],[[T3]],0x1f
; MIPS32: sltu [[T13]],[[T13]],[[T3]]
; MIPS32: sll [[T13]],[[T13]],0x18
; MIPS32: sll [[T0]],[[T0]],0x8
; MIPS32: srl [[T0]],[[T0]],0x8
; MIPS32: or [[T13]],[[T13]],[[T0]]
; MIPS32: move v0,[[T10]]
; MIPS32: move v1,[[T11]]
; MIPS32: move a0,[[T12]]
; MIPS32: move a1,[[T13]]
}
