/*
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */

package com.android.bluetooth.tests.mock;


import android.database.Cursor;
import android.net.Uri;
import android.test.mock.MockContentProvider;

/**
 * A provider that always return the result you want it to return
 */
public class SimpleMockContentProvider extends MockContentProvider {
    private Cursor mResult;

    public SimpleMockContentProvider(Cursor result) {
        mResult = result;
    }

    @Override
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return mResult;
    }
}