/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This file is automagically generated by hashgen, do not edit

/** \file IID_to_MPH.c Interface ID to MPH mapping */

#include "SLES/OpenSLES.h"
#include "MPH.h"
#include <assert.h>
#include <string.h>

extern const struct SLInterfaceID_ SL_IID_array[MPH_MAX];

/** \brief Map SLInterfaceID to its minimal perfect hash (MPH), or -1 if unknown */

int IID_to_MPH(const SLInterfaceID iid)
{
#define MAX_HASH_VALUE 139
  static const unsigned char asso_values[] =
    {
        5, 140, 140,   7, 140, 140,  27, 140,  17,  17,
      140,  22, 140, 140, 140,  51, 140, 140, 140, 140,
      140, 140,   2, 140, 140,  46, 140, 140, 140, 140,
      140,  17,  20, 140, 140, 140, 140, 140, 140, 140,
      140, 140,  51,  20,  46, 140,  31, 140, 140, 140,
      140, 140, 140,  36, 140,   2, 140, 140,   2, 140,
      140,  61, 140,   2,  55, 140, 140, 140, 140,  16,
      140,  26, 140, 140, 140, 140, 140, 140, 140, 140,
       21, 140, 140, 140, 140, 140,  26, 140, 140, 140,
       11, 140, 140, 140, 140, 140,  40,  21, 140,  60,
      140, 140, 140, 140, 140, 140,  16, 140, 140, 140,
      140, 140,   1, 140, 140, 140, 140, 140, 140, 140,
      140,  11,  55,   6, 140, 140, 140,   6,  45, 140,
      140,   1, 140, 140, 140, 140, 140,   1, 140, 140,
      140,   1, 140, 140, 140, 140, 140, 140, 140, 140,
      140,  60, 140, 140, 140, 140, 140, 140, 140, 140,
       10, 140, 140, 140, 140, 140, 140, 140, 140, 140,
       50, 140, 140, 140,  45, 140, 140, 140,  60, 140,
       45, 140, 140, 140, 140,  55, 140, 140, 140, 140,
      140, 140,  15, 140,  35, 140,  45,   5, 140,  50,
      140, 140, 140, 140, 140, 140, 140, 140, 140, 140,
      140, 140,  40, 140, 140,  50, 140, 140, 140, 140,
      140,  25, 140, 140,  15,  40, 140, 140,  10, 140,
      140, 140, 140, 140, 140,  10,   0, 140, 140,  15,
       30, 140, 140, 140, 140, 140,  55, 140, 140, 140,
      140, 140, 140, 140,   0, 140
    };
    static const signed char hash_to_MPH[] = {
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        -1,
        MPH_NULL,
        -1,
        -1,
        -1,
        -1,
        MPH_OUTPUTMIXEXT,
        MPH_3DSOURCE,
        MPH_VIRTUALIZER,
        -1,
        -1,
        MPH_DYNAMICSOURCE,
        MPH_ENGINECAPABILITIES,
        MPH_AUDIODECODERCAPABILITIES,
        -1,
        -1,
        MPH_RECORD,
        MPH_ANDROIDCONFIGURATION,
        MPH_XASTREAMINFORMATION,
        -1,
        -1,
        MPH_VISUALIZATION,
        MPH_ANDROIDEFFECTSEND,
        MPH_MIDITEMPO,
        -1,
        -1,
        MPH_3DGROUPING,
        MPH_MUTESOLO,
        MPH_EQUALIZER,
        -1,
        -1,
        MPH_PLAY,
        MPH_EFFECTSEND,
        MPH_VOLUME,
        -1,
        -1,
        MPH_BUFFERQUEUE,
        MPH_3DMACROSCOPIC,
        MPH_XAVOLUME,
        -1,
        -1,
        MPH_3DLOCATION,
        MPH_ENGINE,
        MPH_VIBRA,
        -1,
        -1,
        MPH_MIDIMESSAGE,
        MPH_ANDROIDBUFFERQUEUE,
        MPH_BASSBOOST,
        -1,
        -1,
        MPH_SEEK,
        MPH_OBJECT,
        MPH_MIDIMUTESOLO,
        -1,
        -1,
        MPH_PITCH,
        MPH_ANDROIDEFFECTCAPABILITIES,
        -1,
        -1,
        -1,
        MPH_METADATATRAVERSAL,
        MPH_RATEPITCH,
        -1,
        -1,
        -1,
        MPH_ENVIRONMENTALREVERB,
        MPH_PRESETREVERB,
        -1,
        -1,
        -1,
        MPH_XAPLAY,
        MPH_XAENGINE,
        -1,
        -1,
        -1,
        MPH_AUDIOIODEVICECAPABILITIES,
        MPH_MIDITIME,
        -1,
        -1,
        -1,
        MPH_DEVICEVOLUME,
        MPH_3DCOMMIT,
        -1,
        -1,
        -1,
        MPH_ANDROIDEFFECT,
        MPH_PLAYBACKRATE,
        -1,
        -1,
        -1,
        MPH_3DDOPPLER,
        MPH_LED,
        -1,
        -1,
        -1,
        MPH_METADATAEXTRACTION,
        MPH_PREFETCHSTATUS,
        -1,
        -1,
        -1,
        MPH_OUTPUTMIX,
        MPH_ANDROIDSIMPLEBUFFERQUEUE,
        -1,
        -1,
        -1,
        MPH_AUDIOENCODER,
        MPH_AUDIOENCODERCAPABILITIES,
        -1,
        -1,
        -1,
        MPH_THREADSYNC,
        -1,
        -1,
        -1,
        -1,
        MPH_DYNAMICINTERFACEMANAGEMENT
    };
    if (&SL_IID_array[0] <= iid && &SL_IID_array[MPH_MAX] > iid)
        return iid - &SL_IID_array[0];
    if (NULL != iid) {
        static const unsigned len = sizeof(struct SLInterfaceID_);
        unsigned key = len +
            asso_values[((unsigned char *)iid)[3]] + asso_values[((unsigned char *)iid)[0]];
        if (key <= MAX_HASH_VALUE) {
            int MPH = hash_to_MPH[key];
            if (MPH >= 0) {
                assert(MPH < MPH_MAX);
                SLInterfaceID trial = &SL_IID_array[MPH];
                if (!memcmp(iid, trial, sizeof(struct SLInterfaceID_)))
                    return MPH;
            }
        }
    }
    return -1;
}
