#require 'win32ole'
require 'irb/completion'

class WIN32OLE
  alias :orig_methods :methods
  def methods(flag = true)
    @ole_methods ||= ole_methods.map { |m| m.to_s.downcase }
    @ole_methods | orig_methods(flag)
  end
end

def query_ole_method(obj, methodname)
	puts  "Obj : " + obj.ole_obj_help.to_s
	method = obj.ole_method_help(methodname)
	puts "reurn : " + method.return_type
	method.params.each do |param|
	  str = ""
	  str.concat "[in] " if param.input?
	  str.concat "[out] " if param.output?
	  str.concat "[optional] " if param.optional?
	  str.concat "[retval] " if param.retval?
	  str.concat param.name
	  str.concat " = #{param.default}" if param.default
	  str.concat " As #{param.ole_type}"
	  puts str
	end # each method params
end #def query_ie_method

def newIE
	tmp = WIN32OLE.new("InternetExplorer.Application")
	tmp.visible = true
	tmp.Navigate('http://mail.yahoo.co.jp/')
	tmp.waitload
	tmp
end #def newIE