/*
 * ztxt.c - An interface for ztxt
 * Copyright (C) mellanie
 *
*/

#include <ruby.h>
#include <rubyio.h>

#define RUBY_SCONV_VERSION "0.1.0"

#define OBJ_IS_FREED(val)	(RBASIC(val)->flags == 0)

#include <stdio.h>
#include <stddef.h>
#include <stdint.h>
#include "s2u.h"
#include "u2s.h"

	/* sjis2004 based functions */
static VALUE
rb_sconv_ku_to_sj(obj)
	VALUE obj;
{
	char 		*str;
	uint16_t	len;
	unsigned char	*sjis;

	Check_Type(obj, T_STRING);
	Check_SafeStr(obj);
	str = StringValuePtr(obj);
	len = RSTRING(obj)->len;

	sjis = ku_to_sj(str, len);

	return rb_str_new((char *)sjis, 2);
} /* end rb_sconv_ku_to_sj */

static VALUE
rb_sconv_sj_to_ku(obj)
	VALUE obj;
{
	unsigned char *str;
	uint16_t	len;
	prcCode		prc;
	VALUE		result;


	Check_Type(obj, T_STRING);
	Check_SafeStr(obj);
	str = (unsigned char *)StringValuePtr(obj);
	len = RSTRING(obj)->len;

	prc = sj_to_ku(str, len);

	result = rb_ary_new();
	rb_ary_push(result, INT2FIX(prc.page));
	rb_ary_push(result, INT2FIX(prc.row));
	rb_ary_push(result, INT2FIX(prc.col));
	rb_ary_push(result, INT2FIX(prc.level));

	return result;	
} /* end rb_sconv_sj_to_ku */

static VALUE
rb_sconv_sj_to_utf8(obj)
	VALUE	obj;
{
	unsigned char	*str, *buf;
	uint16_t		len, buflen;
	unsigned long	pos;

	Check_Type(obj, T_STRING);
	Check_SafeStr(obj);
	str = (unsigned char *)StringValuePtr(obj);
	len = RSTRING(obj)->len;

	buf = sj_to_utf8(str, len, &buflen);

	return rb_str_new((char *)buf, buflen);
} /* end rb_sconv_sj_to_utf8 */

	/* utf8 based functions */
static VALUE
rb_sconv_utf8_to_sj(obj)
	VALUE	obj;
{
	unsigned char 		*str, *buf;
	unsigned char		ut1, ut2, ut3, ut4;
	charcode	curr;
	uint16_t	utf;
	uint32_t	surr;
	uint16_t	len;
	uint16_t	pos, spos;
	int			i;

	Check_Type(obj, T_STRING);
	Check_SafeStr(obj);
	str = (unsigned char *)StringValuePtr(obj);
	len = RSTRING(obj)->len;

	buf = malloc(sizeof(unsigned char) * len);
	spos = 0;
	for(pos = 0; pos <len; pos++)
	{		/* check for byte length */
		if ((str[pos] & 0x80) == 0)	/* one byte */
		{
			buf[spos++] = str[pos];
			continue;
		}/* end if one byte */
		if ((str[pos] & 0xe0) == 0xc0)	/* two byte */
		{
			ut1 = (uint8_t)str[pos++];
			ut2 = (uint8_t)str[pos];
			curr = decode2byte(ut1, ut2);
			if ((str[pos + 1] & 0xe0) == 0xc0)	/* next is three bytes again */
			{
				uint16_t		currutf, nextutf;
				uint32_t		combine;
				unsigned char	us1, us2;
				charcode		next;


				us1 = (unsigned char)str[pos + 1];
				us2 = (unsigned char)str[pos + 2];
				next = decode2byte(us1, us2);
				currutf = (uint16_t)(((uint16_t)curr.u1 * 256) + (uint8_t)curr.u2);
				nextutf = (uint16_t)(((uint16_t)next.u1 * 256) + (uint8_t)next.u2);
				combine = (uint32_t)((uint32_t)currutf << 16 | nextutf);
				switch (combine)
				{
					case 0x00e60300:
						curr.s1 = 0x86;
						curr.s2= 0x63;
						pos += 3;
						break;
					case 0x02540300:
						curr.s1 = 0x86;
						curr.s2 = 0x67;
						pos += 3;
						break;
					case 0x02540301:
						curr.s1 = 0x86;
						curr.s2 = 0x68;
						pos += 3;
						break;
					case 0x02590300:
						curr.s1 = 0x86;
						curr.s2 = 0x6b;
						pos += 3;
						break;
					case 0x02590301:
						curr.s1 = 0x86;
						curr.s2 = 0x6c;
						pos += 3;
						break;
					case 0x025a0300:
						curr.s1 = 0x86;
						curr.s2 = 0x6d;
						pos += 3;
						break;
					case 0x025a0301:
						curr.s1 = 0x86;
						curr.s2 = 0x6e;
						pos += 3;
						break;
					case 0x028c0300:
						curr.s1 = 0x86;
						curr.s2 = 0x69;
						pos += 3;
						break;
					case 0x028c0301:
						curr.s1 = 0x86;
						curr.s2 = 0x6a;
						pos += 3;
						break;
					case 0x02e502e9:
						curr.s1 = 0x86;
						curr.s2 = 0x86;
						pos += 3;
						break;
					case 0x02e902e5:
						curr.s1 = 0x86;
						curr.s2 = 0x85;
						pos += 3;
						break;
					default:
						break;
				}/* end case*/
			} /* end if three bytes again */

				/* default, append unsigned char */
			buf[spos++] = curr.s1;
			buf[spos++] = curr.s2;
			continue;
		}/* end if one byte */
		if ((str[pos] & 0xf0) == 0xe0)	/* three bytes */
		{
			ut1 = (uint8_t)str[pos++];
			ut2 = (uint8_t)str[pos++];
			ut3 = (uint8_t)str[pos];
			curr = decode3byte(ut1, ut2, ut3);
				/* check normalized form decompress */
			if ((str[pos + 1] & 0xf0) == 0xe0)	/* next is three bytes again */
			{
				uint16_t		currutf, nextutf;
				uint32_t		combine;
				unsigned char	us1, us2, us3, us4;
				charcode		next;


				us1 = (unsigned char)str[pos + 1];
				us2 = (unsigned char)str[pos + 2];
				us3 = (unsigned char)str[pos + 3];
				next = decode3byte(us1, us2, us3);
				currutf = (uint16_t)(((uint16_t)curr.u1 * 256) + (uint8_t)curr.u2);
				nextutf = (uint16_t)(((uint16_t)next.u1 * 256) + (uint8_t)next.u2);
				combine = (uint32_t)((uint32_t)currutf << 16 | nextutf);
				switch (combine)
				{
					case 0x304b309a:
						curr.s1 = 0x82;
						curr.s2 = 0xf5;
						pos += 3;
						break;
					case 0x304d309a:
						curr.s1 = 0x82;
						curr.s2 = 0xf6;
						pos += 3;
						break;
					case 0x304f309a:
						curr.s1 = 0x82;
						curr.s2 = 0xf7;
						pos += 3;
						break;
					case 0x3051309a:
						curr.s1 = 0x82;
						curr.s2 = 0xf8;
						pos += 3;
						break;
					case 0x3053309a:
						curr.s1 = 0x82;
						curr.s2 = 0xf9;
						pos += 3;
						break;
					case 0x30ab309a:
						curr.s1 = 0x83;
						curr.s2 = 0x97;
						pos += 3;
						break;
					case 0x30ad309a:
						curr.s1 = 0x83;
						curr.s2 = 0x98;
						pos += 3;
						break;
					case 0x30af309a:
						curr.s1 = 0x83;
						curr.s2 = 0x99;
						pos += 3;
						break;
					case 0x30b1309a:
						curr.s1 = 0x83;
						curr.s2 = 0x9a;
						pos += 3;
						break;
					case 0x30b3309a:
						curr.s1 = 0x83;
						curr.s2 = 0x9b;
						pos += 3;
						break;
					case 0x30bb309a:
						curr.s1 = 0x83;
						curr.s2 = 0x9c;
						pos += 3;
						break;
					case 0x30c4309a:
						curr.s1 = 0x83;
						curr.s2 = 0x9d;
						pos += 3;
						break;
					case 0x30c8309a:
						curr.s1 = 0x83;
						curr.s2 = 0x9e;
						pos += 3;
						break;
					case 0x31f7309a:
						curr.s1 = 0x83;
						curr.s2 = 0xf6;
						pos += 3;
						break;
					default:
						break;
				}/* end case*/
			} /* end if three bytes again */
				/* default, append unsigned char */
			buf[spos++] = curr.s1;
			buf[spos++] = curr.s2;
			continue;
		} /* end if threee bytes */
		if ((str[pos] & 0xf8) == 0xf0)	/* four bytes */
		{
			ut1 = str[pos++];
			ut2 = str[pos++];
			ut3 = str[pos++];
			ut4 = str[pos];
			curr = decode4byte(ut1, ut2, ut3, ut4);
			buf[spos++] = curr.s1;
			buf[spos++] = curr.s2;
			continue;
		} /* end if four bytes */
	}/* end for pos */

	return rb_str_new((char *)buf, spos);	
}

	/* utf16 based functions */
static VALUE
rb_sconv_sj_to_utf16le(obj)
	VALUE	obj;
{
	unsigned char	*str, *buf;
	uint16_t		len, buflen;
	unsigned long	pos;

	Check_Type(obj, T_STRING);
	Check_SafeStr(obj);
	str = (unsigned char *)StringValuePtr(obj);
	len = RSTRING(obj)->len;

	buf = sj_to_utf16le(str, len, &buflen);

	return rb_str_new((char *)buf, buflen);
} /* end rb_sconv_sj_to_utf16le */

static VALUE
rb_sconv_sj_to_utf16be(obj)
	VALUE	obj;
{
	unsigned char	*str, *buf;
	uint16_t		len, buflen;
	unsigned long	pos;

	Check_Type(obj, T_STRING);
	Check_SafeStr(obj);
	str = (unsigned char *)StringValuePtr(obj);
	len = RSTRING(obj)->len;

	buf = sj_to_utf16be(str, len, &buflen);

	return rb_str_new((char *)buf, buflen);
} /* end rb_sconv_sj_to_utf16be */

static VALUE
rb_sconv_chg_endian(obj)
	VALUE	obj;
{
	unsigned char 		*str, *buf;
	uint16_t	len;

	Check_Type(obj, T_STRING);
	Check_SafeStr(obj);
	str = (unsigned char *)StringValuePtr(obj);
	len = RSTRING(obj)->len;

	buf = chg_endian(str, len);

	return rb_str_new((char *)buf, len);	
}
	/* initializer definition methods to String class */
void
Init_sconv()
{

	rb_define_method(rb_cString, "ku2sj", rb_sconv_ku_to_sj, 0);
	rb_define_method(rb_cString, "sj2ku", rb_sconv_sj_to_ku, 0);
	rb_define_method(rb_cString, "sj2utf8", rb_sconv_sj_to_utf8, 0);
	rb_define_method(rb_cString, "sj2utf16le", rb_sconv_sj_to_utf16le, 0);
	rb_define_method(rb_cString, "sj2utf16be", rb_sconv_sj_to_utf16be, 0);
	rb_define_method(rb_cString, "chg_endian", rb_sconv_chg_endian, 0);
	rb_define_method(rb_cString, "utf82sj", rb_sconv_utf8_to_sj, 0);
}