title: Scheme Implementation

The concept of schemes provides the user with a bigger flexibility. It is now
possible to run multiple simulations with different layouts on the same mesh.
This is the basis for LBM passive scalar transport simulations in MUSUBI.
In general the scheme implementation is able to run on old and new lua files.

## Scheme Definition

The scheme is part of the individual solvers and contains all information about
initial conditions, boundary conditions, the [[mus_scheme_layout_module]], fluid and flow properties.

## Usage

@warning: Update: Using the scheme as a table is not supported anymore due to the fact that only 
one scheme is used.

The old subtables must not used inside a scheme table in the Musubi config file.

To start a flow simulation one can add the
table species with the following quantities:

- the scheme header which includes kind, relaxation, layout, 
  take a look at [[mus_scheme_header_module]]
- the initial conditions, take a look at [[mus_field_module:mus_set_ic_states]]
  for a list of variables that are supported for the different schemes
- the boundary conditions, take a look at [[mus_bc_header_module:mus_load_bc]]
  for the different cases of possible boundary conditions in Musubi
- the fluid quantities. For all supported input variables check [[mus_load_fluid]]

```lua
-- Sample Flow Scheme Definition
identify = {
  kind = 'lbm',        -- default value
  relaxation = 'bgk',  -- default value
  layout = 'd3q19',    -- default value
} -- identify table

-- Initial condition
initial_condition = {
  density = 1.0,
  velocityX = 0.0,
  velocityY = 0.0,
  velocityZ = 0.0,
  Sxx = 0.0, Syy = 0.0, Szz = 0.0, Sxy = 0.0, Syz = 0.0, Sxz = 0.0,
}

-- Boundary conditions
boundary_condition = {
{ label = 'wall',
  kind = 'inlet_ubb',
  velocity = { 0.03, 0.0, 0.0 },
{ label = 'wall',
  kind = 'wall',
  velocity = { 0.0, 0.0, 0.0 }
} -- boundary table

fluid = {
   omega = 1.8,
} -- fluid table
```
