! See copyright notice in the COPYRIGHT file.
?? include 'header/lbm_macros.inc'
?? include 'header/lbm_interfaceMacros.inc'
! ****************************************************************************** !
!> Boundary condition treatment routines for fluid simulation
!!
!! A detailed description on the implementation details are given in
!! boundary_implementation
!!
module mus_bc_passiveScalar_module

?? IF( .not. SOA) then
  ! include treelm modules
  use env_module,               only: rk
  use tem_time_module,          only: tem_time_type
  use treelmesh_module,         only: treelmesh_type
  use tem_varSys_module,        only: tem_varSys_type
  use tem_construction_module,  only: tem_levelDesc_type

  ! include musubi modules
  use mus_bc_header_module,      only: boundary_type, glob_boundary_type
  use mus_scheme_layout_module,  only: mus_scheme_layout_type
  use mus_field_prop_module,     only: mus_field_prop_type
  use mus_derVarPos_type_module, only: mus_derVarPos_type
  use mus_param_module,          only: mus_param_type
  use mus_physics_module,        only: mus_physics_type
  use mus_mixture_module,        only: mus_mixture_type

  implicit none

  private

  public :: inlet_pasScal
  public :: outlet_pasScal

contains

! ****************************************************************************** !
  !> Inlet boundary conditions for passive scalar transport (Flekkoy).
  !!
  !! All links of the inlet boundary elements are set to 0.0
  !!
  ! subroutine inlet_pasScal
?? copy :: bc_routineHeader( inlet_pasScal )
    ! ---------------------------------------------------------------------------
    integer :: iElem, iDir, QQ
    integer :: nElems
    ! ---------------------------------------------------------------------------
    QQ = layout%fStencil%QQ
    nElems = size( neigh ) / QQ

    do iElem = 1, globBC%nElems( iLevel )
      do iDir = 1, layout%fStencil%QQ
        state(                                                                 &
& ?SAVE?(iDir, iField, globBC%elemLvl(iLevel)%elem%val(iElem), QQ, nScalars, nElems,neigh ))&
          & = 0._rk
      end do
    end do

  end subroutine inlet_pasScal
! ****************************************************************************** !


! ****************************************************************************** !
  !> Outlet boundary conditions for passive scalar transport (Flekkoy). 
  !!
  !!  currently no obstacles allowed lx-2 upstream fluid outlet nodes
  !!
  ! subroutine outlet_pasScal
?? copy :: bc_routineHeader( outlet_pasScal )
    ! ---------------------------------------------------------------------------
    integer :: iElem, iDir, QQ
    integer :: nElems
    ! ---------------------------------------------------------------------------
    QQ = layout%fStencil%QQ
    nElems = size( neigh ) / QQ

    do iElem = 1, globBC%nElems( iLevel )
      do iDir = 1, layout%fStencil%QQ
        state(                                                                 &
& ?SAVE?( iDir, iField, globBC%elemLvl( iLevel )%elem%val( iElem ), QQ, nScalars, nElems,neigh ))  = &
          & ( state(                                                           &
& ?SAVE?( iDir, iField, me%neigh( iLevel )%posInState( 1, iElem ), QQ, nScalars, nElems,neigh ))  + &
          &   state(                                                           &
& ?SAVE?( iDir, iField, me%neigh( iLevel )%posInState( 2, iElem ), QQ, nScalars, nElems,neigh ))) / &
          &   2.0_rk
      end do
    end do

  end subroutine outlet_pasScal
! ****************************************************************************** !


?? ENDIF
end module mus_bc_passiveScalar_module
! ****************************************************************************** !
