! See copyright notice in the COPYRIGHT file.
?? include 'header/lbm_macros.inc'
?? include 'header/lbm_interfaceMacros.inc'
! ****************************************************************************** !
!> This module provides the definition and methods for
!! BGK advection relaxation scheme.
module mus_test_module

  ! include treelm modules
  use env_module,               only: rk
  use tem_varSys_module,        only: tem_varSys_type

  ! include musubi modules
  use mus_field_prop_module,     only: mus_field_prop_type
  use mus_scheme_layout_module,  only: mus_scheme_layout_type
  use mus_param_module,          only: mus_param_type

  implicit none

  private

  public :: vec_fma

contains

! ****************************************************************************** !
  !> Testing routine which performs fused multiplication and addtion on the state
  !! variable. The calculation is simple, so that the cost is mostly due to
  !! the data transfer through the memory interface.
  !!
?? copy :: compute_routineHeader( vec_fma )
?? copy :: compute_routineParams
    ! ---------------------------------------------------------------------------
    integer :: ii, nScalars
    ! ---------------------------------------------------------------------------

    nScalars = varSys%nScalars

!$omp do schedule(static)
?? copy :: dir_vector
    nodeloop: do ii = 1, nSolve * nScalars
      outState(ii) = inState(ii) * 1.00001_rk + 0.000001_rk
    end do nodeloop
!$omp end do nowait

  end subroutine vec_fma
! ****************************************************************************** !

end module mus_test_module
