! See copyright notice in the COPYRIGHT file.
?? include 'treelm/source/deriveMacros.inc'
! ****************************************************************************** !
!> This module provides the routine for applying operators. Currently it is
!! only implemented for 3D and needs to be extended to 2d
module mus_operation_var_module
  use, intrinsic :: iso_c_binding,  only: c_f_pointer, c_ptr
  use env_module,                   only: rk, long_k, labellen

  use tem_logging_module,           only: logUnit
  use tem_debug_module,             only: dbgUnit
  use tem_varSys_module,            only: tem_varSys_type,                    &
    &                                     tem_varSys_op_type,                 &
    &                                     tem_varSys_proc_point,              &
    &                                     tem_varSys_proc_element,            &
    &                                     tem_varSys_proc_setParams,          &
    &                                     tem_varSys_proc_getParams,          &
    &                                     tem_varSys_proc_setupIndices,       &
    &                                     tem_varSys_proc_getValOfIndex,      &
    &                                     tem_varSys_solverData_evalElem_type
  use tem_aux_module,               only: tem_abort
  use tem_time_module,              only: tem_time_type
  use treelmesh_module,             only: treelmesh_type
  use tem_topology_module,          only: tem_coordOfId,                &
    &                                     tem_levelOf, tem_IdOfCoord
  use tem_geometry_module,          only: tem_CoordOfReal, tem_ElemSize, &
    &                                     tem_PosofId, tem_BaryOfId
  use tem_grow_array_module,        only: grw_intArray_type, append, truncate
  use tem_operation_var_module,     only: tem_opVar_fill_inputIndex, &
    &                                     tem_varSys_op_Data_type

  use mus_scheme_type_module,        only: mus_scheme_type
  use mus_varSys_module,             only: mus_varSys_data_type,       &
    &                                      mus_varSys_solverData_type, &
    &                                      mus_get_new_solver_ptr


  implicit none

  private

  public :: mus_opVar_setupIndices
  public :: mus_set_opVar_getElement

contains


  ! ************************************************************************ !
  !> Routine to store musubi varSys Data in operation variable solver_bundle.
  !! Unline Ateles, Musubi operations does not require any special treatment so
  !! it uses to generic routines in treelm
  subroutine mus_set_opVar_getElement( solData_evalElem, fun )
    ! ------------------------------------------------------------------ !
    !> Description on how to set the element retrieval function for stfuns.
    class(tem_varSys_solverData_evalElem_type), intent(in) :: solData_evalElem

    !> Description of the method to obtain the variables, here some preset
    !! values might be stored, like the space time function to use or the
    !! required variables.
    type(tem_varSys_op_type), intent(inout) :: fun
    ! ------------------------------------------------------------------ !
    type(tem_varSys_op_Data_type), pointer :: fptr
    type(mus_varSys_solverData_type), pointer :: fSDptr
    ! ------------------------------------------------------------------ !

    write(logunit(10),*) "Setting different solver_bundle and " &
      & // " get_element routine for variable at position ",    &
      & fun%myPos
    call C_F_Pointer(fun%method_data, fptr)
    call c_f_pointer(solData_evalElem%solver_bundle, fSDptr)
    fptr%solver_bundle = mus_get_new_solver_ptr( fSDptr )

  end subroutine mus_set_opVar_getElement
  ! ************************************************************************ !

  ! ************************************************************************** !
  recursive subroutine mus_opVar_setupIndices( fun, varSys, point, offset_bit,&
    &                                iLevel, tree, nPnts, idx        )
    ! -------------------------`-----------------------------------------------!
    !> Description of the method to obtain the variables, here some preset
    !! values might be stored, like the space time function to use or the
    !! required variables.
    class(tem_varSys_op_type), intent(in) :: fun

    !> The variable system to obtain the variable from.
    type(tem_varSys_type), intent(in) :: varSys

    !> List of space coordinate points to store as growing array in
    !! method_data
    real(kind=rk), intent(in) :: point(:,:)
     
    !> Offset bit encoded as character for every point.
    !! 
    !! Offset integer coord(3) is converted into a character with
    !! offset_bit = achar( (coord(1)+1) + (coord(2)+1)*4 + (coord(3)+1)*16 )
    !! Backward transformation form character to 3 integer:
    !! coord(1) = mod(ichar(offset_bit),4) - 1
    !! coord(2) = mod(ichar(offset_bit),16)/4 - 1
    !! coord(3) = ichar(offset_bit)/16 - 1
    !!
    !! If not present default is to center i.e offset_bit = achar(1+4+16)
    character, optional, intent(in) :: offset_bit(:)

    !> Level to which input points belong to
    integer, intent(in) :: iLevel

    !> global treelm mesh info
    type(treelmesh_type), intent(in) :: tree

    !> Number of points to add in method_data of this variable
    integer, intent(in) :: nPnts

    !> Index of points in the growing array and variable val array.
    !! Size: nPoints
    !!
    !! This must be stored in boundary or source depends on who 
    !! calls this routine. 
    !! This index is required to return a value using getValOfIndex.
    integer, intent(out) :: idx(:)
    ! --------------------------------------------------------------------------!
    type(mus_varSys_data_type), pointer :: fPtr
    integer :: iPnt, iDep, nVals_prev
    type(grw_intArray_type), allocatable :: inputIndex_loc(:)
    integer, allocatable :: idxPerPnt(:)
    ! ---------------------------------------------------------------------------
    write(dbgUnit(4),*) 'setup indices for the points of derived variable ', &
      &                 trim(varSys%varname%val(fun%myPos))

    call C_F_POINTER( fun%method_Data, fPtr )

    ! allcoate the index array for all inpits
    if (.not. allocated(fPtr%opData%input_pntIndex)) then
      allocate( fPtr%OpData%input_pntIndex(fun%nInputs) )
    end if

    ! allocate temporary inputIndex with size of nInputs and initialize
    ! growing array with length nPnts
    allocate(inputIndex_loc(fun%nInputs))

    ! store which is the last entry in the indexLvl to contiguous fill the index
    ! array string from this position
    ! all input variables get the same points, we just take the nVals entry
    ! from the first input variable
    nVals_prev = fPtr%OpData%input_pntIndex(1)%indexLvl(iLevel)%nVals

    ! Now fill in the index arrays for the inputs
    call tem_opVar_fill_inputIndex( fun        = fun,           &
      &                             varSys     = varSys,        &
      &                             point      = point,         &
      &                             offset_bit = offset_bit,    &
      &                             iLevel     = iLevel,        &
      &                             tree       = tree,          &
      &                             nPnts      = nPnts,         &
      &                             inputIndex = inputIndex_loc )

    ! fill the index array of the derived variable, it starts with the first
    ! entry in this call = nVals_prev and is continguous until nVals_prev+nVals
    allocate(idxPerPnt(fun%nInputs))
    idx = 0
    do iPnt = 1, nPnts
      do iDep = 1, fun%nInputs
        idxPerPnt(iDep) = inputIndex_loc(iDep)%val(iPnt)
      end do
      ! set index only when any of dependent variable has valid index
      if (any(idxPerPnt > 0)) then
        do iDep = 1, fun%nInputs
          call append( me = fPtr%opData%input_pntIndex(iDep)%indexLvl(iLevel), &
            &         val = inputIndex_loc(iDep)%val(iPnt)                     )
        end do
        ! set index to last position in input_pntIndex of dep var 1 of
        ! indexLvl of iLevel
        idx(iPnt) = fPtr%opData%input_pntIndex(1)%indexLvl(iLevel)%nVals
      end if
    end do

    do iDep = 1, fun%nInputs
      call truncate (fPtr%opData%input_pntIndex(iDep)%indexLvl(iLevel) ) 
    end do

  end subroutine mus_opVar_setupIndices
  ! *************************************************************************** !

end module mus_operation_var_module
! **************************************************************************** !
