! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> This module contains routines which assigns compute kernel for passive scalar
!! model
module mus_initLBMPS_module

  ! include treelm modules
  use env_module,         only: labelLen
  use tem_aux_module,     only: tem_abort
  use tem_logging_module, only: logUnit

  ! include musubi modules
  use mus_bgk_module,         only: bgk_advrel_flekkoy,                        &
    &                               bgk_advrel_flekkoy_noFluid
  use mus_scheme_type_module, only: kernel

  implicit none

  private

  public :: mus_init_advRel_lbm_ps

contains

! ****************************************************************************** !
  !> Initialize the relaxation model for lbm passive scalar scheme kind
  subroutine mus_init_advRel_lbm_ps( relaxation, layout, compute )
    ! ---------------------------------------------------------------------------
    character(len=labelLen), intent(in) :: relaxation
    character(len=labelLen), intent(in) :: layout
    procedure( kernel ), pointer, intent(out) :: compute
    ! ---------------------------------------------------------------------------

    write(logUnit(1),*) 'Choosing LBM Passive Scalar relaxation model: '//     &
      &                 trim(relaxation)

    select case( trim(relaxation) )
    case( 'bgk' )
      select case( trim(layout) )
      case( 'flekkoy' )
        compute => bgk_advRel_flekkoy
      case default
        write(logUnit(1),*) 'Stencil '//trim(layout)//' is not supported yet!'
        call tem_abort()
      end select
    case( 'bgk_noFluid' )
      select case( trim(layout) )
      case( 'flekkoy' )
        compute => bgk_advRel_flekkoy_noFluid
      case default
        write(logUnit(1),*) 'Stencil '//trim(layout)//' is not supported yet!'
        call tem_abort()
      end select
    case default
      write(logUnit(1),*) 'The selected relaxation model is not supported: '// &
        &                  trim(relaxation)
      call tem_abort()
    end select

  end subroutine mus_init_advRel_lbm_ps
! ****************************************************************************** !

end module mus_initLBMPS_module
