! See copyright notice in the COPYRIGHT file.
! ****************************************************************************** !
!> This module provides a data type for moment definition
!!
module mus_moments_type_module

  ! include treelm modules
  use env_module,       only: labelLen
  use tem_matrix_module,  only: tem_matrix_type

  implicit none
  private

  public :: mus_moment_type

  !> moment space definition
  type mus_moment_type
    !> is true if this type is already filled and no need
    !! to fill again after load balancing
    logical :: mom_ready = .false.

    !> transformation matrix from pdf space to moments
    type(tem_matrix_type) :: toMoments

    !> transformation matrix from moment space to pdf
    type(tem_matrix_type) :: toPDF

    !> Labels of the moments
    character(len=labelLen), allocatable :: momLabel(:)

    ! the followings are used by moment BCs
    !> position of first order moments in moments vector
    integer, allocatable :: first_moments(:)

    !> position of second order moments in moments vector
    integer, allocatable :: second_moments(:)

    !> position of third order moments in moments vector
    integer, allocatable :: third_moments(:)

    !> position of fourth order moments in moments vector
    integer, allocatable :: fourth_moments(:)

  end type mus_moment_type

end module mus_moments_type_module
! ****************************************************************************** !
