require "common"

sim_control = {
  time_control = {
    max = { iter = tmax },
    interval = { iter = tmax / 8 },
  },
}

ebug = {
  debugMode = true,
  debugFiles = true,

  dumpTreeIDs    = false,
  dumpPropBits   = false,
  dumpAuxLists   = false, -- write connectivity
  dumpBoundaries = false, -- write boundary elements information to dbgUnit

   dumpDependencies = false, -- write Ghost and Source elements to dbgUnit
  debugDependencies = false, -- write interpolation matrix
  checkDependencies = false, -- write neighbor informaiton

  dumpState     = false,
  dumpHaloState = false,

  checkNans = false,
  checkSteps = false,

  debugMesh = false,
  debugSource = false,
  debugRestart = false,

  traceMemory = false

  ,logging = { level=1, filename = 'dbg', root_only = false },
}

physics = { dt = dt, rho0 = 1.0, mass = 1.0 }
  interpolation_method = { method = intp }
  identify = {
    label = scheme_label,
    kind = kind,
    relaxation = relaxation,
    layout = layout,
  } -- identify table

  fluid = { omega = omega }
  initial_condition = {
    pressure  = ic_pressure,
    velocityX = ic_velocityX,
    velocityY = ic_velocityY,
    velocityZ = 0.0,
    Sxx = ic_Sxx,
    Syy = ic_Syy,
    Szz = 0.0,
    Sxy = 0.0,
    Syz = ic_Syz,
    Sxz = ic_Sxz,
  } -- intitial condition end

  tracking = {
    -- { -- Average Kinetic energy (KE) spatial
    --  label = 'L'..level..'_total_density',
    --  variable = { 'density' },
    --  reduction = { 'sum' },
    --  folder = './',
    --  shape = { kind = 'all' },
    --  output = { format = 'ascii' },
    --  time_control = { min={iter=tmax}, max={iter=tmax}, interval={iter=1},},
    -- },
    {
     label = 'point_density',
     variable = { 'density' },
     -- reduction = { 'sum' },
     folder = './',
     shape = {
       kind = 'canoND',
       object  = { origin = { L/2, L/2, L/2 }, },
     },
     output = { format = 'ascii' },
     time_control = { min={iter=tmax}, max={iter=tmax}, interval={iter=1},},
    },
--    {
--     label = 'vtk',
--     variable = { 'density' },
--     -- reduction = { 'sum' },
--     folder = './',
--     shape = {
--       kind = 'all',
--     },
--     output = { format = 'vtk' },
--     time_control = { min={iter=tmax}, max={iter=tmax}, interval={iter=1},},
--
--    }
  } -- track table
