require 'common'

sim_control = {
  time_control = {
    max = { iter = tMax },
    interval = { iter = tMax/8 },
    check_iter = 64,
  },
  abort_criteria = { steady_state = false, },
}

ebug = {
  debugMode = true,
  debugFiles = true,

  dumpTreeIDs    = false,
  dumpPropBits   = false,
  dumpAuxLists   = false, -- write connectivity
  dumpBoundaries = false, -- write boundary elements information to dbgUnit

  logging = {level=1, filename = 'dbg', root_only = false, },
}

physics = { dt = dt, rho0 = rhoPhy }
interpolation_method = { method = intp, }
fluid = { omega = omega, rho0 = rhoPhy }
variable = {
  { name = 'vel_x', ncomponents = 1, vartype = 'st_fun', st_fun  = U, },
  { name = 'vel_y', ncomponents = 1, vartype = 'st_fun', st_fun  = 0.0, },
  { name = 'vel_z', ncomponents = 1, vartype = 'st_fun', st_fun  = 0.0, },
  { name = 'inlet_vel', ncomponents = 3, vartype = 'operation',
    operation = { kind = 'combine', input_varname = {'vel_x','vel_y','vel_z'}, },
  },
  { name = 'outlet_p', ncomponents = 1, vartype = 'st_fun', st_fun  = 0.0, },
}

identify = { layout = layout, relaxation = relaxation, kind = kind, }

initial_condition = {
  pressure  = p0, velocityX = 0, velocityY = 0.0, velocityZ = 0.0,
  Sxx = 0, Syy = 0, Szz = 0, Sxy = 0, Syz = 0, Sxz = 0,
}

boundary_condition = {
  { label = 'inlet', kind = inlet_kind, velocity = 'inlet_vel', },
  { label = 'outlet', kind = outlet_kind, pressure = 'outlet_p', },
  { label = 'side', kind  = 'wall_libb', velocityX = U, velocityY = 0, velocityZ = 0,},
  { label = 'cylinder', kind  = 'wall_libb', },
}
tracking ={
  {
   label = 'global_density',
   variable = { 'density' },
   reduction= { 'sum' },
   folder = './',
   shape = { kind = 'global', },
   output = { format = 'ascii' },
   time_control = { min={iter=tMax}, max={iter=tMax}, interval={iter=1},},
  },
  
}
