-- Musubi configuration file. 
-- This is a LUA script.

-- Simulation name
simulation_name = 'twolevel'
mesh = 'mesh/2level_l23/' -- Mesh information

-- physics setting
rho0      = 1.0             -- Rest density
omega     =  1.8 -- relaxation time Omega

-- Initial condition 
initial_condition = { 
density = {predefined='gausspulse', 
center={5.125,3.125, 3.125}, 
halfwidth=1.5, 
amplitude=1.20, 
background=1.000}, 
                      velocityX = 0.01,
                      velocityY = 0.02,
                      velocityZ = 0.0 }

-- Boundary conditions
boundary_condition = {  
--{ label = 'movingwall', 
--  kind = 'inlet_ubb', 
--  velocityX = 0.03, velocityY = 0.0, velocityZ = 0.0 },
--{ label = 'fixedwall', 
--   kind = 'wall', 
--   velocityX = 0.0, velocityY = 0.0, velocityZ = 0.0 }
}

                     
-- Time step settings
tmax           =  1     -- total iteration number
check_interval =  tmax/1   -- iteration check interval

-- Output settings
output = { active = true, -- VTK output activated?
  folder = 'output/',     -- Output location
  vtk = true,             -- VTK output activated?
  dumpGhosts = true,             -- VTK output activated?
  interval = 1,     -- output interval 
  tmin = 0,               -- first iteration to output
  tmax = -1 }             -- last iteration to output

-- Tracking              
tracking = {
{ label = 'probe_wss', 
	variables = {'density'}, 
  type='point', point ={0.0,1.0,1.0},
  interval = 1, tmin = 0, tmax = -1 } 
  }


