-- get input arguments for 
-- refinement level (5, 6, 7)
ref_level = 7
-- and diffusion coefficient (0.0007, 0.00005)
D = 0.0007

-- length of the bounding cube in physical units (1m)
L_phy = 1.

-- real simulated time (50000s)
--t_phy = 500.
t_phy = 5.

-- diffusion coefficient (1.76 * 10^(-5) m^2/s)
D_phy = 1.76 * 10^(-5)

-- calculate the dx in m
dx = L_phy / (2^ref_level)

-- calculate the dt in s
dt = D / D_phy * dx^2

-- number of iterations
nIter = math.ceil(t_phy / dt)

-- check intervalls
checkInter = math.ceil(1000./t_phy * nIter)
error_check_inter = math.ceil(100./t_phy * nIter)
