-- Use this file as template. Do not modify this file for running some testcases
height =  0.41
nHeight = 16
l_h = 2
nLength = nHeight*l_h 
dx = height/nHeight
length = nLength*dx
nLength_bnd = nLength+2
level = math.ceil(math.log(nLength_bnd)/math.log(2))
length_bnd = (2^level)*dx

dx_eps = length_bnd/2^20
dx_half = dx*0.5
zpos = dx_half

refineLevel = level
refineLength = length
refinePatch = true
if refinePatch then
  refineLevel = level+1
end

folder = 'mesh/'--..subprefix
ebug = {debugMode = true, debugFiles=true}

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = {-dx/1.,-dx/1.,-dx/1.},
               length = length_bnd}

minlevel = level

spatial_object = {
  {
    attribute = {
      kind = 'seed',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { dx, height*0.5, zpos },
        }
    }
  },
  {
    attribute = {
      kind = 'refinement',
      level = refineLevel
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { length/2.,0.0,-dx_eps },
        vec = {{refineLength,0.0,0.0},
               {0.0,height/3.0,0.0},
               {0.0,0.0,dx+2*dx_eps}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'north',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { -dx/2,height+dx_eps,-dx/2 },
        vec = {{length+2*dx,0.0,0.0},
               {0.0,0.0,2.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'south',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx/2.0,-dx_eps,-dx/2.0},
        vec = {{length+2*dx,0.0,0.0},
               {0.0,0.0,2.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'east'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {length+dx_eps,-dx/2.0,-dx/2.0},
        vec = {{0.0,height+2*dx,0.0},
               {0.0,0.0,2.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'west'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx_eps,-dx/2.0,-dx/2.0},
        vec = {{0.0,height+2*dx,0.0},
               {0.0,0.0,2.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'periodic',
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = {dx_eps, dx_eps, dx+dx_eps},
          vec = {{length-2*dx_eps,0.0,0.0},
               {0.0,height-2*dx_eps,0.0}}
        },  --- plane1
        plane2 = {
          origin = {dx_eps,dx_eps,-dx_eps},
          vec = {{0.0,height-2*dx_eps,0.0},
                 {length-2*dx_eps,0.0,0.0}}
        } --- plane2        
      }  
    }
  }
}


