require "common"
-- Musubi configuration file. 
-- This is a LUA script.

-- Simulation name
mesh = 'mesh/' -- Mesh information
debug = {debugMode = true, debugFiles = true}


-- Time step settigs
tmax           =  tMax     -- total iteration number
interval = tMax
time = {useIterations = true,
        min = 1, max = tmax, interval = tmax/10}

fluid = { omega = omega, rho0 = 1.0 }


-- Initial condition 
initial_condition = { density = 1.0, 
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 }
label = label..'_l'..level

simulation_name = label
if refinementLevel > 0 then
  label = label..interpolation_method
end

identify = {label = label, layout='d2q9'}
-- Boundary conditions
boundary_condition = {  
{ label = 'west', 
  kind = 'inlet_ubb', 
  velocityX = { kind = 'combined',
                temporal = {predefined='smooth', min_factor = 0.0, max_factor=0.01, from_time=0, to_time=tmax/4}, 
                spatial = {predefined='parabol', 
                          shape = { kind = 'canoND', object = {
                                                        --halfvec = {0.0,height*0.5,0.0},
                                                        --center  = {-length*0.5,-0.0,0.0}
                                                        origin  = {-0.5*length,-height*0.5,0.0},
                                                        vec = {0.0,height,0.0} 
                                                        } 
                                  }
                         }         
                                    
	      },
   velocityY = 0.0, velocityZ = 0.0},
{ label = 'east',
   kind = 'outlet_pab',
   density =  1.0}, 
{ label = 'north', 
   kind = 'wall' },
{ label = 'south', 
   kind = 'wall' },
--{ label = 'top', 
--   kind = 'wall' },
--{ label = 'bottom', 
--   kind = 'wall' }
 }


-- Output settings
output = { active = true, -- VTK output activated?
  folder = './output/',     -- Output location
  vtk = false,             -- VTK output activated?
  wss = true, 
  dumpGhosts = true, 
  time = {min = 0, max = -1, interval = interval}
}

-- Tracking              
tracking = {{
  label = 'probePressure', 
 variable = {'density'}, 
 shape = {kind = 'canoND', object = {origin ={0.0,0.,0.} } },
 time = {min = 1, max = -1, interval = 5},
  format = 'ascii', folder = './tracking/'      
 }, 
{
  label = 'velX', 
 variable = {'velocity', 'shearstress'}, 
 shape = {kind = 'canoND', object = {origin ={ 0.0,-height*0.5,0.}, vec={0., height, 0.}, segments = 2*nElemsMax } },
 time = {min = 1, max = -1, interval = interval},
  format = 'asciiSpatial'      , folder = './tracking/'      
 },
{
  label = 'pressCutY', 
 variable = {'density'}, 
 shape = {kind = 'canoND', object = {origin ={0., -height*0.5,0.,0.}, vec={0., height, 0.}, segments = 2*nElemsMax } },
 time = {min = 1, max = -1, interval = interval},
  format = 'asciiSpatial'      , folder = './tracking/'      
 }
,
{
  label = 'pressCutX', 
 variable = {'density', 'shearstress'}, 
 shape = {kind = 'canoND', object = {origin ={-length*0.5,0.,0.}, vec={length, 0., 0.}, segments = 2*nElemsMax } },
 time = {min = 1, max = -1, interval = interval},
  format = 'asciiSpatial'      , folder = './tracking/'      
 }
 }
