-- Musubi configuration file. 
-- This is a LUA script.

-- load lua variables from simParam.lua
require 'common'
scheme_kind = 'lbm_incomp'

-- Simulation name
simulation_name = 'spacer'

-- communication reduced
comm_reduced = true

-- control routine
control_routine = 'debug'

ebug = false
-- Mesh information
mesh = {
  meshDir = 'mesh/',
  --weights = 'balance/0001_weights.lsb'
}

--i/o buffer size 
io_buffer_size = 1
-- print runtime info
printRuntimeInfo = true

commpattern = 'isend_irecv_overlap'

interpolation_method = 'average'

velocity_bc = {predefined ='combined',
               temporal = {predefined='smooth', min_factor = 0.0, max_factor=1.0, 
                           from_time=0, to_time=10000*dt} 
              ,spatial = {predefined='parabol', 
                          shape = {kind='canoND', 
                                   object={origin={.0,0.0,0.0},
                                           vec={0.0,h_ch,0.0}
                                   } 
                          },
                          amplitude = {u_max_phy, 0.0,0.0}
               }
}

tmax = 2000
tmax_p = tmax*dt

spacer_bc = 'wall'
NOdebug ={
  logging ={ level=5, filename = 'dbg', root_only=false},
  debugMode = true,
  debugFiles = true,
  dumpTreeIDs = false,
  dumpPropBits = false,
  dumpAuxLists = true,
  dumpBoundaries = false,
  dumpDependencies = false,
  dumpState = true,
  dumpHaloState = true,
  checkNans = true,
  checkSteps = true
}
logging = {level=1}

-- Time step settings
sim_control = {
  time_control = {
    check_iter = 1,
    interval = {iter=1},
    max = {iter=2},   -- run for 60 sec = 1 min
  }
}  

bal_tmin = 10
bal_tmax = 100-bal_tmin
bal_interval = (bal_tmax-bal_tmin)/3.0
--The load balancing table defines the kind of balancing we want to have as 
--well as the intervals during which we wish to have load balances. For example, 
--in the representative case below, the load balancing is performed for the first
--time at the 3rd time step and then this is performed after every 4th time step
NObalance = { static = false, dynamic = true, kind = 'boundary',
           logging = {level=3, root_only=true, filename='balance/log'},
           time_control = { 
             check_iter = 10,
             min = {iter=bal_tmin}, 
             interval = {iter=bal_interval}, 
             max = {iter=bal_tmax} 
           },
           folder = 'balance/'
}
-- physics setting
physics = { rho0 = rho0_p, dt = dt, moleDens0 = 1000.0 }

-- Initial condition 
fluid_ic = { 
   pressure = p0_p,
   velocityX = 0.0,
   velocityY = 0.0,
   velocityZ = 0.0}
-- Boundary conditions
fluid_bc = {
   { kind = 'outlet_expol',
     pressure = p0_p,
     label = 'outlet'},
   { kind = 'inlet_ubb',
     label = 'inlet',
     velocity = velocity_bc,
   },
   { label = 'left', kind = 'wall'},
   { label = 'right', kind = 'wall'},
   { label = 'north', kind = 'wall'},
   { label = 'south', kind = 'wall'},
   { label = 'spacer', kind = spacer_bc}
 }

timing_file = 'timing_scheme_'..scheme_kind..'.res'

scheme={
 identify = { kind = scheme_kind,relaxation='bgk'}
-- physics setting
 ,fluid = { omega = omega, rho0 = rho0_p }
-- Initial condition
 ,initial_condition = fluid_ic 
-- boundary condition
 ,boundary_condition = fluid_bc
-- tracking 
 ,NOtracking = {
    {
      folder = 'tracking/',
      label = 'point',
      variable = {'pressure_phy', 'velocity_phy'},
      shape = { kind = 'canoND', 
                object = { 
                  origin = {l_ch/2.0, h_ch/2.0, w_ch/2.0}
                }
      },
      output = {format = 'ascii'},
      time_control = {min =0, interval = {iter=100}}
    }
 }
}     

restart = {
  write = 'restart/'
}
