simulation_name = 'Small_channel'
-- Mesh information
-- meshfolder = 'mesh/inlet/'  
task = 'mesh'
meshfolder = 'mesh/'


output = { ascii = false, vertex=true,
           folder = 'output/',     -- Output location
           interval = 1,           -- output interval 
           tmin = 0,               -- first iteration to output
           tmax = 10 }             -- last iteration to output
 
restart = {read = { folder = 'tracking/',     -- restart folder
                    file_name = 'lastHeader.lua'}}


states = { 
  state1 = { folder = '../restart/', name = 'gausspulse*', kind = 'fluid' },
  -- check 'globbing' within lua. -> list of files will be given
  state2 = { folder = '../restart/', name = 'wall*', kind = 'solid'}
 }

outputregion = { region1 = { geometry = 'bounding box', bounding_box = {origin ={0.,0.,0.}, length = 100.  } },
                 region2 = { geometry = 'all' }, 
                 region3 = { geometry = 'plane', plane = { origin = {0.,0.,0.}, normal = {1.,0.,0.} } }
}

MHoutput = { 
         { region = region1,
           format = 'VTK', kind='tree_glyph',
           interval = 0, tmin = 0., tmax = 1000.,
           variables = {'pressure','velX','velY','velZ'} }

}
