#!/usr/bin/env python

# import modules #
import os,re,subprocess
import sys, shutil, stat
Exe= "Exe"

# define list to store inputs #
blk_factor = []

param_file = open("param.lst", "r")
param_list = param_file.read()
param_file.close()

# read data from param.lst and store it in blk_factor #
Blocking_factor = re.findall(r"Blk_factor.*$", param_list,re.MULTILINE)
for x in Blocking_factor:
        blocking = re.split(r"=", x)
        blk_factor = re.split(r"\s", blocking[1])
        print blk_factor

# exit if can not find the exe folder #
if not os.path.isdir(Exe):
    print "Error: Cannot find Exe folder"
    sys.exit(-1)

# make separate folder for each blocking factor given in param.lst # 
for blocking in blk_factor:
        print os.path.abspath(".")
        if not os.path.exists("data/" + blocking):
                os.mkdir("data/" + blocking)

	parfiles = os.listdir("modelcase/")
        for file in parfiles:
                shutil.copy("modelcase/" + file, "data/" + blocking)



	preproc = open("data/" + blocking + "/preproc.par","w")
        preproc.write("&PREPINP\n")
        preproc.write(" LX    = 200                   ,\n")
        preproc.write(" LY    = 50                     ,\n")
        preproc.write(" LZ    = 50                    ,\n")
        preproc.write(" P_XY  = T                     ,\n")
        preproc.write(" P_XZ  = T                     ,\n")
        preproc.write(" P_YZ  = T                     ,\n")
        preproc.write(" X_OFF = 0                     ,\n")
        preproc.write(" Y_OFF = 0                     ,\n")
        preproc.write(" Z_OFF = 0                     ,\n")
        preproc.write(" CASENME = \"input\" , \n")
        preproc.write(" IS_FLUID = F                  ,\n")
        preproc.write(" COMPRESS_PRP = F              ,\n")
        preproc.write(" BLOCKINGFACTOR = " + blocking + "  ,\n")
        preproc.write("/")
        preproc.close()




        os.chdir("data/" + blocking)

        subprocess.call("./../../Exe/preproc.x86_64-em64t-mpi", shell=True )
        subprocess.call("./../../Exe/vector.x86_64-em64t-mpi", shell=True )
        os.chdir("../..")


        pathname = os.getcwd()
        print 'Current Dirctory =',pathname


