-- Musubi configuration file. 
-- debug 
-- This is a LUA script.
commpattern = os.getenv('cpat')
debug = {debugActive = true, debugFiles = true, traceMemory = true}

-- Mesh information
-- mesh = 'mesh/mesh_2M/'
mesh = { predefined = 'cube',
         origin = {0.0, 0.0, 0.0},
         length = 10.0,
         refinementLevel = os.getenv('level')
       }

identify = {
            label = 'global',
            kind = 'lbm',
            relaxation = 'bgk',
            layout = 'd3q19'
           }
fluid = { omega = 1.8, rho0 = 1.0 }

-- Simulation name
simulation_name = identify.relaxation .. '-' .. commpattern


-- Initial Case
initial_condition = { 
                     density = {predefined='gausspulse', 
                                center={5.0, 5.0, 5.0}, 
                                halfwidth=1.0, 
                                amplitude=1.20, 
                                background=1.000}, 
                    velocityX = 0.0,
                    velocityY = 0.0,
                    velocityZ = 0.0
                   }

interpolation_method = 'linear'                     

-- Time step settings
nprocs = os.getenv('nprocs')
-- total number of iterations
tmax           = math.min(((8^ 9)*nprocs) / (8^ mesh.refinementLevel), 1000000)
tmax = 1
time = {useIterations = true, -- Timings given in iterations? default: true
        max = tmax,           -- Maximal iteration to reach
        interval = tmax,     -- Interval for checking density
        min = 1 }              -- Minimal timestep to start from

-- Ramping settings  
ramping        = false

-- Output settings
output = { active = false,
           vtk = true,     -- VTK output activated?
           interval = -1,        -- output interval 
           tmin = 0,         -- first iteration to output
           tmax = 0 } 
-- Restart settings
restart = {
  -- If this table is available it will write a restart file
  -- with the specified options.
--  write = {
--    folder    = 'restart/', -- the folder the restart files are written to
--    interval  = 1,                                     -- dump restart file interval
--    tmin      = tmax+1,                                   -- first timestep to output
--    tmax      = tmax+1                                    -- last timestep to output
--    }
  }
