require "common"

sim_control = {
  time_control = {
    max = { iter = tmax },
    interval = { iter = tmax / 10 },
  },
}

physics = { dt = dt, rho0 = rhoPhy }
scheme = {
  interpolation_method = { method = intp },
  identify = {
    label = scheme_label,
    kind = kind,
    relaxation = relaxation,
    layout = layout,
  }, -- identify table

  fluid = { omega = omega, rho0 = rhoPhy },
  initial_condition = {
    pressure  = ic_pressure,
    velocityX = ic_velocityX,
    velocityY = ic_velocityY,
    velocityZ = 0.0,
    Sxx = ic_Sxx,
    Syy = ic_Syy,
    Szz = 0.0,
    Sxy = 0.0,
    Syz = ic_Syz,
    Sxz = ic_Sxz,
  }, -- intitial condition end

  racking = {
    { -- Average Kinetic energy (KE) spatial
     label = 'L'..level..'_ke',
     variable = { 'kinetic_energy_phy', 'density' },
     reduction = {'sum','sum'},
     folder = 'tracking/',
     shape = { kind = 'all' },
     output = { format = 'ascii' },
     time_control = { min = 0, max = tEnd, interval = dt, },
    },
  } -- track table
} -- scheme table
