import os
prod_dir = 'performance'

# empty job list
shepherd_jobs = []

# musubu parameters
shepherd_jobs.append(dict(executable=os.getenv("HOME")+'/apes/musubi/build/musubi',
                     # path to template file to generate input for exectuable
                     # using pyratemplate
                     template='musubi.template',
                     # extension of input file
                     extension='lua',
                     run_exec = False,
                     # exit shepherd if run job fails
                     # default is False
                     abort_failure = True,
                     run_command = '',
                     params = [
                      # relaxation specifies the compute kernel MUSUBI will use
                      ['relaxation', 'bgk'],
                      # level specifies number of elements inside a mesh
                      # which equals to 8^level
                      ['level', 6, 7, 8, 9 ],
                     ],
                     prefix = 'MUSUBI',
                     create_depend_path = False,
                     create_depend_params = False,
                     label = 'musubi'))

# job scripts
shepherd_jobs.append(dict(executable=None,
                     # path to template file to generate input for exectuable
                     # using pyratemplate
                     template='sx_ace.template',
                     # extension of input file
                     extension='sh',
                     run_exec = True,
                     # exit shepherd if run job fails
                     # default is False
                     abort_failure = True,
                     # the command to submit jobs
                     run_command = 'qsub',
                     params = [
                      ['nNodes', 1, 2, 4, 8, 16, 32, 64],
                     ],
                     prefix = 'SX',
                     # list of dependent jobs
                     depend = ['musubi'],
                     # to use depend job path in this job template file
                     # default is False
                     create_depend_path = True,
                     # to use depend job params in this job template file.
                     # default is False
                     create_depend_params = True,
                     label = 'sx-ace'))
#-------------------------------------------------------------------------------
