require "common"

simulation_name = 'trt_block'
block = os.getenv("BLOCK")
tmax = 1024
sim_control = {
  time_control = {
    max = { iter = tmax },
    interval = { iter = tmax },
  }
}

physics = { dt = dt, rho0 = rhoPhy }

scheme = {
  identify = {
    label = 'd3q19',
    kind = 'lbm',
    relaxation = 'trt_block',
    layout = 'd3q19',
  }, -- identify table

  fluid = { omega = omega, rho0 = rhoPhy },

  -- Initial condition for each field
  initial_condition = {
    pressure  = ic_pressure,
    velocityX = ic_velocityX,
    velocityY = ic_velocityY,
    velocityZ = 0.0,
    Sxx = ic_Sxx,
    Syy = ic_Syy,
    Szz = 0.0,
    Sxy = 0.0,
    Syz = ic_Syz,
    Sxz = ic_Sxz,
  }, -- intitial condition end

} -- scheme table
