require "common"

sim_control = {
  time_control = {
    max = { iter = 1000 },
    interval = { iter = 1000 },
  }
}

physics = { dt = dt, rho0 = rhoPhy }
logging = { level = 1 }

scheme = {
  identify = {
    label = scheme_label,
    kind = kind,
    relaxation = relaxation,
    layout = layout,
  }, -- identify table

  fluid = { omega = omega, rho0 = rhoPhy },

  -- Initial condition for each field
  initial_condition = {
    pressure  = ic_pressure,
    velocityX = ic_velocityX,
    velocityY = ic_velocityY,
    velocityZ = ic_velocityZ,
    Sxx = ic_Sxx,
    Syy = ic_Syy,
    Szz = 0.0,
    Sxy = ic_Sxy,
    Syz = 0.0,
    Sxz = 0.0,
  }, -- intitial condition end

} -- scheme table
