require "common"
simulation_name = 'nonNewtonian'

sim_control = {
  time_control = {
    max = { iter = tmax },
    interval = { iter = tmax/10 }
  },
  abort_criteria = {
    stop_file = 'stop',
    steady_state = false
  }
}   -- sim_control

logging = {
  level = 1,
  --filename = simulation_name..'.log',
  root_only = false,
  real_form = 'EN5.3',
  int_form = 'I6',
} -- logging

physics = {
  dt = dt,
  rho0 = densityPhy,
} -- physics table

scheme = {
  { -- scheme 1: CY model
    fluid = {
      omega = omega,
      rho0 = densityPhy,
      nonNewtonian = {
        model = nNwtn,
      },
    },

    identify = {
      label = nNwtn..'_L_'..level..'_n_'..n..'_Re_'..Reynolds,
      kind = 'lbm_nNwtn',
      relaxation = 'bgk_cy',
      layout = 'd3q19',
    },

    initial_condition = {
      pressure = p0Phy,
      velocityX = velA, velocityY = 0.0, velocityZ = 0.0,
      Sxx = 0, Syy = 0, Szz = 0, Sxy = strainRateA, Syz = 0, Sxz = 0,
      omega = omega,
    },

    boundary_condition = {
      { label = 'outlet',kind = 'outlet_expol', pressure = p0Phy, }, -- outlet
      { label = 'top_wall', kind = 'wall'},
      { label = 'bottom_wall', kind = 'wall'},
      {
        label = 'inlet',
        kind = 'inlet_ubb',
        velocityX = {
          predefined = 'combined',
          temporal= {
            predefined = 'smooth',
            min_factor = velMaxPhy,
            max_factor = velMaxPhy,
            from_time  = 0,
            to_time    = tmaxPhy/4,
          },
          spatial = {
            predefined='parabol',
            shape = {
              kind = 'canoND',
              object = {
                origin = { -length/2+dx, -R, dx/2},
                vec = { 0.0, 2*R, 0.0 }
              }
            } -- shape table
          } -- spatial table
        }, -- velX table
        velocityY = 0.0,
        velocityZ = 0.0,
      } -- inlet table
    }, -- boundary table
  }, -- end of scheme 1
} -- scheme table
