-- Musubi configuration file. 
require "seeder"

--flow parameters
nu_phy = 1.49e-5 --m^2/s
rho0_p = 1.204 --kg/m^3
u_inlet_phy = 25.55 -- m/s
Re = u_inlet_phy*l_chord/nu_phy

--acoustic scaling
u_inlet_L = 0.05
dt = u_inlet_L*dx/u_inlet_phy
nu_L = nu_phy*dt/dx^2.
omega = 1.0/(3.0*nu_L+0.5)

press_p = 101325 -- Pa  
output_freq = 1.0/51200

function u_inflow(x,y,z,t) 
  return {4.0*u_inlet_phy*(h_nozzle*0.5+y)*(h_nozzle*0.5-y)/(h_nozzle)^2.0,0.0,0.0}
end

tracking_fol = 'tracking/'
restart_fol = 'restart/'

-- Simulation name
simulation_name = 'Airfoil'
mesh = 'mesh/' -- Mesh information
printRuntimeInfo = false
scaling = 'acoustic'
comm_reduced = false
timing_file = 'mus_timing.res'
interpolation_method = 'quadratic'

io_buffer_size = 10 -- default is 80 MB

wall_clock = 24*60*60 - 30*60
-- Time step settigs
tmax = 0.2 -- real time in seconds
t_ramp = 0.1 -- sec
sim_control = {
  time_control = { 
    max = {sim=tmax, clock=wall_clock},
    interval = {iter=10000}
  } -- time control
 ,abort_criteria = {
    stop_file = './stop'
  }  
} -- simulation control

logging = {level=5}
NOdebug = {logging={level=10,filename = 'dbg', root_only=true}}

-- needed to dump variable in physical unit
physics = { dt = dt, rho0 = rho0_p }

fluid = { 
  omega_ramping = { 
     predefined = 'smooth',
     min_factor = 0.75, max_factor = 1.0,
     from_time = 0, to_time = t_ramp
  },
  omega = omega
}

-- Initial condition 
initial_condition = { pressure = press_p, 
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 }

identify = {layout='d3q27',kind='lbm', relaxation = 'bgk_les'}

-- Boundary conditions
boundary_condition = {  
  { label = 'inlet', 
    kind = 'inlet_eq', 
    velocity = {
      predefined = 'combined',
      temporal  = {
        predefined = 'smooth',
        min_factor = 0.0, max_factor = 1.0,
        from_time = 0, to_time = t_ramp
      },
--      spatial = {u_inlet_phy,0.0,0.0} 
      spatial = u_inflow
--      spatial = { 
--        predefined='parabol', 
--        shape = { 
--          kind = 'canoND', 
--          object = { 
--            origin={xrange[1]-nozzle_airfoil_gab-l_nozzle, -h_nozzle/2.0, 0.0},
--            vec={0.0,h_nozzle,0.0}
--          }
--        },
--        amplitude = {u_inlet_phy,0.0,0.0} 
--      }
    }  
  },
  { label = 'outlet',
     kind = 'outlet_pab',
     pressure = press_p }, 
  { label = 'wall_side', 
    kind = 'wall' },
  { label = 'wall_nozzle', 
     kind = 'wall_libb' },
  { label = 'airfoil', 
     kind = 'wall_libb' },
}
-- user variables
variable = {
  {
    name = 'p0',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = press_p, 
  },
  {
    name = 'press_fluc',
    ncomponents = 1,
    vartype = 'operation',
    operation = { 
      kind = 'difference',
      input_varname = {'pressure_phy', 'p0'}
    }
  },
  {
    name = 'press_avg',
    ncomponents = 1,
    vartype = 'operation',
    operation = {
      kind = 'reduction_transient',
      input_varname = {'press_fluc'},
      reduction_transient = {
        kind = 'average',
        nrecord = math.ceil(output_freq/dt)
      }
    }
  },
  {
    name = 'vel_avg',
    ncomponents = 3,
    vartype = 'operation',
    operation = {
      kind = 'reduction_transient',
      input_varname = {'velocity_phy'},
      reduction_transient = {
        kind = 'average',
        nrecord = math.ceil(output_freq/dt)
      }
    }
  }
}

-- Tracking
tracking = {
  {
    label = 'probe_inlet', 
    folder = tracking_fol,
    variable = {'press_fluc','velocity_phy'}, 
    shape = {
      kind = 'canoND', 
      object = {
        { origin ={xrange[1]-nozzle_airfoil_gab-l_nozzle+dx/2.0,
                   0.0, w_ch/2.0} },
      },
    },
    time_control = {min = 0, max = tmax, interval = output_freq},
    output={format = 'ascii', use_get_point=true}
  },
  {
    label = 'probe_Mic2c_WT', 
    folder = tracking_fol,
    variable = {'press_fluc','velocity_phy','vel_avg','press_avg'}, 
    shape = {
      kind = 'canoND', 
      object = {
        { origin ={0.002488809076183, 0.422172317914410, w_ch/2.0} },
      }  
    },
    time_control = {min = 0, max = tmax, interval = output_freq},
    output={format = 'ascii'}
  },
  {
    label = 'probe_Mic2c_EB', 
    folder = tracking_fol,
    variable = {'press_fluc','velocity_phy','vel_avg','press_avg'}, 
    shape = {
      kind = 'canoND', 
      object = {
        { origin ={0.197601225136478, -0.421772479230869, w_ch/2.0} },
      }  
    },
    time_control = {min = 0, max = tmax, interval = output_freq},
    output={format = 'ascii'}
  },
  {
    label = 'probe_Mic2c_ET', 
    folder = tracking_fol,
    variable = {'press_fluc','velocity_phy','vel_avg','press_avg'}, 
    shape = {
      kind = 'canoND', 
      object = {
        { origin ={0.197601225136478, 0.378227520769131, w_ch/2.0} },
      }  
    },
    time_control = {min = 0, max = tmax, interval = output_freq},
    output={format = 'ascii'}
  },

  {
    label = 'probe_Mic2_5c_WT', 
    folder = tracking_fol,
    variable = {'press_fluc','velocity_phy','vel_avg','press_avg'}, 
    shape = {
      kind = 'canoND', 
      object = {
        {origin ={0.002488809076183, 0.522172317914410, w_ch/2.0}},
      }  
    },
    time_control = {min = 0, max = tmax, interval = output_freq},
    output={format = 'ascii'}
  },
  {
    label = 'probe_Mic2_5c_EB', 
    folder = tracking_fol,
    variable = {'press_fluc','velocity_phy','vel_avg','press_avg'}, 
    shape = {
      kind = 'canoND', 
      object = {
        {origin ={0.197601225136478, -0.521772479230869, w_ch/2.0}},
      }  
    },
    time_control = {min = 0, max = tmax, interval = output_freq},
    output={format = 'ascii'}
  },
  {
    label = 'probe_Mic2_5c_ET', 
    folder = tracking_fol,
    variable = {'press_fluc','velocity_phy','vel_avg','press_avg'}, 
    shape = {
      kind = 'canoND', 
      object = {
        {origin ={0.197601225136478, 0.478227520769131, w_ch/2.0}},
      }  
    },
    time_control = {min = 0, max = tmax, interval = output_freq},
    output={format = 'ascii'}
  },

  {
    label = 'probe_Mic1_5c_WT', 
    folder = tracking_fol,
    variable = {'press_fluc','velocity_phy','vel_avg','press_avg'}, 
    shape = {
      kind = 'canoND', 
      object = {
        {origin ={0.002488809076183, 0.322172317914410, w_ch/2.0}},
      }  
    },
    time_control = {min = 0, max = tmax, interval = output_freq},
    output={format = 'ascii'}
  },
  {
    label = 'probe_Mic1_5c_EB', 
    folder = tracking_fol,
    variable = {'press_fluc','velocity_phy','vel_avg','press_avg'}, 
    shape = {
      kind = 'canoND', 
      object = {
        {origin ={0.197601225136478, -0.321772479230869, w_ch/2.0}},
      }  
    },
    time_control = {min = 0, max = tmax, interval = output_freq},
    output={format = 'ascii'}
  },
  {
    label = 'probe_Mic1_5c_ET', 
    folder = tracking_fol,
    variable = {'press_fluc','velocity_phy','vel_avg','press_avg'}, 
    shape = {
      kind = 'canoND', 
      object = {
        {origin ={0.197601225136478, 0.278227520769131, w_ch/2.0}},
      }  
    },
    time_control = {min = 0, max = tmax, interval = output_freq},
    output={format = 'ascii'}
  },
}


-- restart 
restart = {
  NOread = restart_fol..simulation_name..'_lastHeader.lua',
  write = restart_fol,
  time_control = { min = tmax, max = {sim=tmax,clock=wall_clock}, interval = tmax}
}

