-- Configuration for airfoilS384.
-- All dimension are in meters

-- Airfoil domain
xrange = {2.42e-3, 198e-3}
yrange = {-22.2e-3, 28.3e-3}
zrange = {0, 15e-3}

-- Simulation domain
-- length of airfoil
l_airfoil = xrange[2]-xrange[1]
-- chord length of airfoil 
l_chord = 0.2 -- meter
-- Front nozzle length
l_nozzle = 800e-3*0.50
-- Front nozzle height
h_nozzle = 266e-3
-- gab betweeen nozzle end and airfoil start
nozzle_airfoil_gab = 100e-3

-- length of free flow area
l_free_flow = 1500e-3*0.50
-- height of free flow area 
h_free_flow = 2800e-3*0.5
-- length of the simulation domain
l_ch = l_nozzle+l_free_flow
-- height of the simulation domain
h_ch = h_free_flow
-- width of the simulation domain
w_ch = 18e-3--zrange[2]-zrange[1]
-- largest element size
dx = w_ch/4.0--dx_airfoil*2^element_ratio
dx_level = {w_ch, w_ch/2.0, w_ch/4.0, w_ch/8.0, 
            w_ch/16.0, w_ch/32.0, w_ch/64.0, w_ch/128.0}

refine_height=450e-3
l_max = math.max(l_ch, h_ch)
nL_max = math.ceil(l_max/dx)
nLength_bnd = 1*nL_max+2

minlevel = math.ceil(math.log(nLength_bnd)/math.log(2))
length_bnd = (2^minlevel)*dx
level_airfoil = minlevel+5
dx_airfoil = length_bnd/2^level_airfoil
level_nozzle=minlevel+0
--print(dx, dx_airfoil,nL_max)
--print(minlevel,level_airfoil)


--dx = l_max/2^minlevel
--length_bnd = l_max + 2*dx
--dx = length_bnd/2^level

eps = length_bnd/2^20
inlet_origin = {xrange[1] - nozzle_airfoil_gab - l_nozzle-dx/2, 
                -h_nozzle/2.0-dx/2.0, 
                -dx/2.0}
outlet_origin = {xrange[1] - nozzle_airfoil_gab + l_free_flow + dx/2.0, 
                 -h_free_flow/2.0-dx/2.0,
                 -dx/2.0}

bounding_origin = {xrange[1]-nozzle_airfoil_gab-l_nozzle-dx,
                  -h_free_flow/2.0-dx,
                  -dx}
qVal = true

distance_refine= {
  {
    level_offset = 0,
    radius = w_ch/4.0
  },
  {
    level_offset = -1,
    radius = w_ch/2.0
  },
  {
    level_offset = -2,
    radius = w_ch
  },
  {
    level_offset = -3,
    radius = w_ch*2
  },
  {
    level_offset = -4,
    radius = w_ch*5
  },
  {
    level_offset = -5,
    radius = w_ch*10
  },
}
angle = (15+180)*math.pi/180
folder = 'mesh/'
NOdebug = {debugMode = true, debugFiles=false, debugMesh = 'debug/'}
timing_file = 'sdr_timing.res'
logging = {level=10}

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = bounding_origin,
               length = length_bnd}


spatial_object = {
  {
    attribute = {
      kind = 'seed',   ----seed
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {xrange[1]-nozzle_airfoil_gab, 0.0, w_ch/2.0}
       --origin = { xrange[2]+l_free_flow/2.0, -h_free_flow/2.0+2*dx, w_ch/2.0 },
       -- vec = {0.0, h_free_flow-4*dx, 0.0}
      }
    }
  },
  { -- top outlet
    attribute = {
      kind = 'boundary',
      label = 'outlet'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {xrange[1]-nozzle_airfoil_gab-dx, h_free_flow/2.0+dx/2.0, -dx/2.0 },
        vec = {{l_free_flow+2*dx,0.0,0.0},
               {0.0,0.0,w_ch+2*dx}}
        }
    }
  },
  { -- bottom outlet
    attribute = {
      kind = 'boundary',
      label = 'outlet'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {xrange[1]-nozzle_airfoil_gab-dx, -h_free_flow/2.0-dx/2.0, -dx/2.0 },
        vec = {{l_free_flow+2*dx,0.0,0.0},
               {0.0,0.0,w_ch+2*dx}}
        }
    }
  },
  -- East outlet
  {
    attribute = {
      kind = 'boundary',
      label = 'outlet'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {xrange[1]-nozzle_airfoil_gab+l_free_flow+dx/2.0, -h_free_flow/2.0-dx/2.0, -dx/2.0 },
        vec = {{0.0, h_free_flow+2*dx, 0.0},
               {0.0,0.0,w_ch+2*dx}}
        }
    }
  },
  --inlet
  {
    attribute = {
      kind = 'boundary',
      label = 'inlet',
      calc_dist = true,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {xrange[1]-nozzle_airfoil_gab-l_nozzle-dx/2.0, -h_nozzle/2.0-dx/2.0, -dx/2.0 },
        vec = {{0.0, h_nozzle+2*dx,0.0},
               {0.0,0.0,w_ch+2*dx}}
        }
    }
  },
  --nozzle top, bottom and side walls
  {
    attribute = {
      kind = 'boundary',
      label = 'wall_nozzle',
      level = minlevel,
      calc_dist = true
    },
    geometry = {
      kind = 'canoND',
      object = {
        {
          origin = {xrange[1]-nozzle_airfoil_gab, -h_nozzle/2.0, -dx/2.0 },
          vec = {{-l_nozzle-2*dx,0.0,0.0},
                 {0.0,0.0,w_ch+2*dx}}
        },
        {
          origin = {xrange[1]-nozzle_airfoil_gab, h_nozzle/2.0, -dx/2.0 },
          vec = {{-l_nozzle-2*dx,0.0,0.0},
                 {0.0,0.0,w_ch+2*dx}}
        },
      }
    }
  },  
  {
    attribute = {
      kind = 'boundary',
      label = 'wall_side',
      level = minlevel,
      calc_dist = true
    },
    geometry = {
      kind = 'canoND',
      object = {
        {
          origin = {xrange[1]-nozzle_airfoil_gab-dx/2.0, -h_nozzle/2.0, -dx/2.0 },
          vec = {{0.0,-h_free_flow/2.0+2*dx,0.0},
                 {0.0,0.0,w_ch+2*dx}}
        },
        {
          origin = {xrange[1]-nozzle_airfoil_gab-dx/2.0, h_nozzle/2.0, -dx/2.0 },
          vec = {{0.0,h_free_flow/2.0+2*dx,0.0},
                 {0.0,0.0,w_ch+2*dx}}
        },
      }
    }
  },
  {
    attribute = {
      kind = 'periodic',
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = {xrange[1]-nozzle_airfoil_gab-l_nozzle-dx/2.0,
                    -h_free_flow/2.0-dx/2.0, 
                    w_ch+dx_airfoil/2.0},
          vec = {{l_ch+2*dx,0.0,0.0},
               {0.0,h_ch+2*dx,0.0}}
        },
        plane2 = {
          origin = {xrange[1]-nozzle_airfoil_gab-l_nozzle-dx/2.0,
                    -h_free_flow/2.0-dx/2.0, 
                    -dx_airfoil/2.0},
          vec = {{0.0,h_ch+2*dx,0.0},
                 {l_ch+2*dx,0.0,0.0}}
        }         
      }  
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'airfoil',
      calc_dist = qVal,
      flood_diagonal = false,
      level = level_airfoil,
      distance_refine = distance_refine
    },
    geometry = {
      kind = 'stl',
      object = {
        { filename = 'S834_aoa12pt69.stl'},
      }
    },
    transformation = {
      transformation = {0.0,0.0,-1e-3},
      deformation = {1e-3,1e-3,3e-3}
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'airfoil',
      calc_dist = qVal,
      flood_diagonal = false,
      level = level_airfoil,
    },
    geometry = {
      kind = 'stl',
      object = {
        { filename = 'S834_aoa12pt69_final_trip_PS.stl'},
        { filename = 'S834_aoa12pt69_final_trip_SS.stl'},
      }
    },
    transformation = {
      translation = {0.0,0.0,3.0e-3},
      deformation = 1e-3
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'airfoil',
      calc_dist = qVal,
      flood_diagonal = false,
      level = level_airfoil,
    },
    geometry = {
      kind = 'stl',
      object = {
        { filename = 'S834_aoa12pt69_final_trip_PS.stl'},
        { filename = 'S834_aoa12pt69_final_trip_SS.stl'},
      }
    },
    transformation = {
      translation = {0.0,0.0,-9.0e-3},
      deformation = 1e-3
    }
  },
}

--refinement box
refine_len_min=150e-3
refine_length = {refine_len_min/5, 1.0*refine_len_min, 1.5*refine_len_min,
                 2*refine_len_min, 2.5*refine_len_min, 4.0*refine_len_min}
rot_angle = {18,14.4,10.8,7.2,3.6,0,-3.6,-7.2,-10.8,-14.4,-18.0}
for ii = 1, #refine_length do
  for theta = 1, 5+ii do
    angle = (rot_angle[theta]+180)*math.pi/180
    table.insert(spatial_object,
      {
        attribute = {
          kind = 'refinement',
          level = level_airfoil-ii+1,
          only_surface = false
        },
        geometry = {
          kind = 'canoND',
          object = {
            origin = {0.0, 0.0, -dx },
            vec = { {refine_length[ii]*math.cos(angle), -refine_length[ii]*math.sin(angle), 0.0},
                    {2*distance_refine[ii].radius*math.sin(angle), 2*distance_refine[ii].radius*math.cos(angle), 0.0 },
                    {0.0, 0.0, w_ch+2*dx},
            }
          }
        },
        transformation = {
          translation = {xrange[2]+refine_length[ii], 
                         yrange[1]+refine_length[ii]*math.sin(angle)+distance_refine[ii].radius,
                         0.0},
        }
      }
    )
  end   
end

table.insert(spatial_object,
  {
    attribute = {
      kind = 'refinement',
      level = level_nozzle,
      only_surface = false
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {xrange[1]-nozzle_airfoil_gab-l_nozzle-dx/2.0, 
                  -h_ch/2.0, -dx/2.0 },
        vec = { {l_nozzle+nozzle_airfoil_gab+2*dx, 0.0, 0.0},
                {0.0, h_ch+2*dx, 0.0 },
                {0.0, 0.0, w_ch+2*dx},
        }
      }
    },
  }
)
