require 'common'

sim_control = {
  time_control = {
    max = tEnd,
    interval = tEnd/50,
  },
  abort_criteria = {
    steady_state = false,
  },
}

logging = {level=5}
debug = {logging = {level=1, filename='dbg'}}
physics = { dt = dt, rho0 = rhoPhy }

fluid = { omega = omega, rho0 = rhoPhy }

variable = {
  { name = 'coeff_fac', ncomponents = 3, vartype = 'st_fun', st_fun = {cD,cL,0} },
  { name = 'coeff',
    ncomponents = 3,
    vartype = 'operation',
    operation = {
      kind = 'multiplication',
      input_varname = { 'bnd_force_phy', 'coeff_fac' },
    },
  },
}


identify = {
  label = 'flow',
  layout = layout,
  relaxation = relaxation,
  kind = kind,
}

initial_condition = {
  pressure  = p0,
  velocityX = Ustart,
  velocityY = 0.0,
  velocityZ = 0.0,
  Sxx = 0, Syy = 0, Szz = 0, Sxy = 0, Syz = 0, Sxz = 0,
}

boundary_condition = {
  { label = 'inlet',
    kind = inlet_kind,
    velocity = {U,0.0,0.0},
    -- velocityX = {
    --   predefined = 'combined',
    --   transient = {
    --     predefined = 'smooth',
    --     min_factor = Ustart, max_factor = U,
    --     from_time = 0, to_time = tRamp },
    --   spatial = 1.0,
    --   --   predefined = 'parabol',
    --   --   shape = {
    --   --     kind = 'canoND',
    --   --     object = {
    --   --       origin = { inlet_x, bottom_y, zpos},
    --   --       vec    = {     0.0, top_y - bottom_y, 0.0 },
    --   --     },
    --   --   } -- shape table
    --   -- } -- spatial table
    -- }, -- velX table
  },
  { label = 'outlet',
     kind = outlet_kind,
     pressure = pOutlet,
  },
  { label = 'top_bottom', kind  = 'wall', },
  { label = 'front_back', kind  = 'wall', },
  { label = 'sphere',   kind  = 'wall_libb',
  },
}

tracking = {

  -- global flow domain
  { label = 'global',
    folder = 'tracking/',
    variable = {
      'pressure_phy',
      'velocity_phy',
      'velocity',
      -- 'strain_rate_phy',
    },
    shape = { kind = 'all', },
    time_control = {
      min = tEnd, max = tEnd, interval = 0.05,
    },
    output={format = 'vtk'},
  }, -- tracking global

  -- force on cylinder
  { label = 'force_on_sphere',
    folder = 'tracking/',
    variable = {
      'coeff',
      -- 'bnd_force_phy',
    },
    shape = {
      kind = 'boundary',
      boundary = { 'sphere' },
    },
    time_control = { min = tEnd-1, max = tEnd, interval = 1/100, },
    reduction = { 'sum' },
    output = {format = 'ascii'},
  }, -- tracking force on sphere

  -- velocity and pressure along channel
  { label = 'along_channel',
    folder = 'tracking/',
    variable = {
      'velocity_phy',
    },
    shape = {
      kind = 'canoND',
      object = {
        origin = { D/2,  0.0, 0.0},
        vec    = { 2*D,  0.0, 0.0},
        segments = math.ceil( 2*D / dx_half * 1.2 ),
      }
    },
    time_control = { min = tEnd, max = tEnd, interval = tEnd },
    output = {format = 'asciiSpatial'},
  },

} -- tracking
