-- Musubi configuration file. 

require "common" 

folderRead = 'restart_read/'
folderWrite = 'restart/'

--dt_loc = getdtFromVel( dx, u_in_phy, u_in_L )
dx = getdxFromLevel( {len_bnd=length_bnd, level=level})
--dx = getdxFromnL( {len_p=height, nL=nHeight})
--print (dx_loc)
--tab = { dx = dx, u_p = u_in_phy, u_l = u_in_L }

dt = getdtFromVel( {dx = dx, u_p = u_in_phy, u_l = u_in_L } )
omega = getOmegaFromdt( {dx=dx, dt=dt, nu_p = nu_phy } )
--print('dt_loc ', dt, dt_loc)
--dt_loc = getdtFromVisc( {dx = dx, nu_p = nu_phy, nu_l = nu_L} )
--print('dt_loc ', dt, dt_loc)
--omega = 1.9
--dt = getdtFromOmega( { dx = dx, nu_p = nu_phy, omega = omega} )
--u_in_L = getVelFromdt( {u_p=u_in_phy, dx=dx, dt=dt} )
--print('dt_loc ', dt, dt_loc)
-- This is a LUA script.

-- Simulation name
simulation_name = 'channel2D'
--mesh = 'mesh_sph/' -- Mesh information
mesh = 'mesh/' -- Mesh information
printRuntimeInfo = false
interpolation_method = 'linear'                     
-- Time step settigs
tmax_p = 10--s
tmax  =  tmax_p/dt    -- total iteration number
interval_p = tmax_p/10
sim_control = {
  time_control = { 
    max = {sim=tmax_p}, 
    interval = interval_p
   },
  abort_criteria = {
    stop_file = 'stop',
    steady_state = true,
    convergence = {
      variable = {'pressure_phy'}, 
      shape = {kind = 'canoND', object = {origin ={length*0.5,height*0.5,zpos} } },
      time_control = {min = 0, max = tmax_p, interval = 10*dt},
      reduction = 'average',
      norm='average', nvals = 50, absolute = true,
      condition = { threshold = 1.e-8, operator = '<=' }
    }
  }
}

--   time = {useIterations = false,
 --       min = 0, max = tmax_p, interval = interval_p}
        
alance = { static = false, dynamic = true, kind = 'levelwise',
            time_control = { interval = {iter=3}, min = {iter=14}, max = {iter=tmax}}
  }

ogging = {level=10}
ebug = { debugMode = true, debugFiles = true, debugNormal = true,
          debugMesh = './debug/mesh_', debugStates = { 
  write = {
    folder    = './debug/',    -- the folder the restart files are written to
    interval  = 1,           -- dump restart file interval
    tmin      = 0,           -- first timestep to output
    tmax      = tmax+1       -- last timestep to output
    }
 }} 


fluid = { 
        --!omega_ramping = {predefined='smooth', min_factor = 0.5, 
        --                    max_factor=1.0, from_time=0, to_time=10000.0*dt}, 
        --omega = omega, rho0 = 1.0, bulk_viscosity = 0.025221541 }
--         omega_spatial = omega_spatial,
--         omega = omega,
           kine_shear_viscosity = nu_phy,
           rho0 = rho0_p }


-- Initial condition
ref_press = rho0_p * (dx*dx)/(dt*dt)
initial_condition = { pressure = ref_press, 
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 }

identify = {label='bgk',layout='d3q19', relaxation='bgk',
            kind = 'lbm_incomp'
            }

-- needed to dump variable in physical unit
physics = { dt = dt, rho0 = rho0_p }            

glob_source = {
  force = 'prsgrad' 
}  

-- Boundary conditions
boundary_condition = {  
{ label = 'north', 
  kind = 'wall' ,
--   kind = 'slip_wall',
   fac = 1.0 },
{ label = 'south', 
   kind = 'wall' },
{ label = 'sphere', 
   kind = 'wall' }
 }

variable = {
  { name = 'prsgrad',
    ncomponents = 3,
    vartype = 'st_fun',
    st_fun = {anal_prsDrop/length,0.0,0.0}
  },
  { name = 'reynolds_fac',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = Dia/nu_phy
  },
  { name = 'reynolds_nr',
    ncomponents = 1,
    vartype = 'operation',
    operation = { kind='multiplication',
                  input_varname = {'vel_mag_phy','reynolds_fac'}}
  }
}

-- Tracking              
tracking = {
 {
   label = 'vtk', 
   folder = 'tracking/',
   variable = {'pressure_phy','velocity_phy','velocity','reynolds_nr'}, 
   shape = {kind = 'all'},
   time_control = {min= 0, max = tmax_p, interval = interval_p},
   output = { format = 'vtk' }   
 },
 {
   label = 'probe', 
   folder = 'tracking/',
   variable = {'pressure_phy','velocity_phy'}, 
   shape = {kind = 'canoND', object = {origin ={length*0.5,height*0.5,zpos} } },
   time_control = {min= {iter= 1}, max = {iter= tmax}, interval = {iter= 10}},
   output = { format = 'ascii' }
 },
 {
   label = 'prsDrop', 
   folder = 'tracking/',
   variable = {'pressure_phy'}, 
   shape = {kind = 'canoND', object = {origin ={0.0,height*0.5,zpos},
                                       vec = {length,0.0,0.0},
                                       segments = nLength+2} },
   time_control = {min = {iter= tmax}, max = {iter= tmax}, interval = {iter= tmax+1}},
   output = { format = 'asciiSpatial'}     
 },
 {
   label = 'velProfile', 
   folder = 'tracking/',
   variable = {'velocity_phy'}, 
   shape = {kind = 'canoND', object = {origin ={length*0.5,0.0,zpos},
                                       vec = {0.0,height,0.0},
                                       segments = nHeight+2} },
   time_control = {min = {iter= tmax}, max = {iter= tmax}, interval = {iter= tmax+1}},
   output = { format = 'asciiSpatial'}
 },

}

estart = {
      ead = 'restart/channel2D_lastHeader.lua',
      write = 'restart/',
      -- without timeControl table restart will be dumped at last timestep
      time_control = { min = 0, max = tmax_p, interval = interval_p},
}

