-- Musubi configuration file. 

require "common" 

folderRead = 'restart_read/'
folderWrite = 'restart/'

--dt_loc = getdtFromVel( dx, u_in_phy, u_in_L )
dx = getdxFromLevel( {len_bnd=length_bnd, level=level})
--dx = getdxFromnL( {len_p=height, nL=nHeight})
--print (dx_loc)
--tab = { dx = dx, u_p = u_in_phy, u_l = u_in_L }

dt = getdtFromVel( {dx = dx, u_p = u_in_phy, u_l = u_in_L } )
omega = getOmegaFromdt( {dx=dx, dt=dt, nu_p = nu_phy } )
--print('dt_loc ', dt, dt_loc)
--dt_loc = getdtFromVisc( {dx = dx, nu_p = nu_phy, nu_l = nu_L} )
--print('dt_loc ', dt, dt_loc)
--omega = 1.9
--dt = getdtFromOmega( { dx = dx, nu_p = nu_phy, omega = omega} )
--u_in_L = getVelFromdt( {u_p=u_in_phy, dx=dx, dt=dt} )
--print('dt_loc ', dt, dt_loc)
-- This is a LUA script.

-- Simulation name
simulation_name = 'channel2D'
--mesh = 'mesh_sph/' -- Mesh information
mesh = 'mesh/' -- Mesh information
printRuntimeInfo = false
-- Time step settigs
tmax_p = 2 --200 --s
tmax           =  tmax_p/dt    -- total iteration number
interval_p = tmax_p/10
sim_control = {
  time_control = {
    max = tmax_p, interval = interval_p
  }
}  
        
--balance = { active = false, dynamic = true, kind = 'levelwise',
--            time = { useIterations = true, interval = 3, min = 14, max = tmax}
--  }


ebug = { debugMode = true, debugFiles = true, debugNormal = true,
          debugMesh = './debug/mesh_', debugStates = { 
  write = {
    folder    = './debug/',    -- the folder the restart files are written to
    interval  = 1,           -- dump restart file interval
    tmin      = 0,           -- first timestep to output
    tmax      = tmax+1       -- last timestep to output
    }
 }} 


fluid = { 
        --!omega_ramping = {predefined='smooth', min_factor = 0.5, 
        --                    max_factor=1.0, from_time=0, to_time=10000.0*dt}, 
        --omega = omega, rho0 = 1.0, bulk_viscosity = 0.025221541 }
--         omega_spatial = omega_spatial,
--         omega = omega,
           kine_shear_viscosity = nu_phy,
           rho0 = rho0_p }

interpolation_method = 'linear'                     

-- Initial condition 
ref_press = 0.0
initial_condition = { pressure = ref_press, 
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 }

identify = {label='2D',layout='d3q19', relaxation='bgk',
            kind = 'lbm_incomp'
            }

-- needed to dump variable in physical unit
physics = { dt = dt, rho0 = rho0_p }            
-- Boundary conditions
boundary_condition = {  
{ label = 'west', 
  --kind = 'inlet_mfr_eq', 
  kind = 'inlet_mfr', 
  massflowrate = massflow_rate,
  --massflowrate = { kind = 'combined',
  --              transient= {predefined='smooth', min_factor = 0.0, 
  --                          max_factor=1.0, from_time=0, to_time=1000*dt}, 
  --              spatial = {predefined='parabol', 
  --                        shape = { kind = 'canoND', object = {origin  = {0.0,-0.0,-dx},
  --                                                             vec = {0.0,2*height,0.0} } 
  --                                }
  --                        ,amplitude = massflow_rate 
  --                       }         
  --                                  
  --	      },
   velocityY = 0.0, velocityZ = 0.0},
{ label = 'east',
   kind = 'outlet_expol',
   pressure =  ref_press}, 
{ label = 'north', 
  kind = 'wall' ,
--   kind = 'slip_wall',
   fac = 1.0 },
{ label = 'south', 
   kind = 'wall' },
--{ label = 'sphere', 
--   kind = 'wall' }
 }


-- Tracking              
racking = {
{
  label = 'probe', 
  folder = 'tracking/',
 variable = {'pressure_phy','velocity_phy'}, 
 shape = {kind = 'canoND', object = {origin ={length*0.5,height*0.5,zpos} } },
 time_control = {min = 0, max = tmax_p, interval = 10*dt},
  format = 'ascii'      
},
{
  label = 'prsDrop', 
  folder = 'tracking/',
 variable = {'pressure_phy'}, 
 shape = {kind = 'canoND', object = {origin ={0.0,height*0.5,zpos},
                                     vec = {length,0.0,0.0},
                                     segments = nLength+2} },
 time_control = {min = tmax_p},
  format = 'asciiSpatial'      
},
{
  label = 'velProfile', 
  folder = 'tracking/',
 variable = {'velocity_phy'}, 
 shape = {kind = 'canoND', object = {origin ={length*0.5,0.0,zpos},
                                     vec = {0.0,height,0.0},
                                     segments = nHeight+2} },
 time_control = {min = tmax_p},
  format = 'asciiSpatial'      
},
{ label = 'convergence',
  variable = {'pressure_phy'}, 
  shape = {kind = 'canoND', object = {origin ={length*0.5,height*0.5,zpos} } },
  time_control = {min = 0, max = tmax_p, interval = 10*dt},
  format='convergence',
  convergence = {norm='average', nvals = 50, absolute = true,
  condition = { threshold = 1.e-8, operator = '<=' }}
}
}

restart = {
      ead = 'restart/channel2D_lastHeader.lua',
      write = 'restart/',
      time_control = { min = tmax_p+dt}
}

if os.getenv('mode') == 'read' then
  print ('   READ MODE ')
restart = { read = folderWrite..'channel2D_header_00000000.000E+00.lua',
            write = folderRead,
            time_control = { min = 0, max = tmax_p, interval = interval_p}}
elseif os.getenv('mode') == 'write' then
  print ('   WRITE MODE ')
restart = { 
            write = folderWrite,
            time_control = { min = 0, max = tmax_p, interval = interval_p}}
elseif os.getenv('mode') == 'write_tmax' then
  print ('   WRITE at TMAX ')
restart = { 
            write = folderWrite,
            time_control = { min = tmax_p+dt}}
end

