import os
apesFolder = os.getenv('HOME')+'/apes/'
# Production directory - default production directory is 'prod'
# comment out if you don't want user defined production directory
prod_dir = 'convergence'

shepherd_jobs = []

shepherd_jobs.append(dict(executable=apesFolder+'seeder/build/seeder',
                          template='seeder.template',
                          extension='lua',
                          run_exec = False,
                          run_command = '',
                          params = [['nHeight', 8*2, 8*2**2, 8*2**3, 8*2**4  ],
                                    ['bc_type','moments','BounceBack']],
                                    #['bc_type','moments']],
                          additional_params = dict(MESH='mesh/'),
                          create_subdir = ['mesh'],
                          prefix = 'sdr',
                          label = 'seeder'))

shepherd_jobs.append(dict(executable=apesFolder+'musubi/build/musubi',
                          template='musubi.template',
                          extension='lua',
                          run_exec = False,
                          run_command = 'mpirun -np 4',
                          params = [["omega", 0.8, 1.3] 
                                   ],
                          additional_params = dict(MESH='../mesh/'),
                          create_subdir = ['tracking','restart'],
                          prefix = 'mus',
                          depend = ['seeder'],
                          create_depend_path = True,
                          label = 'musubi'))

shepherd_jobs.append(dict(executable=apesFolder+'harvester/gleaner/gleaner.py',
                          template = 'params_plot_error.py',
                          extension='py',
                          run_exec = True,
                          run_command = '',
                          depend = ['seeder','musubi'],
                          #depend = ['musubi'],
                          run_last = True,
                          create_depend_path = True,
                          create_depend_params = True,
                          label = 'gleaner'))

