-- Use this file as template. Do not modify this file for running some testcases

require "common"
qVal = false

folder = 'mesh/'--..subprefix
logging = {level=10}
ebug = {debugMode = true, debugFiles=true}

-- bounding_cube: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = {-dx/1.-dx_offset/2.0,-dx/1.-dx_offset/2.0-offset,-dx/1.-dx_offset/2.0-offset},
               length = length_bnd}

minlevel = level

--  spatial object is composed by the attribute and Geometry

spatial_object = {
  {
    attribute = {
      kind = 'seed',  ------seed
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { 4*dx, height*0.5-offset, zpos },
        } --- object
    }
  },
  {
    attribute = {
      kind = 'boundary',  ---kind in attribute is seed/boundary/refinement/periodic
      label = 'north',     -- for north
      calc_dist = qVal,
    },
    geometry = {
      kind = 'canoND',    -- kind in geometry is canoND/sphere/stl 
      object = {
        origin = { -dx,height+dx_half+dx_offset-offset,-dx-offset },
        vec = {{length/1.0+4*dx,0.0,0.0},
               {0.0,0.0,height+4.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'south',   --- for south
      calc_dist = qVal,
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx,-dx/2.-dx_offset-offset,-dx-offset},
        vec = {{length/1.0+4*dx,0.0,0.0},
               {0.0,0.0,height+4.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'top'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx,-dx-offset,height+dx_half+dx_offset-offset},
        vec = {{length+4*dx,0.0,0.0},
             {0.0,height+2*dx,0.0}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'bottom'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx,-dx-offset,-dx_half-dx_offset-offset},
        vec = {{0.0,height+2*dx,0.0},
               {length+4*dx,0.0,0.0}}
      }
    }  
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'west'     --- for west
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx/2.0-dx_offset,-dx-offset,-dx-offset},
        vec = {{0.0,height+4*dx,0.0},
               {0.0,0.0,height+4.*dx}}
        }
    }
  },

  {
    attribute = {
      kind = 'boundary',
      label = 'east'     --- for east
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {length+dx/2.0+dx_offset,-dx-offset,-dx-offset},
        vec = {{0.0,height+4*dx,0.0},
               {0.0,0.0,height+4.*dx}}
        }
    }
  },
}
