-- common header --
level = 8
refinementLevel = 1
refinementLevel2 = 0
label = 'channel'
idLabel = 'channel'

shepherd = true
if shepherd then
  stlFolder = '$!stl_path!$'
else
  stlFolder = 'stl/'
end
-- geometry definition
qValues     = true
usePeriodic = true
periodicX = false
useObstacle = true
case2d=false
walls = true
testIntersection = false
simName = 'channelRefine'
verbose = false
height = 1.  -- will be adapted to be exactly resolved by the discretization
ratio  = 8.  -- will be adapted to be exactly resolved by the discretization
length = ratio*height
radius = 0.1*height
fixHeight=true
if fixHeight then
  -- here should be the logic how to fix the height of the channel.
  -- probably define a number of elements in the height?
  -- such as 2^(level-4) 
  -- -> nH(l=7) = 8
  -- -> nH(l=8) = 16 ...
  nElemsHeight = 2^(level-4)
  dx = height/nElemsHeight
  nElemsLength = nElemsHeight*ratio + 2 -- need inlet and outlet element
  -- compute the reuquired level by
  level = math.ceil( math.log(nElemsLength)/math.log(2))
  lengthSeeder = 2^level*dx
--  print('nELemsheight'..nElemsHeight)
--  print('nELemsLength'..nElemsLength)
--  print('height      '..height      )
--  print('length      '..length      )
--  print('lengthSeeder'..lengthSeeder)
else
  -- computation of the discrete sizes.
  -- fixing the length and adapting the height to such a ratio
  -- that the half-height is always integer multiples of dx
  lengthSeeder = length/(1.-2./2.^level)
  dx  = lengthSeeder/(2^level)
  -- now adapt H
  nElemsHeight = 2.*math.floor(length/(dx*2.*ratio))
  height = nElemsHeight*dx
end 

--
maxLevel = level+math.max(refinementLevel, refinementLevel2)
dxMin  = lengthSeeder/(2^maxLevel)
dxDash = 0.5*dxMin
heightLB = nElemsHeight
heightPhys = heightLB*dx
-- physical reference values
dxPhys = dx
lPhys = length  -- m
nElemsMax = 2^maxLevel

-- Use this file as template. Do not modify this file for running some testcases
outputname = 'channel_2D'
outputpreview = true
folder = 'mesh/' 

ebug = {debugMode = true, debugMesh = './prototree/'}
size_x = 0.2*length
start_x = -0.5*size_x
if useObstacle then
  size_x = 0.68*length
  start_x = -0.45*length
  size_y = 2.*height/5.-5.*dxDash
  if testIntersection then
    start_x = -0.35*length
  end
else
  size_y = height/5-5.*dxDash
end
start_y = -size_y/2
size_z = size_y
start_z = start_y

start2_x = -0.32*length
size2_x  = 0.37*size_x
size2_y = size_y*0.48
start2_y = -size2_y/2
size2_z = size2_y
start2_z = start2_y

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = {-lengthSeeder*0.5, -lengthSeeder*.5, -lengthSeeder*0.5},
               length = lengthSeeder}

minlevel=level
spatial_object = {
  {
    attribute = {
      kind = 'refinement',
      level = refinementLevel+level,
      label='box1'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {start_x, start_y, start_z },
        vec = {{size_x, 0., 0.},
              {0.,size_y, 0.},
              {0., 0., size_z}}
      }
    }
  },
  {
    attribute = {
      kind = 'refinement',
      level = refinementLevel2+level,
      label='box2'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {start2_x, start2_y, start2_z },
        vec = {{size2_x, 0., 0.},
              {0.,size2_y, 0.},
              {0., 0., size2_z}}
      }
    }
  },
  { attribute = { kind = 'seed', },
    geometry = { kind = 'canoND',
                 object = { origin = { 0.0, 0.0, dx*0.5 },
               }
    } -- geometry
  }, -- seed

}

if useObstacle ==true then
  if case2d or usePeriodic then
    stlfile=stlFolder..'cylinder.stl'
  else
    stlfile=stlFolder..'sphere.stl'
  end
  if qValues then
    table.insert(spatial_object,  { 
      attribute = { 
        kind = 'boundary', 
        level = maxLevel,
        label = 'sphere', 
        calc_dist = qValues,
      },
      geometry = {
        kind = 'stl', -- was: sphere
        object = { filename = stlfile
  --        { origin = {-length*0.3,-0.01*height,0.},
  --          radius = radius }
        }
      },
      transformation = {
        deformation =  {radius,radius,radius },
        translation =  {-length*0.38, 0., 0. }
      }
      }) 
  else
    table.insert(spatial_object,  { 
      attribute = { 
        kind = 'boundary', 
        level = maxLevel,
        label = 'sphere', 
        calc_dist = qValues,
      },
      geometry = {
        kind = 'cylinder', -- was: sphere
        object = { --filename = stlFolder..'cylinder.stl',
          { 
            origin = {-length*0.38,-0.01*height,-lengthSeeder*0.5},
        vec = {0.0,.0,lengthSeeder}, -- length and axis of the cylinder
            radius = radius }
        }
      }
      }) 
  end
end
if walls == true then
  table.insert(spatial_object,  { 
    attribute = {
      kind = 'boundary',
      label='north'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-length*0.5, height*0.5+dxDash, -length*0.5},
        vec = {{length, 0.0, 0.},
              {0.,0.0, length}}
      }
    }
  })  
  table.insert(spatial_object,  { 
    attribute = {
      kind = 'boundary',
      label='south'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-length*0.5,-height*0.5-dxDash, -length*0.5},
        vec = {{length, 0.0, 0.},
              {0.,0.0, length}}
      }
    }
  })
end
if periodicX == true then
  table.insert(spatial_object, { 
    attribute = { 
      kind = 'periodic', 
      label = 'periodicX'
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = { -length/2+1.3*dx, -length/2, -length*0.5},
          vec = { 
            { 0.0, 0.0, length },
            { 0.0, length, 0.0 },
            }
        }, -- plane 1
        plane2 = {
          origin = { length/2-1.3*dx,  -length/2, -length*0.5},
          vec = { 
            { 0.0, length, 0.0 },
            { 0.0, 0.0, length },
            }
        }, -- plane 2
      } -- object
    } -- geometry

  }) 
else
  -- inlet / outlet boundary conditions
  table.insert(spatial_object,  { 
    attribute = {
      kind = 'boundary',
      label='east'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {length*0.5+dxDash, -length*0.5, -length*0.5},
        vec = {{0.0, length, 0.},
              {0.,0.0, length}}
      }
    }
    }) 
  table.insert(spatial_object,  { 
    attribute = {
      kind = 'boundary',
      label='west'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-length*0.5-dxDash, -length*0.5, -length*0.5},
        vec = {{0.0, length, 0.},
              {0.,0.0, length}}
      }
    }
  })
end 

if usePeriodic == true then
  table.insert(spatial_object, { 
    attribute = { 
      kind = 'periodic', 
      label = 'periodic'
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = { -length/2, -length/2, dx+dxDash},
          vec = { { length, 0.0, 0.0},
                  { 0.0, length, 0.0},}
        }, -- plane 1
        plane2 = {
          origin = { -length/2,  -length/2, -dxDash},
          vec = { { 0., length, 0.0, 0.0},
                  { length, 0., 0.0},}
        }, -- plane 2
      } -- object
    } -- geometry

  }) 
else
  if case2d then
    depth = 4*dx
  else
    depth=height
  end
  table.insert(spatial_object, { 
    attribute = { 
      kind = 'boundary', 
      label = 'frontback'
    },
    geometry = {
      kind = 'canoND',
      object = {
        {
          origin = { -length/2, -length/2, depth/2+dxDash},
          vec = { { length, 0.0, 0.0},
                  { 0.0, length, 0.0},}
        }, -- plane 1
        {
          origin = { -length/2, -length/2, -depth*0.5-dxDash},
          vec = { { length, 0.0, 0.0},
                  { 0.0, length, 0.0},}
        }, -- plane 2
      } -- object
    } -- geometry

  }) 
end

