-- Musubi configuration file. 
-- This is a LUA script.
require 'common'
tracking_fol = 'tracking/'
restart_fol = 'restart/'

dx = getdxFromLevel( {len_bnd=length_bnd, level=level})
dt = getdtFromVel( {dx = dx, u_p = u_max_phy, u_l = u_max_L } )
omega = getOmegaFromdt( {dx=dx, dt=dt, nu_p = nu_phy } )

if qVal then 
  bc_nozzle = 'wall_linearInterpolation'
else
  bc_nozzle = 'wall'
end

-- Simulation name
simulation_name = 'nozzle'
-- Mesh information
mesh = 'mesh/'

-- Time step settings
walltime = 2*60*60 - 5*60
tmax_p = 5 --s
tmax           =  tmax_p/dt     -- total iteration number
interval = 2000
sim_control = {
  time_control = {
    max = {sim=tmax_p,clock=walltime}, 
    interval = {iter=interval}}
}    

-- needed to dump variable in physical unit
physics = { dt = dt, rho0 = rho0_p }            

-- physics setting
fluid = { 
       omega_ramping = {predefined='smooth', min_factor = 0.7, max_factor=1.0, 
       from_time=0, to_time=1}, 
       omega = omega, 
       rho0 = rho0_p }

interpolation_method = 'quadratic'
--control_routine = 'fast'
scaling = 'acoustic'
comm_reduced = true
                     
-- Initial condition 
initial_condition = { pressure = p0_p, 
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 }


identify = {layout='d3q19',relaxation='mrt_les', kind = 'lbm_incomp'}


-- Boundary conditions
boundary_condition = {  
 { label = 'inlet', 
   kind = 'inlet_ubb', 
--   order = 1,
   velocity = { 
     predefined = 'combined',
     temporal = {
       predefined='smooth', 
       min_factor = 0.0, 
       max_factor=1.0, 
       from_time=0, 
       to_time=1
     }, 
     spatial = {u_mean_phy,0.0,0.0}--u_inflow 
   }
 }
,{ label = 'outlet', 
   kind = 'outlet_expol',
   pressure = p0_p}
,{ label = 'nozzle', 
   kind = bc_nozzle}
--,{ label = 'slip', 
--   kind = 'slip_wall'}
--,{ label = 'front', 
--   kind = 'slip_wall'}
--,{ label = 'top', 
--   kind = 'slip_wall'}
--,{ label = 'back', 
--   kind = 'slip_wall'}
}


--tracking time_control
trac_time = {min = 0, max= tmax_p, interval = {iter=100}}

-- Tracking              
tracking = {
 {
   label = 'vtk', 
   folder = tracking_fol,
   variable = {'pressure_phy','velocity_phy','shear_stress_phy'}, 
   shape = {kind = 'all' },
   time_control = {min = 0.0, 
     max = {sim=tmax_p,clock=walltime}, 
     interval=1.0},
   output = {format = 'vtk'}
 }
,{label='line',
    folder=tracking_fol,
    variable={'pressure_phy','velocity_phy'},
    shape = {kind='canoND', object={origin={-inlet_2_nozzleCenter+dx,0.0,0.0},
                                    vec={{l_ch,0.0,0.0}},
             segments = {nLength}}},
    time_control = {min = tmax_p, max= tmax_p, interval = tmax_p},
    output = {format = 'asciiSpatial'}
 }  
,{label='probe_neck',
    folder=tracking_fol,
    variable={'pressure_phy','velocity_phy'},
    shape = {kind='canoND', 
             object={origin={nozzle_inner_dia_X,0.0,0.0}}},
    time_control = trac_time,
    output = {format = 'ascii'}
 }   
,{label='probe_outer',
    folder=tracking_fol,
    variable={'pressure_phy','velocity_phy'},
    shape = {kind='canoND', 
             object={origin={outlet_2_nozzleCenter/2.0,0.0,0.0}}},
    time_control = trac_time,
    output = {format = 'ascii'}
 }    
}

-- restart 
restart = {
      ead = restart_fol..'/nozzle_lastHeader.lua',
      write = restart_fol,
      time_control = { min = tmax_p}
}
