-- Musubi configuration file. 
-- This is a LUA script.
require 'common'
tracking_fol = 'tracking/'
restart_fol = 'restart/'

dx = getdxFromLevel( {len_bnd=length_bnd, level=level})
dt = getdtFromVel( {dx = dx, u_p = u_max_phy, u_l = u_max_L } )
omega = getOmegaFromdt( {dx=dx, dt=dt, nu_p = nu_phy } )

if qVal then 
  bc_nozzle = 'wall_linearInterpolation'
else
  bc_nozzle = 'wall'
end

-- Simulation name
simulation_name = 'nozzle'
-- Mesh information
mesh = 'mesh/'

logging = {level=10}

-- Time step settings
tmax_p = 1 --s
tmax           =  tmax_p/dt     -- total iteration number
interval = 1000
sim_control = {
  time_control = {
    max = {sim=tmax_p}, 
    interval = {iter=interval}
  },
  abort_criteria = {
    steady_state = true,
    convergence = { 
      variable = {'pressure_phy'}, 
      shape = {kind = 'canoND', object= {origin = {0.0,0.0,0.0}}},
      time_control = {min = 0, max = tmax_p, interval = {iter=10}},
      reduction = {'average'},
      norm='average', nvals = 50, absolute = true,
      condition = { threshold = 1.e-8, operator = '<=' }
    }
  }   
}    

-- needed to dump variable in physical unit
physics = { dt = dt, rho0 = rho0_p }            

-- physics setting
fluid = { 
        --omega_ramping = {predefined='smooth', min_factor = 0.5, max_factor=1.0, 
        --from_time=0, to_time=1000*dt}, 
       omega = omega, 
       rho0 = rho0_p }

interpolation_method = 'quadratic'
--control_routine = 'fast'
scaling = 'diffusive'
                     
-- Initial condition 
initial_condition = { pressure = p0_p, 
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 }


identify = {label='nozzle',layout='d3q19',relaxation='mrt', kind = 'lbm_incomp'}


-- Boundary conditions
boundary_condition = {  
 { label = 'inlet', 
   kind = 'inlet_ubb', 
  velocity = { predefined = 'combined',
              temporal= {predefined='smooth', min_factor = 0.5, max_factor=1.0, 
              from_time=0, to_time=1000*dt}, 
              spatial = {u_mean_phy,0.0,0.0}--u_inflow 
	      },
 }
,{ label = 'outlet', 
   kind = 'outlet_expol',
   pressure = p0_p}
,{ label = 'nozzle', 
   kind = bc_nozzle}
--,{ label = 'slip_wall', 
--   kind = 'slip_wall',
--   pressure = p0_p}
--,{ label = 'wall', 
--   kind = 'slip_wall'}
}



-- Tracking              
tracking = {
{
  label = 'vtk', 
  folder = tracking_fol,
  variable = {'pressure_phy','velocity_phy','shear_stress_phy','velocity'}, 
  shape = {kind = 'all' },
  time_control = {min = 0.0, max=tmax_p, interval={sim=tmax_p/10}},
  output = {format = 'vtk'}      
},
}

--tracking time_control
trac_time = {min = 0, max= tmax_p, interval = {iter=100}}

--   table.insert(tracking, {label='line_pressure_',
--                         folder=tracking_fol,
--                       variable={'pressure_phy'},
--                     shape = {kind='canoND', object={origin={l_m,h_ch/2.0,w_ch/2.0},
--                                                  vec={{l_ch,0.0,0.0}},
--                                                segments = {nHeight, nWidth}}},
--               time_control = trac_time,
--             format = 'asciiSpatial'})

--
--if nFilament >= 2 then
--  for i = 1, nFilament  do
--    table.insert(tracking, {label='av_pressure_'..i,
--                            folder=tracking_fol,
--                            variable={'pressure_phy'},
--                            shape = {kind='canoND', object={origin={l_m*i,0.0,0.0},
--                                                           vec={{0.0,h_ch,0.0},{0.0,0.0,w_ch}},
--                                                           segments = {nHeight, nWidth}}},
--                            reduction = 'average',
--                            time_control = trac_time,
--                            format = 'ascii'})
--
--
--    table.insert(tracking, {label='planeReduction_'..i,
--                            folder=tracking_fol,
--                            variable={'vel_mag_phy'},
--                            shape = {kind='canoND', object={origin={l_m*i,0.0,0.0},
--                                                           vec={{0.0,h_ch,0.0},{0.0,0.0,w_ch}},
--                                                           segments = {nHeight, nWidth}}},
--                            reduction = 'average',
--                            time_control = trac_time,
--                            format = 'ascii'})
--
--
--    table.insert(tracking, {label='probe_w2_'..i,
--                            folder=tracking_fol,
--                            variable={'pressure_phy','velocity_phy','vel_mag_phy'},
--                            shape = {kind='canoND', object={origin={l_m*i,h_ch/2.0,w_ch/2.0}},
--							    vec={{0.0,h_ch,0.0},{0.0,0.0,w_ch}},
--							    segments = {nHeight,nWidth}},
--                            reduction = {'average','average', 'average'},
--                            time_control = trac_time,
--                            format = 'ascii'})
--
----    for j = 1, 8, 2 do
--  --    table.insert(tracking, {label='probe_'..j..'w8_'..i,
--    --                          folder=tracking_fol,
--      --                        variable={'pressure','velocity','velMag'},
--        --                      shape = {kind='canoND', object={origin={2*l_m*i,h_ch/2.0,j*w_ch/8.0}}},
--          --                    time_control = trac_time,
--            --                  format = 'ascii'})
----    end                          
--  end
--end  
           

-- restart 
NOrestart = {
      ead = restart_fol..'/spacer_lastHeader.lua',
      write = restart_fol,
      time_control = { min = tmax_p}
}
